/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.util.rmi;

import java.rmi.ConnectException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.ExportException;
import java.rmi.server.UnicastRemoteObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.rmi.RemoteMethodExecutorImpl;

public final class ServiceExporter {
    private static final Log log = LogFactory.getLog(ServiceExporter.class);
    private static final int PORT = 12345;

    protected static void testRmiConfig() {
        String rmiHost = System.getProperty("java.rmi.server.hostname");
        if ((rmiHost == null || "".equals(rmiHost.trim())) && log.isWarnEnabled()) {
            log.warn("Server might not have been initialized properly, please specify '-Djava.rmi.server.hostname=<IP-address>'");
        }
    }

    protected static Registry getRegistry() throws RemoteException {
        Registry result;
        try {
            result = LocateRegistry.getRegistry(12345);
            result.list();
        }
        catch (ConnectException ce) {
            if (log.isWarnEnabled()) {
                log.warn("Registry not found, creating a new one");
            }
            try {
                result = LocateRegistry.createRegistry(12345);
            }
            catch (ExportException ee) {
                if (log.isWarnEnabled()) {
                    log.warn("Unable to create registry, try using the default one", ee);
                }
                result = LocateRegistry.getRegistry();
            }
        }
        return result;
    }

    public static <E> void registerService(Class<E> serviceInterface, E instance) throws RemoteException {
        String rmiName = serviceInterface.getName();
        ServiceExporter.registerService(rmiName, instance);
    }

    public static <E> void registerService(String rmiName, E instance) throws RemoteException {
        ServiceExporter.testRmiConfig();
        RemoteMethodExecutorImpl<E> executor = new RemoteMethodExecutorImpl<E>(instance);
        Remote stub = UnicastRemoteObject.exportObject(executor, 0);
        Registry registry = ServiceExporter.getRegistry();
        registry.rebind(rmiName, stub);
    }

    public static void unregisterService(Class<?> serviceInterface) throws RemoteException, NotBoundException {
        String rmiName = serviceInterface.getName();
        ServiceExporter.unregisterService(rmiName);
    }

    public static void unregisterService(String rmiName) throws RemoteException, NotBoundException {
        Registry registry = ServiceExporter.getRegistry();
        registry.unbind(rmiName);
    }
}

