/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.math.matrix;

import java.io.Serializable;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import org.nuiton.math.matrix.AbstractMatrixND;
import org.nuiton.math.matrix.MatrixHelper;
import org.nuiton.math.matrix.MatrixIterator;
import org.nuiton.math.matrix.MatrixND;

public class SubMatrix
extends AbstractMatrixND {
    private static final long serialVersionUID = 4092234115185263506L;
    protected MatrixND matrix = null;
    protected DimensionConverter converter = null;

    public SubMatrix(MatrixND matrix, int dim, int start, int nb) {
        super(matrix.getFactory(), matrix.getName(), matrix.getSemantics(), matrix.getDimensionNames());
        this.matrix = matrix;
        this.converter = new ShiftConverter(dim, start, nb);
        this.setSemantic(dim, this.getSemantic(dim).subList(start, start + nb));
        this.getDim()[dim] = nb;
    }

    public SubMatrix(MatrixND matrix, int dim, int[] elem) {
        super(matrix.getFactory(), matrix.getName(), matrix.getSemantics(), matrix.getDimensionNames());
        this.matrix = matrix;
        this.converter = new MappingConverter(dim, elem);
        List oldSemantic = this.getSemantic(dim);
        LinkedList newSemantic = new LinkedList();
        for (int i = 0; i < elem.length; ++i) {
            newSemantic.add(oldSemantic.get(elem[i]));
        }
        this.setSemantic(dim, newSemantic);
        this.getDim()[dim] = elem.length;
    }

    @Override
    public int getNumberOfAssignedValue() {
        return this.matrix.getNumberOfAssignedValue();
    }

    @Override
    public MatrixIterator iterator() {
        return new SubMatrixIteratorImpl(this);
    }

    @Override
    public MatrixIterator iteratorNotZero() {
        return new SubMatrixExcludeIteratorImpl(this, 0.0);
    }

    @Override
    public double getValue(int[] coordinates) {
        return this.matrix.getValue(this.converter.convertCoordinates(coordinates));
    }

    @Override
    public void setValue(int[] coordinates, double d) {
        this.matrix.setValue(this.converter.convertCoordinates(coordinates), d);
    }

    protected static class MappingConverter
    implements DimensionConverter {
        private static final long serialVersionUID = -6367416559713556559L;
        protected int dim;
        protected int[] elem = null;

        public MappingConverter(int dim, int[] elem) {
            this.dim = dim;
            this.elem = new int[elem.length];
            System.arraycopy(elem, 0, this.elem, 0, elem.length);
        }

        @Override
        public int[] convertCoordinates(int[] coordinates) {
            int[] result = null;
            if (coordinates[this.dim] >= this.elem.length) {
                throw new NoSuchElementException("L'indice est sup\u00e9rieur au nombre d'\u00e9lements de la sous matrice pour cette dimension.");
            }
            result = new int[coordinates.length];
            System.arraycopy(coordinates, 0, result, 0, result.length);
            result[this.dim] = this.elem[coordinates[this.dim]];
            return result;
        }
    }

    protected static class ShiftConverter
    implements DimensionConverter {
        private static final long serialVersionUID = 1L;
        protected int dim;
        protected int start;
        protected int nb;

        public ShiftConverter(int dim, int start, int nb) {
            this.dim = dim;
            this.start = start;
            this.nb = nb;
        }

        @Override
        public int[] convertCoordinates(int[] coordinates) {
            int[] result = null;
            if (coordinates[this.dim] >= this.nb) {
                throw new NoSuchElementException("L'indice est sup\u00e9rieur au nombre d'\u00e9lement de la sous matrice pour cette dimension.");
            }
            result = new int[coordinates.length];
            System.arraycopy(coordinates, 0, result, 0, result.length);
            result[this.dim] = result[this.dim] + this.start;
            return result;
        }
    }

    protected static interface DimensionConverter
    extends Serializable {
        public int[] convertCoordinates(int[] var1);
    }

    protected class SubMatrixExcludeIteratorImpl
    implements MatrixIterator {
        protected double exclude;
        protected SubMatrix subMatrix;
        protected int[] dim;
        protected int[] last;
        protected int[] coordinates;
        protected int[] cpt;
        protected int[] nextCpt;
        protected double value;
        protected double nextValue;
        protected Object[] posSems;

        public SubMatrixExcludeIteratorImpl(SubMatrix subMatrix, double exclude) {
            this.subMatrix = subMatrix;
            this.exclude = exclude;
            this.posSems = new Object[subMatrix.getDimCount()];
            this.dim = subMatrix.getDim();
            this.coordinates = new int[this.dim.length];
            this.cpt = new int[this.dim.length];
            this.cpt[this.cpt.length - 1] = -1;
            this.nextCpt = new int[this.dim.length];
            this.nextCpt[this.nextCpt.length - 1] = -1;
            this.last = new int[this.dim.length];
            for (int i = 0; i < this.last.length; ++i) {
                this.last[i] = this.dim[i] - 1;
            }
        }

        protected boolean arrayGreaterOrEquals(int[] cpt1, int[] cpt2) {
            boolean result = true;
            int max = cpt1.length;
            for (int i = 0; result && i < max; ++i) {
                result = cpt1[i] >= cpt2[i];
            }
            return result;
        }

        protected void computeNextCpt() {
            int ret = 1;
            for (int i = this.nextCpt.length - 1; i >= 0; --i) {
                this.nextCpt[i] = this.nextCpt[i] + ret;
                ret = this.nextCpt[i] / this.dim[i];
                if (i == 0) continue;
                this.nextCpt[i] = this.nextCpt[i] % this.dim[i];
            }
        }

        protected void computeNextPosAndValue() {
            if (this.arrayGreaterOrEquals(this.cpt, this.nextCpt)) {
                boolean validPos;
                do {
                    this.computeNextCpt();
                    validPos = this.arrayGreaterOrEquals(this.last, this.nextCpt);
                    if (!validPos) continue;
                    this.nextValue = this.subMatrix.getValue(this.nextCpt);
                } while (validPos && this.nextValue == this.exclude);
            }
        }

        @Override
        public boolean hasNext() {
            this.computeNextPosAndValue();
            return this.arrayGreaterOrEquals(this.last, this.nextCpt);
        }

        @Override
        public boolean next() {
            boolean result = this.hasNext();
            System.arraycopy(this.nextCpt, 0, this.cpt, 0, this.nextCpt.length);
            this.value = this.nextValue;
            return result;
        }

        @Override
        public int[] getCoordinates() {
            System.arraycopy(this.cpt, 0, this.coordinates, 0, this.cpt.length);
            return this.coordinates;
        }

        @Override
        public Object[] getSemanticsCoordinates() {
            Object[] result = MatrixHelper.dimensionToSemantics(this.posSems, this.subMatrix.getSemantics(), this.cpt);
            return result;
        }

        @Override
        public double getValue() {
            return this.value;
        }

        @Override
        public void setValue(double value) {
            this.value = value;
            this.subMatrix.setValue(this.cpt, value);
        }
    }

    protected class SubMatrixIteratorImpl
    implements MatrixIterator {
        protected SubMatrix subMatrix = null;
        protected int[] cpt = null;
        protected int[] last = null;
        protected Object[] posSems;

        public SubMatrixIteratorImpl(SubMatrix subMatrix) {
            this.subMatrix = subMatrix;
            this.posSems = new Object[subMatrix.getDimCount()];
            this.cpt = new int[subMatrix.getDimCount()];
            this.cpt[this.cpt.length - 1] = -1;
            this.last = new int[subMatrix.getDimCount()];
            for (int i = 0; i < this.last.length; ++i) {
                this.last[i] = subMatrix.getDim(i) - 1;
            }
        }

        @Override
        public boolean hasNext() {
            return !Arrays.equals(this.cpt, this.last);
        }

        @Override
        public boolean next() {
            boolean result = this.hasNext();
            int ret = 1;
            int[] dim = SubMatrix.this.getDim();
            for (int i = this.cpt.length - 1; i >= 0; --i) {
                this.cpt[i] = this.cpt[i] + ret;
                ret = this.cpt[i] / dim[i];
                this.cpt[i] = this.cpt[i] % dim[i];
            }
            return result;
        }

        @Override
        public int[] getCoordinates() {
            return this.cpt;
        }

        @Override
        public Object[] getSemanticsCoordinates() {
            int[] coordinates = this.getCoordinates();
            Object[] result = MatrixHelper.dimensionToSemantics(this.posSems, this.subMatrix.getSemantics(), coordinates);
            return result;
        }

        @Override
        public double getValue() {
            return this.subMatrix.getValue(this.getCoordinates());
        }

        @Override
        public void setValue(double value) {
            this.subMatrix.setValue(this.getCoordinates(), value);
        }
    }
}

