/*
 * #%L
 * NuitonMatrix
 * 
 * $Id: MapFunction.java 323 2011-01-22 09:32:20Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/nuiton-matrix/tags/matrix-2.2.1/nuiton-matrix/src/main/java/org/nuiton/math/matrix/MapFunction.java $
 * %%
 * Copyright (C) 2004 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package org.nuiton.math.matrix;

/**
 * Permet de faire un traitement sur des valeurs et d'en retourner 
 * des nouvelles.
 *
 * Created: 27 oct. 2004
 *
 * @author Benjamin Poussin <poussin@codelutin.com>
 * @version $Revision: 323 $
 *
 * Mise a jour: $Date: 2011-01-22 10:32:20 +0100 (sam., 22 janv. 2011) $
 * par : $Author: tchemit $
 */
public interface MapFunction { // MapFunction

    /**
     * Permet de faire un traitement sur value et de retourne une nouvelle
     * valeur.
     * 
     * @param value la valeur courante sur lequel il faut faire le traitement
     * @return la nouvelle valeur à mettre dans la matrice à la place de
     *         l'ancienne.
     */
    double apply(double value);

} // MapFunction
