/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jrst;

import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.doxia.parser.Parser;
import org.apache.maven.doxia.site.decoration.Menu;
import org.apache.maven.doxia.site.decoration.MenuItem;
import org.apache.maven.doxia.siterenderer.DefaultSiteRenderer;
import org.apache.maven.doxia.siterenderer.DocumentRenderer;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.doxia.siterenderer.RendererException;
import org.apache.maven.doxia.siterenderer.RenderingContext;
import org.apache.maven.doxia.siterenderer.SiteRenderingContext;
import org.apache.maven.project.MavenProject;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.i18n.I18N;
import org.codehaus.plexus.velocity.VelocityComponent;
import org.dom4j.Document;
import org.nuiton.jrst.AbstractJrstParser;
import org.nuiton.jrst.JRST;
import org.nuiton.jrst.ReflectUtil;

@Component(role=Renderer.class, hint="default")
public class JrstSiteRenderer
extends DefaultSiteRenderer {
    public static final String DEFAULT_PDF_FILENAME = "site";
    protected List<Locale> locales;
    protected Locale locale;
    protected MavenProject mavenProject;
    protected boolean pdfGenerationEnabled;
    protected boolean verbose;
    @Requirement(role=Parser.class, hint="jrst", optional=true)
    protected AbstractJrstParser jrstParser;

    public void render(Collection<DocumentRenderer> documents, SiteRenderingContext siteRenderingContext, File outputDirectory) throws RendererException, IOException {
        this.locale = siteRenderingContext.getLocale();
        this.locales = Collections.unmodifiableList(siteRenderingContext.getSiteLocales());
        Map templateProperties = siteRenderingContext.getTemplateProperties();
        this.mavenProject = (MavenProject)templateProperties.get("project");
        this.verbose = this.getBooleanProperty("site.verbose") || this.getLogger().isDebugEnabled();
        this.pdfGenerationEnabled = this.getBooleanProperty("pdfGenerationEnabled");
        super.render(documents, siteRenderingContext, outputDirectory);
        if (this.pdfGenerationEnabled) {
            List<String> relativPathsFromMenu = this.getDocumentRelativePathsFromMenu(siteRenderingContext);
            Map<String, String> relatifPaths = this.buildDocMap(documents);
            List<String> documentRefs = this.getDocumentRefs(relatifPaths, relativPathsFromMenu);
            if (CollectionUtils.isEmpty(documentRefs)) {
                if (this.getLogger().isInfoEnabled()) {
                    this.getLogger().info("No document to put in pdf, skip pdf generation.");
                }
            } else {
                String pdfFilename = this.getPdfFileName();
                try {
                    Field i18nField = ReflectUtil.getField(DefaultSiteRenderer.class, "i18n");
                    I18N i18n = (I18N)i18nField.get((Object)this);
                    this.renderPdf(i18n, documentRefs, siteRenderingContext, outputDirectory, pdfFilename);
                }
                catch (Exception e) {
                    this.getLogger().error("Can't find rst resource to generate pdf documentation", (Throwable)e);
                }
            }
        }
    }

    public void renderDocument(Writer writer, RenderingContext renderingContext, SiteRenderingContext context) throws RendererException, FileNotFoundException, UnsupportedEncodingException {
        if ("jrst".equals(renderingContext.getParserId())) {
            this.jrstParser.setRenderingContext(renderingContext);
            this.jrstParser.setMavenProject(this.mavenProject);
            this.jrstParser.setVerbose(this.verbose);
        }
        super.renderDocument(writer, renderingContext, context);
    }

    protected String getPdfFileName() {
        String pdfFilename = this.getStringProperty("pdfFilename");
        if (StringUtils.isBlank((CharSequence)pdfFilename)) {
            pdfFilename = DEFAULT_PDF_FILENAME;
        }
        if (!this.locales.isEmpty() && !this.locale.equals(this.locales.get(0))) {
            pdfFilename = pdfFilename + "_" + this.locale.getCountry();
        }
        pdfFilename = pdfFilename + ".pdf";
        return pdfFilename;
    }

    protected void renderPdf(I18N i18n, List<String> documentRefs, SiteRenderingContext siteRenderingContext, File outputDirectory, String pdfFilename) throws RendererException, FileNotFoundException, UnsupportedEncodingException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Generate Site Pdf: " + pdfFilename);
        }
        Context vc = this.preparePdfVelocityContext(i18n, documentRefs);
        File fileOut = new File(outputDirectory, pdfFilename);
        if (this.verbose) {
            this.getLogger().info("Will generate the site pdf: " + fileOut);
        }
        try {
            StringWriter sw = new StringWriter();
            Field velocityField = ReflectUtil.getField(DefaultSiteRenderer.class, "velocity");
            VelocityComponent velocity = (VelocityComponent)velocityField.get((Object)this);
            VelocityEngine engine = velocity.getEngine();
            String inputEncoding = siteRenderingContext.getInputEncoding();
            engine.mergeTemplate("/META-INF/maven/RstAggregation.vm", inputEncoding, vc, (Writer)sw);
            String fileContent = sw.toString();
            File pdfDoc = new File(outputDirectory, "pdfDoc.rst");
            FileUtils.writeStringToFile((File)pdfDoc, (String)fileContent, (String)inputEncoding);
            Document doc = this.jrstParser.getStrategy().generateRstToXml(fileOut, inputEncoding);
            JRST.generatePdf((File)pdfDoc, (File)fileOut, (JRST.Overwrite)JRST.Overwrite.ALLTIME, (Document)doc);
        }
        catch (Exception e) {
            this.getLogger().error("Can't generate pdf documentation of the project at " + fileOut, (Throwable)e);
        }
    }

    protected Context preparePdfVelocityContext(I18N i18n, List<String> documentRefs) {
        VelocityContext vc = new VelocityContext();
        vc.put("locale", (Object)this.locale);
        vc.put("supportedLocales", this.locales);
        String tableOfContent = i18n.getString("jrst-site-renderer", this.locale, "content");
        String docName = this.mavenProject.getName();
        String titleDecoration = StringUtils.rightPad((String)"", (int)docName.length(), (char)'=');
        vc.put("titleDecoration", (Object)titleDecoration);
        vc.put("docName", (Object)docName);
        vc.put("tableContentName", (Object)tableOfContent);
        vc.put("basedir", (Object)this.mavenProject.getBasedir());
        vc.put("separator", (Object)Character.valueOf(File.separatorChar));
        vc.put("documentRefs", documentRefs);
        return vc;
    }

    protected List<String> getDocumentRelativePathsFromMenu(SiteRenderingContext siteRenderingContext) {
        LinkedList<String> paths = new LinkedList<String>();
        for (Menu menu : siteRenderingContext.getDecoration().getMenus()) {
            for (MenuItem item : menu.getItems()) {
                this.buildListPathsFromMenuItem(item, paths);
            }
        }
        return paths;
    }

    protected List<String> getDocumentRefs(Map<String, String> relatifPaths, List<String> relativPathsFromMenu) {
        LinkedList<String> documentRefs = new LinkedList<String>();
        for (String path : relativPathsFromMenu) {
            String rstFilename = relatifPaths.get(path);
            if (rstFilename == null) continue;
            if (this.verbose) {
                this.getLogger().info("Add document to render in pdf: " + rstFilename);
            }
            documentRefs.add(rstFilename);
        }
        return documentRefs;
    }

    protected Map<String, String> buildDocMap(Collection<DocumentRenderer> documents) {
        TreeMap map = Maps.newTreeMap();
        for (DocumentRenderer doc : documents) {
            RenderingContext renderingContext = doc.getRenderingContext();
            String inputName = renderingContext.getInputName();
            if (!inputName.endsWith("rst") && !inputName.endsWith("rst.vm")) continue;
            String[] splitName = inputName.split("\\.");
            String htmlName = splitName[0] + "." + "html";
            String relativePath = "." + File.separator + htmlName;
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("relativePath: " + relativePath);
            }
            map.put(relativePath, inputName);
        }
        return map;
    }

    protected Collection<String> buildListPathsFromMenuItem(MenuItem item, Collection<String> paths) {
        List subItems;
        String href = item.getHref();
        if (!href.startsWith("http") && !href.startsWith("..")) {
            boolean addHref = true;
            for (Locale loc : this.locales) {
                if (!href.startsWith(loc.toString())) continue;
                addHref = false;
            }
            if (addHref) {
                if (!href.startsWith("./")) {
                    href = "./" + href;
                }
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("document to render in pdf: " + href);
                }
                paths.add(href);
            }
        }
        if (!(subItems = item.getItems()).isEmpty()) {
            for (MenuItem subItem : subItems) {
                paths = this.buildListPathsFromMenuItem(subItem, paths);
            }
        }
        return paths;
    }

    protected String getStringProperty(String propertyName) {
        Object value = this.mavenProject.getProperties().get(propertyName);
        String result = value == null ? null : String.valueOf(value);
        return result;
    }

    protected boolean getBooleanProperty(String propertyName) {
        boolean result = "true".equals(this.getStringProperty(propertyName));
        return result;
    }
}

