/*
 * #%L
 * JAXX :: Widgets
 * 
 * $Id: FontSizorHandler.java 2221 2011-02-16 21:27:27Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jaxx/tags/jaxx-2.5.16/jaxx-widgets/src/main/java/jaxx/runtime/swing/FontSizorHandler.java $
 * %%
 * Copyright (C) 2008 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package jaxx.runtime.swing;

import jaxx.runtime.binding.SimpleJAXXObjectBinding;

/**
 * Handler of ui {@link FontSizor}.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 2.0
 */
public class FontSizorHandler {

    protected final FontSizor ui;

    public FontSizorHandler(FontSizor ui) {
        this.ui = ui;
    }

    public static final String BINDING_FONT_SIZE_CALL_BACK = "fontSize.callBack";

    public static final String BINDING_DEFAULT_FONT_SIZE_CALL_BACK = "defaultFontSize.callBack";

    public void init() {
        if (ui.fontSize == null) {
            ui.setFontSize(ui.defaultFontSize);
        }
    }

    boolean updateDefaultSizeEnabled(Float fontSize,
                                     Float defaultFontSize,
                                     boolean enabled) {
        if (fontSize == null || defaultFontSize == null) {
            return false;
        }
        return !fontSize.equals(defaultFontSize) && enabled;
    }

    public void setCallBack(final Runnable action) {
        ui.removeDataBinding(BINDING_FONT_SIZE_CALL_BACK);
        ui.registerDataBinding(new SimpleJAXXObjectBinding(ui, BINDING_FONT_SIZE_CALL_BACK, true, "fontSize") {

            @Override
            public void processDataBinding() {
                action.run();
            }
        });
        ui.applyDataBinding(BINDING_FONT_SIZE_CALL_BACK);
    }

    void $afterCompleteSetup() {
        ui.registerDataBinding(new SimpleJAXXObjectBinding(ui, BINDING_DEFAULT_FONT_SIZE_CALL_BACK, true, "defaultFontSize") {

            @Override
            public void processDataBinding() {
                ui.setFontSize(ui.defaultFontSize);
            }
        });
        //applyDataBinding(BINDING_DEFAULT_FONT_SIZE_CALL_BACK);
    }
}
