package jaxx.runtime.swing.editor.config;

/*
 * #%L
 * JAXX :: Widgets
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2008 - 2013 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;

public class ConfigCallBackUI extends JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVUu24TQRS9NrEd24SYWIQgghRIJCQQNlQgJQohQZETzEM4RBFuGO8O9oTxzjA7izcN4hP4BOhpkOioEAU1BQ3iFxCioEXc2fUjC5tgiIsda+aeM+eePXdffYWUq+D0NvH9kvIczdq0tH5ta+t2Y5ta+jp1LcWkFgrCXyIJyTrk7f6+q2G2XjXwchdeXhFtKRzq7ELPVyHn6h1O3RalWsOpKMJy3XKtfzzvS0/1WPui4lhffP+WfG4/e5kE8CWqy2ArM39DDToZqUKS2Rom8KYnpMyJ00QZijlN1Dtm9lY4cd1bpE0fw1PIVCEtiUIyDWeGbzngCPC+1DA6t36HOJRf1HApotTt4L0lajPElizhPGRNVG+WFcL5MrEe3VuTMiBKa8i0iGNzqjRc+WeWSggdkI3NrdcsJTg3ylDYcdO63+XadWTKs31UwaYaI0LtHrOGoxHghqIBZLwPSTaFhmKkaNnTWjhR5pxGZIUS2/Q3ESkPvItWo6NV0ggcjdYGu6ZoSmIuTkZ8wsSVBokbRCJRh5TycFvDVP3PkN7FozCeU7/F0xAGpz8ni5/efnmz2stkFu8+Flu6a6QwK1IJif0yc/V4GEhPM16+SeR8HVkoR7ODeZuOEVbrHqM4vC94DyUDL1WI20KKVObzu/eTDz4eguQq5Lgg9iox9WuQ1S2FLghu+/LqUqDocGcUnwWjTUOakx2BLwmOLNhEk5kGc2y0d9FHE6ZjTOgraWQ//CjWXi/1jEigsBN7lg/MSN2HNHM4c2gwnt3Jix3HvHSpZ4vBhMXNXMKsOdmN+2zwPBvXacES3Gs7YfA2Ge2YynO+Z5bzQQPm34WArzAE36gZQ9LgmK+JhbCjGaLx+9LwNF2M5y0OwZtXQuhN5jKkNkWX/58qq0SnQlmzpQ9INMKscIr38GtyGA5N/f10DMOR10LwDSY3Dkpltm/swzCNDL8AMTWdbT0HAAA=";
    private static final Log log = LogFactory.getLog(ConfigCallBackUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JTree detectedCallBack;
    protected JButton go;
    protected ConfigCallBackUIHandler handler;
    protected JPanel treeHeader;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JLabel $JLabel0;
    private ConfigCallBackUI $JPanel0 = this;
    private JScrollPane $JScrollPane0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    /**
         * Init the ui.
         */
        public void init() {
            getHandler().init(this);
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ConfigCallBackUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ConfigCallBackUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ConfigCallBackUI() {
        $initialize();
    }

    public ConfigCallBackUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ConfigCallBackUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public ConfigCallBackUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ConfigCallBackUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public ConfigCallBackUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__go(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().doAction(this);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JTree getDetectedCallBack() {
        return detectedCallBack;
    }

    public JButton getGo() {
        return go;
    }

    public ConfigCallBackUIHandler getHandler() {
        return handler;
    }

    public JPanel getTreeHeader() {
        return treeHeader;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToTreeHeader() {
        if (!allComponentsCreated) {
            return;
        }
        treeHeader.add($JLabel0);
    }

    protected void createDetectedCallBack() {
        $objectMap.put("detectedCallBack", detectedCallBack = new JTree());
        
        detectedCallBack.setName("detectedCallBack");
        detectedCallBack.setEditable(false);
        detectedCallBack.setRootVisible(false);
        detectedCallBack.setRowHeight(24);
    }

    protected void createGo() {
        $objectMap.put("go", go = new JButton());
        
        go.setName("go");
        go.setText(_("config.launch.callBack"));
        go.setToolTipText(_("config.launch.callBack.tip"));
        go.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__go"));
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(ConfigCallBackUIHandler.class));
    }

    protected void createTreeHeader() {
        $objectMap.put("treeHeader", treeHeader = new JPanel());
        
        treeHeader.setName("treeHeader");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $JPanel0
        add($JScrollPane0, BorderLayout.CENTER);
        add(go, BorderLayout.SOUTH);
        add(treeHeader, BorderLayout.EAST);
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(detectedCallBack);
        addChildrenToTreeHeader();
        
        // apply 3 property setters
        $JScrollPane0.setColumnHeaderView(treeHeader);
        go.setIcon(SwingUtil.createActionIcon("config-quit"));
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$JPanel0", $JPanel0);
        createHandler();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createDetectedCallBack();
        createGo();
        createTreeHeader();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("config.detected.callBack"));
        // inline creation of $JPanel0
        setName("$JPanel0");
        setLayout(new BorderLayout());
        
        $completeSetup();
    }

}