/*
 * #%L
 * JAXX :: Widgets
 * 
 * $Id: ListSelectorHandler.java 2225 2011-02-19 20:15:00Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jaxx/tags/jaxx-2.4.1/jaxx-widgets/src/main/java/jaxx/runtime/swing/ListSelectorHandler.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package jaxx.runtime.swing;

import jaxx.runtime.SwingUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import javax.swing.*;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

/**
 * @author sletellier <letellier@codelutin.com>
 * @since 2.2.3
 */
public class ListSelectorHandler <B> {

    public static final Log log = LogFactory.getLog(ListSelectorHandler.class);

    protected ListSelectorUI<B> listSelector;

    public ListSelectorHandler(final ListSelectorUI<B> listSelector) {
        this.listSelector = listSelector;
    }

    protected JComboBox getCombo() {
        return listSelector.getCombo();
    }

    protected JList getList() {
        return listSelector.getList();
    }

    /**
     * @return the datas from the combo box.
     */
    public java.util.List<B> getComboDatas() {
        java.util.List<B> datas = new java.util.ArrayList<B>();
        ComboBoxModel comboModel = getCombo().getModel();
        for (int i = 0, j = comboModel.getSize(); i < j; i++) {
            B g = (B) comboModel.getElementAt(i);
            datas.add(g);
        }
        return datas;
    }

    /**
     * @return the data for the list.
     */
    public java.util.List<B> getListDatas() {
        java.util.List<B> datas = new java.util.ArrayList<B>();
        ListModel listModel = getList().getModel();
        for (int i = 0, j = listModel.getSize(); i < j; i++) {
            B g = (B) listModel.getElementAt(i);
            datas.add(g);
        }
        return datas;
    }

    /**
     * Initialize the component.
     *
     * @param toCombo datas to set in combo
     * @param toList  datas to set in list
     */
    public void init(java.util.List<B> toCombo, java.util.List<B> toList) {
        setComboDatas(toCombo);
        setListDatas(toList);
        // after init, always unmodified editor
        // TODO should avoid to fire a changed ?
        listSelector.setModified(false);

        HidorButton hidor = listSelector.getHidor();
        hidor.addPropertyChangeListener("targetVisible", new PropertyChangeListener() {

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (log.isDebugEnabled()) {
                    log.debug("target visible changed <" + evt.getOldValue() + ":" + evt.getNewValue() + ">");
                }
                if (!listSelector.isShowHidor() || !listSelector.isEnabled()) {
                    return;
                }
                SwingUtilities.invokeLater(new Runnable() {

                    @Override
                    public void run() {
                        log.info("invalidate " + listSelector.getParent().getName());
                        listSelector.listPane.invalidate();
                    }
                });
            }
        });
    }

    /**
     * Transfert the {@code b} data from combo box to list.
     *
     * @param b the data to transfert
     */
    protected void transfertToList(B b) {
        ((DefaultListModel) getList().getModel()).addElement(b);
        ((DefaultComboBoxModel) getCombo().getModel()).removeElement(b);
        listSelector.setModified(true);
    }

    /**
     * Transfert the {@code b} data from list to combo box.
     *
     * @param bs the data to transfert
     */
    protected void transfertToCombo(B[] bs) {
        for (B b : bs) {
            ((DefaultListModel) getList().getModel()).removeElement(b);
            ((DefaultComboBoxModel) getCombo().getModel()).addElement(b);
        }
        listSelector.setModified(true);
    }

    /**
     * @param enabled databinding
     * @return {@code true} if add button should be enabled
     */
    protected boolean updateAddEnabled(boolean enabled) {
        return enabled && getCombo().getModel().getSize() > 0;
    }

    /**
     * @param enabled databinding
     * @return {@code true} if remove button should be enabled
     */
    protected boolean updateRemoveEnabled(boolean enabled) {
        return enabled && getList().getModel().getSize() > 0;
    }

    /**
     * Set the data in combo box model.
     *
     * @param toCombo datas to set in combo box model
     */
    protected void setComboDatas(java.util.List<B> toCombo) {
        SwingUtil.fillComboBox(getCombo(), toCombo, null);
        //Note : there is a case when combo was selected, then come here with an empty
        // combo model : no propertyChanged is fired, so add button stays enabled...
        listSelector.processDataBinding("add.enabled");
    }

    /**
     * Set the data in the list model.
     *
     * @param toList datas to set in list model
     */
    protected void setListDatas(java.util.List<B> toList) {
        SwingUtil.fillList(getList(), toList, null);
    }
}
