/*
 * #%L
 * JAXX :: Widgets
 * 
 * $Id: AboutPanelHandler.java 2221 2011-02-16 21:27:27Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jaxx/tags/jaxx-2.4.1/jaxx-widgets/src/main/java/jaxx/runtime/swing/AboutPanelHandler.java $
 * %%
 * Copyright (C) 2008 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package jaxx.runtime.swing;

import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.Resource;

import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.InputStream;

import static org.nuiton.i18n.I18n._;

/**
 * Handler of the ui {@link AboutPanel}.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 2.4
 */
public class AboutPanelHandler {

    private static final Log log = LogFactory.getLog(AboutPanelHandler.class);

    protected final AboutPanel ui;

    public AboutPanelHandler(AboutPanel ui) {
        this.ui = ui;
    }

    final protected Action closeAction = new AbstractAction("close") {
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            JDialog container = ui.getParentContainer(JDialog.class);
            if (container != null) {
                container.dispose();
            } else {
                ui.setVisible(false);
            }
        }
    };

    public void setLicenseFile(String filename) {
        String load = load(filename);
        ui.setLicenseText(load);
    }

    public void setThirdpartyFile(String filename) {
        String load = load(filename);
        ui.setThirdpartyText(load);
    }

    public void buildTopPanel() {
        // image
        JLabel labelIcon;
        if (ui.iconPath != null) {
            Icon logoIcon = Resource.getIcon(ui.iconPath);
            labelIcon = new JLabel(logoIcon);
        } else {
            labelIcon = new JLabel();
        }
        ui.topPanel.add(labelIcon);
    }

    public void init() {
        if (ui.getAboutText() == null) {
            ui.tabs.remove(ui.aboutContent);
        }
        if (ui.getLicenseText() == null) {
            ui.tabs.remove(ui.licenseContent);
        } else {
            SwingUtilities.invokeLater(new Runnable() {

                @Override
                public void run() {
                    ui.licenseTextArea.setCaretPosition(0);
                }
            });

        }
        if (ui.getThirdpartyText() == null) {
            ui.tabs.remove(ui.thirdpartyContent);
        } else {
            SwingUtilities.invokeLater(new Runnable() {

                @Override
                public void run() {
                    ui.thirdpartyTextArea.setCaretPosition(0);
                }
            });
        }
    }

    public void showInDialog(Frame ui, boolean undecorated) {
        JDialog f = new JDialog(ui, true);
        f.add(this.ui);
        if (this.ui.iconPath != null) {
            f.setIconImage(SwingUtil.createIcon(this.ui.iconPath).getImage());
        }
        f.setResizable(false);
        f.setSize(550, 450);
        f.setUndecorated(undecorated);
        JRootPane rootPane = f.getRootPane();
        rootPane.setDefaultButton(this.ui.close);
        rootPane.getInputMap(JComponent.WHEN_IN_FOCUSED_WINDOW).put(KeyStroke.getKeyStroke("ESCAPE"), "close");
        rootPane.getActionMap().put("close", closeAction);
        f.addWindowListener(new WindowAdapter() {
            @Override
            public void windowClosed(WindowEvent e) {
                Component ui = (Component) e.getSource();
                if (log.isInfoEnabled()) {
                    log.info("destroy ui " + ui);
                }
                JAXXUtil.destroy(ui);
                JAXXUtil.destroy(AboutPanelHandler.this.ui);
            }
        });
        SwingUtil.center(ui, f);
        f.setVisible(true);
    }

    protected String load(String filename) {
        InputStream licenseStream = getClass().getResourceAsStream("/" + filename);
        String result = null;
        try {
            if (licenseStream != null) {
                result = IOUtils.toString(licenseStream);
            }
        } catch (IOException ex) {
            // ignore it
        } finally {
            if (licenseStream != null) {
                try {
                    licenseStream.close();
                } catch (IOException ex) {
                    log.error("could not close file " + filename);
                }
            }
        }
        if (result == null) {
            result = "resource " + filename + " not found";
        }
        return result;
    }

    void $afterCompleteSetup() {
        buildTopPanel();
        ui.close.setText(_("aboutframe.ok"));
    }
}
