/*
 * #%L
 * JAXX :: Widgets
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package jaxx.runtime.swing;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.*;
import java.net.URL;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.Resource;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static org.nuiton.i18n.I18n._;

public class AboutPanel extends jaxx.runtime.swing.Table implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_ABOUT_TEXT = "aboutText";
    public static final String PROPERTY_BACKGROUND_COLOR = "backgroundColor";
    public static final String PROPERTY_BOTTOM_TEXT = "bottomText";
    public static final String PROPERTY_ICON_PATH = "iconPath";
    public static final String PROPERTY_LICENSE_TEXT = "licenseText";
    public static final String PROPERTY_THIRDPARTY_TEXT = "thirdpartyText";
    public static final String PROPERTY_TITLE = "title";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_BOTTOM_LABEL_TEXT = "bottomLabel.text";
    public static final String BINDING_BOTTOM_LABEL_VISIBLE = "bottomLabel.visible";
    public static final String BINDING_CLOSE_ACTION = "close.action";
    public static final String BINDING_LICENSE_TEXT_AREA_TEXT = "licenseTextArea.text";
    public static final String BINDING_THIRDPARTY_TEXT_AREA_TEXT = "thirdpartyTextArea.text";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JEDITOR_PANE0_TEXT = "$JEditorPane0.text";
    private static final String BINDING_$JLABEL0_TEXT = "$JLabel0.text";
    private static final String BINDING_$JLABEL0_VISIBLE = "$JLabel0.visible";
    private static final String BINDING_$TABLE0_BACKGROUND = "$Table0.background";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVWTW/cRBieLNkkm22bNlFLoClKIRIgVG9aBAilahsCEYm2bWAjUbGXju1JdtpZzzAzbpweEOIX8BPgzgWJGyfEgTMHLoi/gBAHroh3xl57nXhdq87Bu3k/nnneZ2Ye7/d/oaaS6OojHEWODANNh8TZ3Xzw4L77iHj6Q6I8SYXmEsV/Uw3U6KO2n8aVRq/1u6a9k7R3tvhQ8IAEY90bXTSv9DEjakCI1uhKvsNTqtNL0xuRCOUINSVVhPrtP383vvG/+q6BUCSA3TKMsvqsrmyS6S5qUF+jRVjpCe4wHBwCDUmDQ+B71sS2GFbqHh6SL9CXaLaLZgSWAKbRq9VHthi2PxIaza7tY5eRddAgR1QdwbLOpstDvYcDwoSwPTMaNTXVjGh03hByDEknJpmVzFGPB3tYD8z/57J4Cxu8fRLpE4l5l2vNhwWZNqMeCRQpSJ3TAyp9UEAfF2QXXOw9PpQ8DPwtzriEeksYH2nHBsboru3aGUGERVMTJdPHUVPUGq/tYreg1kZN0UpWq7lIIV7J40xr7MJZfTGHAVvhEt+05IvPWN22eKDtZuebep7kjI2a1tKms2u7H/kUdt6k1k92ZSlT/nomaqJ3spiJvpnHXRjbkU1JsEYX80MkcVN+Le26kG3WZOjF/I6OUK6bx41T23W9QNZ2fJDSzbhqHu9mZ9djXMHZXcox/iCEniBf2TL3Yic44KDcywU3I8mK0w2W1u2CxI1RQqLLOUSwGyezm8wPpvqoKUMIa7TcP+1Qn0Iq9qblE95kAG32v0tLv//054/bI0O6DGtfLCwd81MwCiG5IFJTs/RC7EahpqxzF4uNPmopwsCMrdmuFBDrJWkgB+tdsNfOtDsfYzUAiObsHz//cunhby+gxjaaZxz729jU76CWHkhQgTM/ErfvWEZnjubged5wMz6RXmo4qjd9rPGqSwMfduRWBEKsFAiRsnFbv/671PvhzkiMKSD30sTyTJDm52iGBowGxPpzYr2FftwWioQ+zyy2yHSnzOe8SE7Ijn3eLZp2xuXSJ9Lk96LQfHxiaZtvvYooJny/BOFKFR4MH4P/1ERpHcC9v6boUzjiizdjQVexhleHG2pyqxh4tQLwtE7cfwK5KhizT6ii8B6sBWPCn5UgvFEb4a0Ko7S92F/3j4Ud5+D5oeYIvCVwIstz45jw41pDPUsWpzbCeiWEr0t0qIZQpmQ1hDIlqyGU6fB2bYR3aitZDaFMyWoIZUpWQ3hYgvBehfu1NOCSPoXritkmo4fBMPlZNAHy/dpjVUMQtRDgfQFvcxr/oJqAsgEo/wPs2NTU6w0AAA==";
    protected static final Log log = LogFactory.getLog(jaxx.runtime.swing.AboutPanel.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JScrollPane aboutContent;
    protected java.lang.String aboutText;
    protected java.awt.Color backgroundColor;
    protected javax.swing.JLabel bottomLabel;
    protected java.lang.String bottomText;
    protected javax.swing.JButton close;
    protected java.lang.String iconPath;
    protected javax.swing.JScrollPane licenseContent;
    protected java.lang.String licenseText;
    protected javax.swing.JTextArea licenseTextArea;
    protected javax.swing.JTabbedPane tabs;
    protected javax.swing.JScrollPane thirdpartyContent;
    protected java.lang.String thirdpartyText;
    protected javax.swing.JTextArea thirdpartyTextArea;
    protected java.lang.String title;
    protected javax.swing.JPanel topPanel;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private AboutPanel $Table0 = this;
    private javax.swing.JPanel $JPanel0;
    private javax.swing.JLabel $JLabel0;
    private javax.swing.JEditorPane $JEditorPane0;
    private javax.swing.JPanel $JPanel1;
    private jaxx.runtime.swing.TabInfo $TabInfo0;
    private jaxx.runtime.swing.TabInfo $TabInfo1;
    private jaxx.runtime.swing.TabInfo $TabInfo2;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    final Action closeAction = new AbstractAction("close") {
        private static final long serialVersionUID = 1L;
    
        @Override
        public void actionPerformed(ActionEvent e) {
            JDialog container = getParentContainer(JDialog.class);
            if (container != null) {
                container.dispose();
            } else {
                setVisible(false);
            }
        }
    };
    
    
    public void setLicenseFile(String filename) {
        String load = load(filename);
        setLicenseText(load);
    }
    
    public void setThirdpartyFile(String filename) {
        String load = load(filename);
        setThirdpartyText(load);
    }
    
    public void buildTopPanel() {
        // image
        JLabel labelIcon;
        if (iconPath != null) {
            Icon logoIcon = Resource.getIcon(iconPath);
            labelIcon = new JLabel(logoIcon);
        } else {
            labelIcon = new JLabel();
        }
        topPanel.add(labelIcon);
    }
    
    public void init() {
        if (getAboutText() == null) {
            tabs.remove(aboutContent);
        }
        if (getLicenseText() == null) {
            tabs.remove(licenseContent);
        } else {
            SwingUtilities.invokeLater(new Runnable() {
    
                @Override
                public void run() {
                    licenseTextArea.setCaretPosition(0);
                }
            });
    
        }
        if (getThirdpartyText() == null) {
            tabs.remove(thirdpartyContent);
        } else {
            SwingUtilities.invokeLater(new Runnable() {
    
                @Override
                public void run() {
                    thirdpartyTextArea.setCaretPosition(0);
                }
            });
        }
    }
    
    public void showInDialog(Frame ui, boolean undecorated) {
        JDialog f = new JDialog(ui, true);
        f.add(this);
        if (iconPath != null) {
            f.setIconImage(SwingUtil.createIcon(iconPath).getImage());
        }
        f.setResizable(false);
        f.setSize(550, 450);
        f.setUndecorated(undecorated);
        JRootPane rootPane = f.getRootPane();
        rootPane.setDefaultButton(close);
        rootPane.getInputMap(JComponent.WHEN_IN_FOCUSED_WINDOW).put(KeyStroke.getKeyStroke("ESCAPE"), "close");
        rootPane.getActionMap().put("close", closeAction);
        f.addWindowListener(new WindowAdapter() {
            @Override
            public void windowClosed(WindowEvent e) {
                Component ui = (Component) e.getSource();
                if (log.isInfoEnabled()) {
                    log.info("destroy ui "+ ui);
                }
                JAXXUtil.destroy(ui);
                JAXXUtil.destroy(AboutPanel.this);
            }
        });
        SwingUtil.center(ui, f);
        f.setVisible(true);
    }
    
    protected String load(String filename) {
        InputStream licenseStream = getClass().getResourceAsStream("/" + filename);
        String result = null;
        try {
            if (licenseStream != null) {
                result = IOUtils.toString(licenseStream);
            }
        } catch (IOException ex) {
           // ignore it
        } finally {
            if (licenseStream != null) {
                try {
                    licenseStream.close();
                } catch (IOException ex) {
                    log.error("could not close file " + filename);
                }
            }
        }
        if (result == null) {
            result = "resource " + filename + " not found";
        }
        return result;
    }
    
    void $afterCompleteSetup() {
        buildTopPanel();
        close.setText(_("aboutframe.ok"));
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AboutPanel() {
        $initialize();
    }

    public AboutPanel(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doHyperlinkUpdate__on__$JEditorPane0(javax.swing.event.HyperlinkEvent event) {
        SwingUtil.openLink(event);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public javax.swing.JScrollPane getAboutContent() {
        return aboutContent;
    }

    public java.lang.String getAboutText() {
        return aboutText;
    }

    public java.awt.Color getBackgroundColor() {
        return backgroundColor;
    }

    public javax.swing.JLabel getBottomLabel() {
        return bottomLabel;
    }

    public java.lang.String getBottomText() {
        return bottomText;
    }

    public javax.swing.JButton getClose() {
        return close;
    }

    public java.lang.String getIconPath() {
        return iconPath;
    }

    public javax.swing.JScrollPane getLicenseContent() {
        return licenseContent;
    }

    public java.lang.String getLicenseText() {
        return licenseText;
    }

    public javax.swing.JTextArea getLicenseTextArea() {
        return licenseTextArea;
    }

    public javax.swing.JTabbedPane getTabs() {
        return tabs;
    }

    public javax.swing.JScrollPane getThirdpartyContent() {
        return thirdpartyContent;
    }

    public java.lang.String getThirdpartyText() {
        return thirdpartyText;
    }

    public javax.swing.JTextArea getThirdpartyTextArea() {
        return thirdpartyTextArea;
    }

    public java.lang.String getTitle() {
        return title;
    }

    public javax.swing.JPanel getTopPanel() {
        return topPanel;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setAboutText(java.lang.String newValue) {
        java.lang.String oldValue = this.aboutText;
        this.aboutText = newValue;
        firePropertyChange(PROPERTY_ABOUT_TEXT, oldValue, newValue);
    }

    public void setBackgroundColor(java.awt.Color newValue) {
        java.awt.Color oldValue = this.backgroundColor;
        this.backgroundColor = newValue;
        firePropertyChange(PROPERTY_BACKGROUND_COLOR, oldValue, newValue);
    }

    public void setBottomText(java.lang.String newValue) {
        java.lang.String oldValue = this.bottomText;
        this.bottomText = newValue;
        firePropertyChange(PROPERTY_BOTTOM_TEXT, oldValue, newValue);
    }

    public void setIconPath(java.lang.String newValue) {
        java.lang.String oldValue = this.iconPath;
        this.iconPath = newValue;
        firePropertyChange(PROPERTY_ICON_PATH, oldValue, newValue);
    }

    public void setLicenseText(java.lang.String newValue) {
        java.lang.String oldValue = this.licenseText;
        this.licenseText = newValue;
        firePropertyChange(PROPERTY_LICENSE_TEXT, oldValue, newValue);
    }

    public void setThirdpartyText(java.lang.String newValue) {
        java.lang.String oldValue = this.thirdpartyText;
        this.thirdpartyText = newValue;
        firePropertyChange(PROPERTY_THIRDPARTY_TEXT, oldValue, newValue);
    }

    public void setTitle(java.lang.String newValue) {
        java.lang.String oldValue = this.title;
        this.title = newValue;
        firePropertyChange(PROPERTY_TITLE, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.JEditorPane get$JEditorPane0() {
        return $JEditorPane0;
    }

    protected javax.swing.JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected jaxx.runtime.swing.TabInfo get$TabInfo0() {
        return $TabInfo0;
    }

    protected jaxx.runtime.swing.TabInfo get$TabInfo1() {
        return $TabInfo1;
    }

    protected jaxx.runtime.swing.TabInfo get$TabInfo2() {
        return $TabInfo2;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToAboutContent() {
        if (!allComponentsCreated) {
            return;
        }
        aboutContent.getViewport().add($JEditorPane0);
    }

    protected void addChildrenToLicenseContent() {
        if (!allComponentsCreated) {
            return;
        }
        licenseContent.getViewport().add(licenseTextArea);
    }

    protected void addChildrenToTabs() {
        if (!allComponentsCreated) {
            return;
        }
        tabs.add(aboutContent);
        tabs.add(licenseContent);
        tabs.add(thirdpartyContent);
        $TabInfo0.addPropertyChangeListener(new jaxx.runtime.swing.TabInfoPropertyChangeListener(tabs, 0));
        tabs.setTitleAt(0, _("aboutframe.about"));
        $TabInfo1.addPropertyChangeListener(new jaxx.runtime.swing.TabInfoPropertyChangeListener(tabs, 1));
        tabs.setTitleAt(1, _("aboutframe.license"));
        $TabInfo2.addPropertyChangeListener(new jaxx.runtime.swing.TabInfoPropertyChangeListener(tabs, 2));
        tabs.setTitleAt(2, _("aboutframe.thirdparty"));
    }

    protected void addChildrenToThirdpartyContent() {
        if (!allComponentsCreated) {
            return;
        }
        thirdpartyContent.getViewport().add(thirdpartyTextArea);
    }

    protected void createAboutContent() {
        $objectMap.put("aboutContent", aboutContent = new javax.swing.JScrollPane());
        aboutContent.setName("aboutContent");
    }

    protected void createAboutText() {
        $objectMap.put("aboutText", aboutText = null);
    }

    protected void createBackgroundColor() {
        $objectMap.put("backgroundColor", backgroundColor = null);
    }

    protected void createBottomLabel() {
        $objectMap.put("bottomLabel", bottomLabel = new javax.swing.JLabel());
        bottomLabel.setName("bottomLabel");
    }

    protected void createBottomText() {
        $objectMap.put("bottomText", bottomText = null);
    }

    protected void createClose() {
        $objectMap.put("close", close = new javax.swing.JButton());
        close.setName("close");
    }

    protected void createIconPath() {
        $objectMap.put("iconPath", iconPath = null);
    }

    protected void createLicenseContent() {
        $objectMap.put("licenseContent", licenseContent = new javax.swing.JScrollPane());
        licenseContent.setName("licenseContent");
    }

    protected void createLicenseText() {
        $objectMap.put("licenseText", licenseText = null);
    }

    protected void createLicenseTextArea() {
        $objectMap.put("licenseTextArea", licenseTextArea = new javax.swing.JTextArea());
        licenseTextArea.setName("licenseTextArea");
        licenseTextArea.setColumns(15);
        licenseTextArea.setLineWrap(true);
        licenseTextArea.setWrapStyleWord(true);
        licenseTextArea.setEditable(false);
        if (licenseTextArea.getFont() != null) {
            licenseTextArea.setFont(licenseTextArea.getFont().deriveFont((float) 11));
        }
    }

    protected void createTabs() {
        $objectMap.put("tabs", tabs = new javax.swing.JTabbedPane());
        tabs.setName("tabs");
    }

    protected void createThirdpartyContent() {
        $objectMap.put("thirdpartyContent", thirdpartyContent = new javax.swing.JScrollPane());
        thirdpartyContent.setName("thirdpartyContent");
    }

    protected void createThirdpartyText() {
        $objectMap.put("thirdpartyText", thirdpartyText = null);
    }

    protected void createThirdpartyTextArea() {
        $objectMap.put("thirdpartyTextArea", thirdpartyTextArea = new javax.swing.JTextArea());
        thirdpartyTextArea.setName("thirdpartyTextArea");
        thirdpartyTextArea.setColumns(15);
        thirdpartyTextArea.setLineWrap(true);
        thirdpartyTextArea.setWrapStyleWord(true);
        thirdpartyTextArea.setEditable(false);
        if (thirdpartyTextArea.getFont() != null) {
            thirdpartyTextArea.setFont(thirdpartyTextArea.getFont().deriveFont((float) 11));
        }
    }

    protected void createTitle() {
        $objectMap.put("title", title = null);
    }

    protected void createTopPanel() {
        $objectMap.put("topPanel", topPanel = new javax.swing.JPanel());
        topPanel.setName("topPanel");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        // inline complete setup of $Table0
        add($JPanel0, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(1, 1, 1, 1), 0, 0));
        add(topPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(1, 1, 1, 1), 0, 0));
        add(tabs, new GridBagConstraints(0, 2, 1, 1, 0.0, 1.0, 10, 1, new Insets(1, 1, 1, 1), 0, 0));
        add($JPanel1, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(1, 1, 1, 1), 0, 0));
        // inline complete setup of $JPanel0
        $JPanel0.add($JLabel0, BorderLayout.CENTER);
        addChildrenToTabs();
        addChildrenToAboutContent();
        addChildrenToLicenseContent();
        addChildrenToThirdpartyContent();
        // inline complete setup of $JPanel1
        $JPanel1.add(bottomLabel, BorderLayout.CENTER);
        $JPanel1.add(close, BorderLayout.EAST);
        
        // apply 9 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 11 property setters
        setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
        $JPanel0.setBackground(Color.WHITE);
        aboutContent.setBorder(null);
        $JEditorPane0.setBorder(null);
        licenseContent.setBorder(null);
        licenseTextArea.setBorder(null);
        thirdpartyContent.setBorder(null);
        thirdpartyTextArea.setBorder(null);
        bottomLabel.setHorizontalAlignment(SwingConstants.CENTER);
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        // registers 9 data bindings
        $registerDefaultBindings();
        $objectMap.put("$Table0", this);
        createTitle();
        createIconPath();
        createAboutText();
        createBottomText();
        createLicenseText();
        createThirdpartyText();
        createBackgroundColor();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new javax.swing.JPanel());
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new BorderLayout());
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        $JLabel0.setName("$JLabel0");
        if ($JLabel0.getFont() != null) {
            $JLabel0.setFont($JLabel0.getFont().deriveFont((float) 12));
        }
        createTopPanel();
        createTabs();
        createAboutContent();
        // inline creation of $JEditorPane0
        $objectMap.put("$JEditorPane0", $JEditorPane0 = new javax.swing.JEditorPane());
        $JEditorPane0.setName("$JEditorPane0");
        $JEditorPane0.setContentType("text/html");
        $JEditorPane0.setEditable(false);
        $JEditorPane0.addHyperlinkListener(JAXXUtil.getEventListener(HyperlinkListener.class, "hyperlinkUpdate", this, "doHyperlinkUpdate__on__$JEditorPane0"));
        createLicenseContent();
        createLicenseTextArea();
        createThirdpartyContent();
        createThirdpartyTextArea();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new javax.swing.JPanel());
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new BorderLayout());
        createBottomLabel();
        createClose();
        // inline creation of $TabInfo0
        $objectMap.put("$TabInfo0", $TabInfo0 = new jaxx.runtime.swing.TabInfo());
        $TabInfo0.setTitle(_("aboutframe.about"));
        // inline creation of $TabInfo1
        $objectMap.put("$TabInfo1", $TabInfo1 = new jaxx.runtime.swing.TabInfo());
        $TabInfo1.setTitle(_("aboutframe.license"));
        // inline creation of $TabInfo2
        $objectMap.put("$TabInfo2", $TabInfo2 = new jaxx.runtime.swing.TabInfo());
        $TabInfo2.setTitle(_("aboutframe.thirdparty"));
        // inline creation of $Table0
        setName("$Table0");
        
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 9 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$TABLE0_BACKGROUND, true ,"backgroundColor") {
        
            @Override
            public void processDataBinding() {
                setBackground(getBackgroundColor());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL0_TEXT, true ,"title") {
        
            @Override
            public void processDataBinding() {
                $JLabel0.setText(_(SwingUtil.getStringValue(getTitle())));
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL0_VISIBLE, true ,"title") {
        
            @Override
            public void processDataBinding() {
                $JLabel0.setVisible(getTitle() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JEDITOR_PANE0_TEXT, true ,"aboutText") {
        
            @Override
            public void processDataBinding() {
                jaxx.runtime.SwingUtil.setText($JEditorPane0, SwingUtil.getStringValue(getAboutText()));
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_LICENSE_TEXT_AREA_TEXT, true ,"licenseText") {
        
            @Override
            public void processDataBinding() {
                jaxx.runtime.SwingUtil.setText(licenseTextArea, SwingUtil.getStringValue(getLicenseText()));
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_THIRDPARTY_TEXT_AREA_TEXT, true ,"thirdpartyText") {
        
            @Override
            public void processDataBinding() {
                jaxx.runtime.SwingUtil.setText(thirdpartyTextArea, SwingUtil.getStringValue(getThirdpartyText()));
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_BOTTOM_LABEL_TEXT, true ,"bottomText") {
        
            @Override
            public void processDataBinding() {
                bottomLabel.setText(_(SwingUtil.getStringValue(getBottomText())));
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_BOTTOM_LABEL_VISIBLE, true ,"bottomText") {
        
            @Override
            public void processDataBinding() {
                bottomLabel.setVisible(getBottomText() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_CLOSE_ACTION, true ,"closeAction") {
        
            @Override
            public void processDataBinding() {
                close.setAction(closeAction);
            }
        });
    }

}