/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.swing.editor.config;

import java.awt.Component;
import java.awt.Window;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.swing.editor.config.ConfigCallBackUI;
import jaxx.runtime.swing.editor.config.model.CallBackEntry;
import jaxx.runtime.swing.editor.config.model.OptionModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class ConfigCallBackUIHandler {
    private static final Log log = LogFactory.getLog(ConfigCallBackUIHandler.class);

    public void init(ConfigCallBackUI ui) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        Map forSaved = ui.getContextValue(Map.class, "callbacksWithOptions");
        for (Map.Entry e : forSaved.entrySet()) {
            CallBackEntry callBackEntry = (CallBackEntry)e.getKey();
            List options = (List)e.getValue();
            DefaultMutableTreeNode callBackNode = new DefaultMutableTreeNode(callBackEntry, true);
            root.add(callBackNode);
            for (OptionModel o : options) {
                DefaultMutableTreeNode optionkNode = new DefaultMutableTreeNode(o, false);
                callBackNode.add(optionkNode);
            }
        }
        JTree tree = ui.getDetectedCallBack();
        tree.setModel(new DefaultTreeModel(root));
        SwingUtil.expandTree((JTree)tree);
        tree.setCellRenderer(new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                Object v;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("value = " + value.getClass()));
                }
                if (value == null) {
                    return super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                }
                if (!(value instanceof DefaultMutableTreeNode)) {
                    return super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                }
                DefaultMutableTreeNode n = (DefaultMutableTreeNode)value;
                if ((value = n.getUserObject()) instanceof CallBackEntry) {
                    v = (CallBackEntry)value;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("callBackEntry detected " + ((CallBackEntry)v).getName()));
                    }
                    value = I18n._((String)((CallBackEntry)v).getDescription());
                } else if (value instanceof OptionModel) {
                    v = (OptionModel)value;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("option detected " + ((OptionModel)v).getKey()));
                    }
                    value = ((OptionModel)v).getKey() + " (" + I18n._((String)((OptionModel)v).getDescription()) + ")";
                }
                JLabel rendererComponent = (JLabel)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                value = n.getUserObject();
                if (value instanceof CallBackEntry) {
                    CallBackEntry v2 = (CallBackEntry)value;
                    rendererComponent.setIcon(v2.getIcon());
                }
                return rendererComponent;
            }
        });
    }

    public void doAction(final ConfigCallBackUI ui) {
        log.info((Object)"Launch callBacks...");
        Window parent = ui.getContextValue(Window.class, "parent");
        if (parent != null) {
            log.info((Object)"dispose parent window...");
            parent.dispose();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                List callBacks = ui.getContextValue(List.class, "callbacks");
                for (CallBackEntry e : callBacks) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)("launch callBack " + I18n._((String)e.getDescription())));
                    }
                    e.getAction().run();
                }
            }
        });
    }
}

