package jaxx.runtime;

import java.beans.PropertyChangeListener;

/**
 * Created: 5 déc. 2009
 *
 * @author Tony Chemit <chemit@codelutin.com> Copyright Code Lutin
 * @version $Revision: 1679 $
 *          <p/>
 *          Mise a jour: $Date: 2009-12-08 18:21:03 +0100 (mar., 08 déc. 2009) $ par :
 *          $Author: tchemit $
 */
public interface JAXXBinding extends PropertyChangeListener {
    /**
     * @return the unique id of a binding
     */
    String getId();

    /**
     * @return the {@link jaxx.runtime.JAXXObject} which owns the binding
     */
    JAXXObject getSource();

    /**
     * This state is not used actually, but will be usefull later...
     *
     * @return {@code true} if binding was registred as a default binding, {@code false} otherwise
     */
    boolean isDefaultBinding();

    /**
     * Apply the binding without processing it (say just install listeners).
     */
    void applyDataBinding();

    /**
     * Processes the binding.
     */
    void processDataBinding();

    /**
     * Remove the binding.
     */
    void removeDataBinding();
}
