/*
 * *##% 
 * JAXX Runtime
 * Copyright (C) 2008 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * ##%*
 */
package jaxx.runtime.swing.navigation;

import jaxx.runtime.decorator.Decorator;

/**
 * Decorator Renderer of a {@link NavigationTreeNode}.
 *
 * Apply a {@link Decorator} to the {@code bean} associated to the node.
 * 
 * @author chemit
 * @since 1.7.2, replace {@code NavigationUtil#NodeRenderer} which disappear soon...
 */
public class NavigationTreeNodeRendererDecoratorImpl implements NavigationTreeNodeRenderer {

    private static final long serialVersionUID = -1L;
    /**
     * Decorator
     */
    protected final Decorator<?> decorator;
    /**
     * internal class of representing data
     */
    protected final Class<?> internalClass;
    /**
     * last renderered value
     */
    protected String text;

    public NavigationTreeNodeRendererDecoratorImpl(Decorator<?> decorator) {
        this.internalClass = decorator.getInternalClass();
        this.decorator = decorator;
    }

    @Override
    public String toString() {
        return text;
    }

    @Override
    public void reload(Object bean) {
        try {
            text = decorator.toString(bean);

        } catch (Exception e) {
            text = "";
        }
    }

    @Override
    public Class<?> getInternalClass() {
        return internalClass;
    }
}
