/*
 * *##% 
 * JAXX Runtime
 * Copyright (C) 2008 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * ##%*
 */
package jaxx.runtime.swing.navigation;

import java.awt.CardLayout;
import java.awt.Component;
import javax.swing.JPanel;
import jaxx.runtime.swing.Item;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 *
 * @author letellier
 * @since 1.7.2
 */
public class ItemNavigationCardPanel extends JPanel {

    /** to use log facility, just put in your code: log.info(\"...\"); */
    static private final Log log = LogFactory.getLog(ItemNavigationCardPanel.class);
    private static final long serialVersionUID = 1L;
    CardLayout layout;

    public ItemNavigationCardPanel() {
        super();

        layout = new CardLayout();
        setLayout(layout);
    }

    public void showItem(Item i) {
        if (i != null) {
            Object value = i.getValue();
            if (value != null) {
                if (value instanceof Class<?>) {
                    layout.show(this, ((Class<?>) value).getName());
                } else {
                    layout.show(this, value.getClass().getName());
                }
            }
        }
    }

    public Component getShowedComponent() {
        Component[] components = getComponents();
        if (components != null) {
            for (Component c : components) {
                if (c.isVisible()) {
                    return c;
                }
            }
        }
        return null;
    }

    @Override
    public Component add(Component comp) {
        if (!(comp instanceof ItemNavigationPanel)) {
            throw new IllegalArgumentException("ItemNavigationCardPanel must be have only ItemNavigationPanel children");
        }
        super.add(comp, ((ItemNavigationPanel) comp).getAssociatedClass().getName());
        return comp;
    }
}
