package jaxx.demo.component.jaxx.editor;

/*
 * #%L
 * JAXX :: Demo
 * $Id: CoordinateDemoHandler.java 2783 2014-02-04 07:27:32Z tchemit $
 * $HeadURL: https://nuiton.org/svn/jaxx/tags/jaxx-2.8/jaxx-demo/src/main/java/jaxx/demo/component/jaxx/editor/CoordinateDemoHandler.java $
 * %%
 * Copyright (C) 2008 - 2013 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import jaxx.runtime.spi.UIHandler;
import jaxx.runtime.swing.editor.gis.DmdCoordinate;
import jaxx.runtime.swing.editor.gis.DmsCoordinate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import static org.nuiton.i18n.I18n.t;

/**
 * Created on 11/26/13.
 *
 * @author Tony Chemit <chemit@codelutin.com>
 * @since 2.6
 */
public class CoordinateDemoHandler implements UIHandler<CoordinateDemo> {

    /** Logger. */
    private static final Log log =
            LogFactory.getLog(CoordinateDemoHandler.class);

    private CoordinateDemo ui;

    @Override
    public void beforeInit(CoordinateDemo ui) {
        if (log.isInfoEnabled()) {
            log.info("BeforeInit " + ui.getName());
        }
        this.ui = ui;
    }

    @Override
    public void afterInit(CoordinateDemo ui) {

        if (log.isInfoEnabled()) {
            log.info("AfterInit " + ui.getName());
        }

        ui.getLatitudeDmsEditor().init(false);
        ui.getLatitudeDmdEditor().init(false);
        ui.getLatitudeDdEditor().init();
        ui.getLongitudeDmsEditor().init(true);
        ui.getLongitudeDmdEditor().init(true);
        ui.getLongitudeDdEditor().init();

        ui.getLatitudeDms().addPropertyChangeListener(new PropertyChangeListener() {
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                DmsCoordinate source = (DmsCoordinate) evt.getSource();
                getModel().setLatitude(source.toDecimal());
            }
        });
        ui.getLatitudeDmd().addPropertyChangeListener(new PropertyChangeListener() {
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                DmdCoordinate source = (DmdCoordinate) evt.getSource();
                getModel().setLatitude(source.toDecimal());
            }
        });

        ui.addPropertyChangeListener("latitudeDd", new PropertyChangeListener() {
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Float source = (Float) evt.getNewValue();
                getModel().setLatitude(source);
            }
        });

        ui.getLongitudeDms().addPropertyChangeListener(new PropertyChangeListener() {
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                DmsCoordinate source = (DmsCoordinate) evt.getSource();
                getModel().setLongitude(source.toDecimal());
            }
        });
        ui.getLongitudeDmd().addPropertyChangeListener(new PropertyChangeListener() {
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                DmdCoordinate source = (DmdCoordinate) evt.getSource();
                getModel().setLongitude(source.toDecimal());
            }
        });

        ui.addPropertyChangeListener("longitudeDd", new PropertyChangeListener() {
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Float source = (Float) evt.getNewValue();
                getModel().setLongitude(source);
            }
        });

        useLatitudeDmsEditor();
        useLongitudeDmsEditor();
    }

    public void useLatitudeDmsEditor() {
        ui.getLatitudeDmsEditor().setValue(DmsCoordinate.valueOf(getModel().getLatitude()));
        ui.getLatitudeDmsEditor().setEnabled(true);
        ui.getLatitudeDmdEditor().setEnabled(false);
        ui.getLatitudeDdEditor().setEnabled(false);
    }

    public void useLatitudeDmdEditor() {
        ui.getLatitudeDmdEditor().setValue(DmdCoordinate.valueOf(getModel().getLatitude()));
        ui.getLatitudeDmsEditor().setEnabled(false);
        ui.getLatitudeDmdEditor().setEnabled(true);
        ui.getLatitudeDdEditor().setEnabled(false);
    }

    public void useLatitudeDdEditor() {
        ui.getLatitudeDdEditor().setModel(getModel().getLatitude());
        ui.getLatitudeDmsEditor().setEnabled(false);
        ui.getLatitudeDmdEditor().setEnabled(false);
        ui.getLatitudeDdEditor().setEnabled(true);
    }

    public void useLongitudeDmsEditor() {
        ui.getLongitudeDmsEditor().setValue(DmsCoordinate.valueOf(getModel().getLongitude()));
        ui.getLongitudeDmsEditor().setEnabled(true);
        ui.getLongitudeDmdEditor().setEnabled(false);
        ui.getLongitudeDdEditor().setEnabled(false);
    }

    public void useLongitudeDmdEditor() {
        ui.getLongitudeDmdEditor().setValue(DmdCoordinate.valueOf(getModel().getLongitude()));
        ui.getLongitudeDmsEditor().setEnabled(false);
        ui.getLongitudeDmdEditor().setEnabled(true);
        ui.getLongitudeDdEditor().setEnabled(false);
    }

    public void useLongitudeDdEditor() {
        ui.getLongitudeDdEditor().setModel(getModel().getLongitude());
        ui.getLongitudeDmsEditor().setEnabled(false);
        ui.getLongitudeDmdEditor().setEnabled(false);
        ui.getLongitudeDdEditor().setEnabled(true);
    }

    public String getLatitudeText(Float latitude) {
        return t("jaxxdemo.coordinate.result.latitude", latitude);
    }

    public String getLongitudeText(Float longitude) {
        return t("jaxxdemo.coordinate.result.longitude", longitude);
    }

    protected CoordinateDemoModel getModel() {
        return ui.getModel();
    }
}
