/*
 * #%L
 * JAXX :: Demo
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2008 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package jaxx.demo.component.jaxx.editor;

import java.awt.BorderLayout;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import jaxx.demo.DemoPanel;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.TimeEditor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;

public class TimeEditorDemo extends DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_EDITOR_DATE = "editor.date";
    public static final String BINDING_EDITOR_LABEL = "editor.label";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JLABEL0_TEXT = "$JLabel0.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVVz08TQRR+rRRoQUF+NBDRlMKBJrpFiSeIoiAqKf4ADsQedLY70iXT3XV3VpYQjH+Cf4LevZh482Q8ePbgxfgvGOPBq/HN7Ha7axeooUmn2zfvfe9737w3+/YHZBwbJneI5ym2a3C9QZXVG1tb99UdWuPL1KnZusVNG/xPKg3pKvRpod3hMFWtiPByEF5eMhuWaVAjEj1fgZzD9xh16pRyDufjETXHKW+E2/Oe5dpN1JBUEurrXz/Tr7SXb9IAnoXsclhK4bioViVdFUjrGochzPSclBkxtpGGrRvbyPe0sC0x4jj3SIM+gxfQU4Fui9gIxqHYeckSQ8Z7Foe+6WXaMB8Qg7JZDookq6FFqTUhfBvVdARRNhH9lnwUYZYlgbo5ZEXMmqlRxmHu/0BkVAupZ3qTqIwimbGYcs4u6qDIPeGZDQP6aqbxVN+WJaB2QiYv8F6VRuE3ELr3TvvWWfF/RCxD4d4gIyplSxKvIh7/xZNG4TzaSh+J4ZCPuW9Sj6/olGnxkG5fBw7TCRW2aRSnn7Op4zIuSggLiBUnKcrixsVSsLAHz8XyYHcrre5utV+qChnbRTNKX20fiHXc8kdh7J9REIBy909++OuH7+9Xmv3fj7lHE10j44t9admmRW2ui9QDfvO7XGflNWLNVyHrUIazL2d7IoHYRrCN5DDfWRGuiHDlDnHqCJHp+fbxU/7Jl1OQXoEcM4m2QoT/XcjyOspZN5nmWdcXJaP+3V5cB/GbxoNiZM90cbxG9w26W7ht61pFWmZmL14uHaCDatoaMocF6bCpc0a1m9I283imKKjKOTDchkrt4Gj9fnVtwnXTKJZKBx5qOpGgaViYmv38e3jj3WJT1xTWOX6oe0vbzCPo1g2mG1TeLMGlkXiT9FkOdTWzdTkkXRcQnzYrmNqSXC+1KZji0MVxBLhPVioh2AY6yMHxXBE7J4sST1chYQw7TzS5H5U9ksz/KQqx2xNGZ/i4XNG2GJGn7p930BixrrhydFdE6DXEJej3Qju9yMx3oETI7syCRjgpqLqh4cVyrQ05JdbcsYjC/FAs68kI+U5OR6XEOALjQid1+aqeEKULNaEnxMiw5mvgBCC9waW3h++YBX9IC4Tj2151OT3ksDoqUAzCEdymEOMvrthZ8GYJAAA=";
    private static final Log log = LogFactory.getLog(TimeEditorDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel configPanel;
    protected TimeEditorDemoModel demoModel;
    protected TimeEditor editor;
    protected JTextField labelConfig;
    protected JLabel labelConfigLabel;
    protected JPanel resultPane;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private TimeEditorDemo $DemoPanel0 = this;
    private Table $Table0;
    private JPanel $JPanel0;
    private JLabel $JLabel0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    protected String[] getSources() {
        return new String[]{ getDefaultSource(),
                             "TimeEditorDemoModel.java",
                             "TimeEditorDemo.css"
        };
    }
    
    void $afterCompleteSetup() {
    
        // init time editor
        editor.init();
    
        // set current time in model
        demoModel.setTime(new java.util.Date());
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public TimeEditorDemo(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public TimeEditorDemo(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public TimeEditorDemo(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public TimeEditorDemo(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public TimeEditorDemo(boolean param0) {
        super(param0);
        $initialize();
    }

    public TimeEditorDemo(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public TimeEditorDemo() {
        $initialize();
    }

    public TimeEditorDemo(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JPanel getConfigPanel() {
        return configPanel;
    }

    public TimeEditorDemoModel getDemoModel() {
        return demoModel;
    }

    public TimeEditor getEditor() {
        return editor;
    }

    public JTextField getLabelConfig() {
        return labelConfig;
    }

    public JLabel getLabelConfigLabel() {
        return labelConfigLabel;
    }

    public JPanel getResultPane() {
        return resultPane;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected Table get$Table0() {
        return $Table0;
    }

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToConfigPanel() {
        if (!allComponentsCreated) {
            return;
        }
        configPanel.add($JPanel0);
    }

    protected void addChildrenToResultPane() {
        if (!allComponentsCreated) {
            return;
        }
        resultPane.add($JLabel0, BorderLayout.CENTER);
    }

    protected void createConfigPanel() {
        $objectMap.put("configPanel", configPanel = new JPanel());
        
        configPanel.setName("configPanel");
        configPanel.setLayout(new GridLayout(0,1));
    }

    protected void createDemoModel() {
        $objectMap.put("demoModel", demoModel = new TimeEditorDemoModel());
    }

    protected void createEditor() {
        $objectMap.put("editor", editor = new TimeEditor(this));
        
        editor.setName("editor");
        editor.setProperty("time");
    }

    protected void createLabelConfig() {
        $objectMap.put("labelConfig", labelConfig = new JTextField());
        
        labelConfig.setName("labelConfig");
        labelConfig.setColumns(15);
    }

    protected void createLabelConfigLabel() {
        $objectMap.put("labelConfigLabel", labelConfigLabel = new JLabel());
        
        labelConfigLabel.setName("labelConfigLabel");
        labelConfigLabel.setText(_("jaxxdemo.timeeditor.label"));
    }

    protected void createResultPane() {
        $objectMap.put("resultPane", resultPane = new JPanel());
        
        resultPane.setName("resultPane");
        resultPane.setLayout(new BorderLayout());
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $DemoPanel0
        add($Table0, BorderLayout.NORTH);
        // inline complete setup of $Table0
        $Table0.add(configPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add(editor, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add(resultPane, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        addChildrenToConfigPanel();
        // inline complete setup of $JPanel0
        $JPanel0.add(labelConfigLabel, BorderLayout.WEST);
        $JPanel0.add(labelConfig, BorderLayout.CENTER);
        addChildrenToResultPane();
        
        // apply 3 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 9 property setters
        editor.setBean(demoModel);
        editor.setBorder(new TitledBorder(_("jaxxdemo.timeeditor.editor")));
        configPanel.setBorder(new TitledBorder(_("jaxxdemo.numbereditor.configuration")));
        SwingUtil.setText(labelConfig, _("jaxxdemo.timeeditor.editor"));
        
        resultPane.setBorder(new TitledBorder(_("jaxxdemo.timeeditor.model")));
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$DemoPanel0", $DemoPanel0);
        createDemoModel();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createConfigPanel();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new BorderLayout());
        createLabelConfigLabel();
        createLabelConfig();
        createEditor();
        createResultPane();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
        setLayout(new BorderLayout());
        
        // registers 3 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 3 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDITOR_DATE, true) {
        
            @Override
            public void applyDataBinding() {
                if (demoModel != null) {
                    demoModel.addPropertyChangeListener("time", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (demoModel != null) {
                    editor.setDate(demoModel.getTime());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (demoModel != null) {
                    demoModel.removePropertyChangeListener("time", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDITOR_LABEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (labelConfig != null) {
                    $bindingSources.put("labelConfig.getDocument()", labelConfig.getDocument());
                    labelConfig.getDocument().addDocumentListener( JAXXUtil.getEventListener(DocumentListener.class, this, "$pr$u0"));
                    labelConfig.addPropertyChangeListener("document", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.TimeEditorDemo.this, BINDING_EDITOR_LABEL));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (labelConfig != null) {
                    editor.setLabel(labelConfig.getText());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (labelConfig != null) {
                    Document $target = (Document) $bindingSources.remove("labelConfig.getDocument()");
                    if ($target != null) {
                        $target.removeDocumentListener( JAXXUtil.getEventListener(DocumentListener.class, this, "$pr$u0"));
                    }
                    labelConfig.removePropertyChangeListener("document", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.TimeEditorDemo.this, BINDING_EDITOR_LABEL));
                }
            }
        
            public void $pr$u0(DocumentEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JLABEL0_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (demoModel != null) {
                    demoModel.addPropertyChangeListener("time", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (demoModel != null) {
                    $JLabel0.setText(_("jaxxdemo.timeeditor.value", demoModel.getTime()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (demoModel != null) {
                    demoModel.removePropertyChangeListener("time", this);
                }
            }
        });
    }

}