package jaxx.demo.feature.databinding;

/*
 * #%L
 * JAXX :: Demo
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2008 - 2013 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.ButtonModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jaxx.demo.DemoPanel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;

public class BindingExtremeDemo extends DemoPanel implements DemoUIModel {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_F0 = "f0";
    public static final String PROPERTY_F1 = "f1";
    public static final String PROPERTY_FILE = "file";
    public static final String PROPERTY_IT1 = "It1";
    public static final String PROPERTY_MODEL1 = "model1";
    public static final String PROPERTY_MT1 = "Mt1";
    public static final String PROPERTY_T1 = "t1";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CF0_A1_SELECTED = "cf0A1.selected";
    public static final String BINDING_CF0_O1_SELECTED = "cf0O1.selected";
    public static final String BINDING_CF0_SELECTED = "cf0.selected";
    public static final String BINDING_CF1_SELECTED = "cf1.selected";
    public static final String BINDING_CGETFILE_TEXT = "cgetfile.text";
    public static final String BINDING_CGETT0_A1_SELECTED = "cgett0A1.selected";
    public static final String BINDING_CGETT0_O1_SELECTED = "cgett0O1.selected";
    public static final String BINDING_CGETT0_SELECTED = "cgett0.selected";
    public static final String BINDING_CGETT1_SELECTED = "cgett1.selected";
    public static final String BINDING_CIGETT0_A1_SELECTED = "cigett0A1.selected";
    public static final String BINDING_CIGETT0_O1_SELECTED = "cigett0O1.selected";
    public static final String BINDING_CIGETT0_SELECTED = "cigett0.selected";
    public static final String BINDING_CIGETT1_SELECTED = "cigett1.selected";
    public static final String BINDING_CIT0_A1_SELECTED = "cit0A1.selected";
    public static final String BINDING_CIT0_O1_SELECTED = "cit0O1.selected";
    public static final String BINDING_CIT0_SELECTED = "cit0.selected";
    public static final String BINDING_CIT1_SELECTED = "cit1.selected";
    public static final String BINDING_CMGETT0_A1_SELECTED = "cmgett0A1.selected";
    public static final String BINDING_CMGETT0_O1_SELECTED = "cmgett0O1.selected";
    public static final String BINDING_CMGETT0_SELECTED = "cmgett0.selected";
    public static final String BINDING_CMGETT1_SELECTED = "cmgett1.selected";
    public static final String BINDING_CMT0_A1_SELECTED = "cmt0A1.selected";
    public static final String BINDING_CMT0_O1_SELECTED = "cmt0O1.selected";
    public static final String BINDING_CMT0_SELECTED = "cmt0.selected";
    public static final String BINDING_CMT1_SELECTED = "cmt1.selected";
    public static final String BINDING_CT0_A1_SELECTED = "ct0A1.selected";
    public static final String BINDING_CT0_O1_SELECTED = "ct0O1.selected";
    public static final String BINDING_CT0_SELECTED = "ct0.selected";
    public static final String BINDING_CT1_SELECTED = "ct1.selected";
    public static final String BINDING_C_IFILE_TEXT = "cIfile.text";
    public static final String BINDING_C_IGETFILE_TEXT = "cIgetfile.text";
    public static final String BINDING_C_MFILE_TEXT = "cMfile.text";
    public static final String BINDING_C_MGETFILE_TEXT = "cMgetfile.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(BindingExtremeDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JToggleButton It0;
    protected JToggleButton It1;
    protected JToggleButton Mt0;
    protected JToggleButton Mt1;
    protected JList bindings;
    protected JTextArea bindingsLabel;
    protected JTextArea cIfile;
    protected JTextArea cIgetfile;
    protected JTextArea cMfile;
    protected JTextArea cMgetfile;
    protected JCheckBox cf0;
    protected JCheckBox cf0A1;
    protected JCheckBox cf0O1;
    protected JCheckBox cf1;
    protected JTextArea cfile;
    protected JTextArea cgetfile;
    protected JCheckBox cgett0;
    protected JCheckBox cgett0A1;
    protected JCheckBox cgett0O1;
    protected JCheckBox cgett1;
    protected JCheckBox cigett0;
    protected JCheckBox cigett0A1;
    protected JCheckBox cigett0O1;
    protected JCheckBox cigett1;
    protected JCheckBox cit0;
    protected JCheckBox cit0A1;
    protected JCheckBox cit0O1;
    protected JCheckBox cit1;
    protected JCheckBox cmgett0;
    protected JCheckBox cmgett0A1;
    protected JCheckBox cmgett0O1;
    protected JCheckBox cmgett1;
    protected JCheckBox cmt0;
    protected JCheckBox cmt0A1;
    protected JCheckBox cmt0O1;
    protected JCheckBox cmt1;
    protected JCheckBox ct0;
    protected JCheckBox ct0A1;
    protected JCheckBox ct0O1;
    protected JCheckBox ct1;
    protected Boolean f0;
    protected Boolean f1;
    protected File file;
    protected BindingExtremeDemo mainFrame = this;
    protected DefaultDemoUIModel model0;
    protected DemoUIModel model1;
    protected JToggleButton t0;
    protected JToggleButton t1;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JButton $JButton0;
    private JButton $JButton1;
    private JButton $JButton2;
    private JPanel $JPanel0;
    private JPanel $JPanel1;
    private JPanel $JPanel10;
    private JPanel $JPanel2;
    private JPanel $JPanel3;
    private JPanel $JPanel4;
    private JPanel $JPanel5;
    private JPanel $JPanel6;
    private JPanel $JPanel7;
    private JPanel $JPanel8;
    private JPanel $JPanel9;
    private JScrollPane $JScrollPane0;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public JToggleButton getT3() { return t0; }
    
    private void $afterCompleteSetup() {
        for (Object o : $objectMap.values()) {
            if (o instanceof JCheckBox) {
                JCheckBox c = (JCheckBox) o;
                c.setBackground($bindings.containsKey(c.getName() + ".selected") ? Color.WHITE : Color.RED);
            }
        }
        SwingUtilities.invokeLater(new Runnable() {
    
            @Override
            public void run() {
                DefaultListModel m = (DefaultListModel) bindings.getModel();
                for (JAXXBinding b : getDataBindings()) {
                    m.addElement(b.getId());
                }
            }
        });
    }
    @Override
    protected String[] getSources() {
        return new String[]{ getDefaultSource(), "DemoUIModel.java", "DefaultDemoUIModel.java" };
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public BindingExtremeDemo(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public BindingExtremeDemo(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public BindingExtremeDemo(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public BindingExtremeDemo(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public BindingExtremeDemo() {
        $initialize();
    }

    public BindingExtremeDemo(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public BindingExtremeDemo(boolean param0) {
        super(param0);
        $initialize();
    }

    public BindingExtremeDemo(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setFile(org.nuiton.util.FileUtil.getFile(this, new String[0]));
    }

    public void doActionPerformed__on__$JButton1(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model0.setFile(org.nuiton.util.FileUtil.getFile(this,new String[0]));
    }

    public void doActionPerformed__on__$JButton2(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model1.setFile(org.nuiton.util.FileUtil.getFile(this,new String[0]));
    }

    public void doActionPerformed__on__It0(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model1.setF0(!model1.isF0());
    }

    public void doActionPerformed__on__It1(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model1.setF1(!model1.isF1());
    }

    public void doActionPerformed__on__Mt0(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model0.setF0(!model0.isF0());
    }

    public void doActionPerformed__on__Mt1(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model0.setF1(!model0.isF1());
    }

    public void doActionPerformed__on__t0(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setF0(!f0);
    }

    public void doActionPerformed__on__t1(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setF1(!f1);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JList getBindings() {
        return bindings;
    }

    public JTextArea getBindingsLabel() {
        return bindingsLabel;
    }

    public JTextArea getCIfile() {
        return cIfile;
    }

    public JTextArea getCIgetfile() {
        return cIgetfile;
    }

    public JTextArea getCMfile() {
        return cMfile;
    }

    public JTextArea getCMgetfile() {
        return cMgetfile;
    }

    public JCheckBox getCf0() {
        return cf0;
    }

    public JCheckBox getCf0A1() {
        return cf0A1;
    }

    public JCheckBox getCf0O1() {
        return cf0O1;
    }

    public JCheckBox getCf1() {
        return cf1;
    }

    public JTextArea getCfile() {
        return cfile;
    }

    public JTextArea getCgetfile() {
        return cgetfile;
    }

    public JCheckBox getCgett0() {
        return cgett0;
    }

    public JCheckBox getCgett0A1() {
        return cgett0A1;
    }

    public JCheckBox getCgett0O1() {
        return cgett0O1;
    }

    public JCheckBox getCgett1() {
        return cgett1;
    }

    public JCheckBox getCigett0() {
        return cigett0;
    }

    public JCheckBox getCigett0A1() {
        return cigett0A1;
    }

    public JCheckBox getCigett0O1() {
        return cigett0O1;
    }

    public JCheckBox getCigett1() {
        return cigett1;
    }

    public JCheckBox getCit0() {
        return cit0;
    }

    public JCheckBox getCit0A1() {
        return cit0A1;
    }

    public JCheckBox getCit0O1() {
        return cit0O1;
    }

    public JCheckBox getCit1() {
        return cit1;
    }

    public JCheckBox getCmgett0() {
        return cmgett0;
    }

    public JCheckBox getCmgett0A1() {
        return cmgett0A1;
    }

    public JCheckBox getCmgett0O1() {
        return cmgett0O1;
    }

    public JCheckBox getCmgett1() {
        return cmgett1;
    }

    public JCheckBox getCmt0() {
        return cmt0;
    }

    public JCheckBox getCmt0A1() {
        return cmt0A1;
    }

    public JCheckBox getCmt0O1() {
        return cmt0O1;
    }

    public JCheckBox getCmt1() {
        return cmt1;
    }

    public JCheckBox getCt0() {
        return ct0;
    }

    public JCheckBox getCt0A1() {
        return ct0A1;
    }

    public JCheckBox getCt0O1() {
        return ct0O1;
    }

    public JCheckBox getCt1() {
        return ct1;
    }

    public Boolean getF0() {
        return f0;
    }

    public Boolean getF1() {
        return f1;
    }

    public File getFile() {
        return file;
    }

    public JToggleButton getIt0() {
        return It0;
    }

    public JToggleButton getIt1() {
        return It1;
    }

    public DefaultDemoUIModel getModel0() {
        return model0;
    }

    public DemoUIModel getModel1() {
        return model1;
    }

    public JToggleButton getMt0() {
        return Mt0;
    }

    public JToggleButton getMt1() {
        return Mt1;
    }

    public JToggleButton getT0() {
        return t0;
    }

    public JToggleButton getT1() {
        return t1;
    }

    public Boolean isF0() {
        return f0 !=null && f0;
    }

    public Boolean isF1() {
        return f1 !=null && f1;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setF0(Boolean f0) {
        Boolean oldValue = this.f0;
        this.f0 = f0;
        firePropertyChange(PROPERTY_F0, oldValue, f0);
    }

    public void setF1(Boolean f1) {
        Boolean oldValue = this.f1;
        this.f1 = f1;
        firePropertyChange(PROPERTY_F1, oldValue, f1);
    }

    public void setFile(File file) {
        File oldValue = this.file;
        this.file = file;
        firePropertyChange(PROPERTY_FILE, oldValue, file);
    }

    public void setIt1(JToggleButton It1) {
        JToggleButton oldValue = this.It1;
        this.It1 = It1;
        firePropertyChange(PROPERTY_IT1, oldValue, It1);
    }

    public void setModel1(DemoUIModel model1) {
        DemoUIModel oldValue = this.model1;
        this.model1 = model1;
        firePropertyChange(PROPERTY_MODEL1, oldValue, model1);
    }

    public void setMt1(JToggleButton Mt1) {
        JToggleButton oldValue = this.Mt1;
        this.Mt1 = Mt1;
        firePropertyChange(PROPERTY_MT1, oldValue, Mt1);
    }

    public void setT1(JToggleButton t1) {
        JToggleButton oldValue = this.t1;
        this.t1 = t1;
        firePropertyChange(PROPERTY_T1, oldValue, t1);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton get$JButton0() {
        return $JButton0;
    }

    protected JButton get$JButton1() {
        return $JButton1;
    }

    protected JButton get$JButton2() {
        return $JButton2;
    }

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected JPanel get$JPanel10() {
        return $JPanel10;
    }

    protected JPanel get$JPanel2() {
        return $JPanel2;
    }

    protected JPanel get$JPanel3() {
        return $JPanel3;
    }

    protected JPanel get$JPanel4() {
        return $JPanel4;
    }

    protected JPanel get$JPanel5() {
        return $JPanel5;
    }

    protected JPanel get$JPanel6() {
        return $JPanel6;
    }

    protected JPanel get$JPanel7() {
        return $JPanel7;
    }

    protected JPanel get$JPanel8() {
        return $JPanel8;
    }

    protected JPanel get$JPanel9() {
        return $JPanel9;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToMainFrame() {
        if (!allComponentsCreated) {
            return;
        }
        add($Table0, BorderLayout.CENTER);
    }

    protected void createBindings() {
        $objectMap.put("bindings", bindings = new JList());
        
        bindings.setName("bindings");
        if (bindings.getFont() != null) {
            bindings.setFont(bindings.getFont().deriveFont((float) 10));
        }
    }

    protected void createBindingsLabel() {
        $objectMap.put("bindingsLabel", bindingsLabel = new JTextArea());
        
        bindingsLabel.setName("bindingsLabel");
        bindingsLabel.setColumns(15);
        bindingsLabel.setLineWrap(true);
        bindingsLabel.setWrapStyleWord(true);
        bindingsLabel.setEditable(false);
    }

    protected void createCIfile() {
        $objectMap.put("cIfile", cIfile = new JTextArea());
        
        cIfile.setName("cIfile");
        cIfile.setColumns(15);
        cIfile.setLineWrap(true);
        cIfile.setWrapStyleWord(true);
        cIfile.setEditable(false);
    }

    protected void createCIgetfile() {
        $objectMap.put("cIgetfile", cIgetfile = new JTextArea());
        
        cIgetfile.setName("cIgetfile");
        cIgetfile.setColumns(15);
        cIgetfile.setLineWrap(true);
        cIgetfile.setWrapStyleWord(true);
        cIgetfile.setEditable(false);
    }

    protected void createCMfile() {
        $objectMap.put("cMfile", cMfile = new JTextArea());
        
        cMfile.setName("cMfile");
        cMfile.setColumns(15);
        cMfile.setLineWrap(true);
        cMfile.setWrapStyleWord(true);
        cMfile.setEditable(false);
    }

    protected void createCMgetfile() {
        $objectMap.put("cMgetfile", cMgetfile = new JTextArea());
        
        cMgetfile.setName("cMgetfile");
        cMgetfile.setColumns(15);
        cMgetfile.setLineWrap(true);
        cMgetfile.setWrapStyleWord(true);
        cMgetfile.setEditable(false);
    }

    protected void createCf0() {
        $objectMap.put("cf0", cf0 = new JCheckBox());
        
        cf0.setName("cf0");
        cf0.setText(_("isF0()"));
        cf0.setEnabled(false);
    }

    protected void createCf0A1() {
        $objectMap.put("cf0A1", cf0A1 = new JCheckBox());
        
        cf0A1.setName("cf0A1");
        cf0A1.setText(_("isF0() && isF1()"));
        cf0A1.setEnabled(false);
    }

    protected void createCf0O1() {
        $objectMap.put("cf0O1", cf0O1 = new JCheckBox());
        
        cf0O1.setName("cf0O1");
        cf0O1.setText(_("isF0() || isF1()"));
        cf0O1.setEnabled(false);
    }

    protected void createCf1() {
        $objectMap.put("cf1", cf1 = new JCheckBox());
        
        cf1.setName("cf1");
        cf1.setText(_("isF1()"));
        cf1.setEnabled(false);
    }

    protected void createCfile() {
        $objectMap.put("cfile", cfile = new JTextArea());
        
        cfile.setName("cfile");
        cfile.setColumns(15);
        cfile.setLineWrap(true);
        cfile.setWrapStyleWord(true);
        cfile.setEditable(false);
    }

    protected void createCgetfile() {
        $objectMap.put("cgetfile", cgetfile = new JTextArea());
        
        cgetfile.setName("cgetfile");
        cgetfile.setColumns(15);
        cgetfile.setLineWrap(true);
        cgetfile.setWrapStyleWord(true);
        cgetfile.setEditable(false);
    }

    protected void createCgett0() {
        $objectMap.put("cgett0", cgett0 = new JCheckBox());
        
        cgett0.setName("cgett0");
        cgett0.setText(_("getT0().isSelected()"));
        cgett0.setEnabled(false);
    }

    protected void createCgett0A1() {
        $objectMap.put("cgett0A1", cgett0A1 = new JCheckBox());
        
        cgett0A1.setName("cgett0A1");
        cgett0A1.setText(_("getT0().isSelected() && getT1().isSelected()"));
        cgett0A1.setEnabled(false);
    }

    protected void createCgett0O1() {
        $objectMap.put("cgett0O1", cgett0O1 = new JCheckBox());
        
        cgett0O1.setName("cgett0O1");
        cgett0O1.setText(_("getT0().isSelected() || getT1().isSelected()"));
        cgett0O1.setEnabled(false);
    }

    protected void createCgett1() {
        $objectMap.put("cgett1", cgett1 = new JCheckBox());
        
        cgett1.setName("cgett1");
        cgett1.setText(_("getT1().isSelected()"));
        cgett1.setEnabled(false);
    }

    protected void createCigett0() {
        $objectMap.put("cigett0", cigett0 = new JCheckBox());
        
        cigett0.setName("cigett0");
        cigett0.setText(_("getModel1().isF0()"));
        cigett0.setEnabled(false);
    }

    protected void createCigett0A1() {
        $objectMap.put("cigett0A1", cigett0A1 = new JCheckBox());
        
        cigett0A1.setName("cigett0A1");
        cigett0A1.setText(_("getModel1().isF0() && getModel1().isF1()"));
        cigett0A1.setEnabled(false);
    }

    protected void createCigett0O1() {
        $objectMap.put("cigett0O1", cigett0O1 = new JCheckBox());
        
        cigett0O1.setName("cigett0O1");
        cigett0O1.setText(_("getModel1().isF0() || getModel1().isF1()"));
        cigett0O1.setEnabled(false);
    }

    protected void createCigett1() {
        $objectMap.put("cigett1", cigett1 = new JCheckBox());
        
        cigett1.setName("cigett1");
        cigett1.setText(_("getModel1().isF1()"));
        cigett1.setEnabled(false);
    }

    protected void createCit0() {
        $objectMap.put("cit0", cit0 = new JCheckBox());
        
        cit0.setName("cit0");
        cit0.setText(_("model1.isF0()"));
        cit0.setEnabled(false);
    }

    protected void createCit0A1() {
        $objectMap.put("cit0A1", cit0A1 = new JCheckBox());
        
        cit0A1.setName("cit0A1");
        cit0A1.setText(_("model1.isF0() && model1.isF1()"));
        cit0A1.setEnabled(false);
    }

    protected void createCit0O1() {
        $objectMap.put("cit0O1", cit0O1 = new JCheckBox());
        
        cit0O1.setName("cit0O1");
        cit0O1.setText(_("model1.isF0() || model1.isF1()"));
        cit0O1.setEnabled(false);
    }

    protected void createCit1() {
        $objectMap.put("cit1", cit1 = new JCheckBox());
        
        cit1.setName("cit1");
        cit1.setText(_("model1.isF1()"));
        cit1.setEnabled(false);
    }

    protected void createCmgett0() {
        $objectMap.put("cmgett0", cmgett0 = new JCheckBox());
        
        cmgett0.setName("cmgett0");
        cmgett0.setText(_("getModel0().isF0()"));
        cmgett0.setEnabled(false);
    }

    protected void createCmgett0A1() {
        $objectMap.put("cmgett0A1", cmgett0A1 = new JCheckBox());
        
        cmgett0A1.setName("cmgett0A1");
        cmgett0A1.setText(_("getModel0().isF0() && getModel0().isF1()"));
        cmgett0A1.setEnabled(false);
    }

    protected void createCmgett0O1() {
        $objectMap.put("cmgett0O1", cmgett0O1 = new JCheckBox());
        
        cmgett0O1.setName("cmgett0O1");
        cmgett0O1.setText(_("getModel0().isF0() || getModel0().isF1()"));
        cmgett0O1.setEnabled(false);
    }

    protected void createCmgett1() {
        $objectMap.put("cmgett1", cmgett1 = new JCheckBox());
        
        cmgett1.setName("cmgett1");
        cmgett1.setText(_("getModel0().isF1()"));
        cmgett1.setEnabled(false);
    }

    protected void createCmt0() {
        $objectMap.put("cmt0", cmt0 = new JCheckBox());
        
        cmt0.setName("cmt0");
        cmt0.setText(_("model0.isF0()"));
        cmt0.setEnabled(false);
    }

    protected void createCmt0A1() {
        $objectMap.put("cmt0A1", cmt0A1 = new JCheckBox());
        
        cmt0A1.setName("cmt0A1");
        cmt0A1.setText(_("model0.isF0() && model0.isF1()"));
        cmt0A1.setEnabled(false);
    }

    protected void createCmt0O1() {
        $objectMap.put("cmt0O1", cmt0O1 = new JCheckBox());
        
        cmt0O1.setName("cmt0O1");
        cmt0O1.setText(_("model0.isF0() || model0.isF1()"));
        cmt0O1.setEnabled(false);
    }

    protected void createCmt1() {
        $objectMap.put("cmt1", cmt1 = new JCheckBox());
        
        cmt1.setName("cmt1");
        cmt1.setText(_("model0.isF1()"));
        cmt1.setEnabled(false);
    }

    protected void createCt0() {
        $objectMap.put("ct0", ct0 = new JCheckBox());
        
        ct0.setName("ct0");
        ct0.setText(_("t0.isSelected()"));
        ct0.setEnabled(false);
    }

    protected void createCt0A1() {
        $objectMap.put("ct0A1", ct0A1 = new JCheckBox());
        
        ct0A1.setName("ct0A1");
        ct0A1.setText(_("t0.isSelected() && t1.isSelected()"));
        ct0A1.setEnabled(false);
    }

    protected void createCt0O1() {
        $objectMap.put("ct0O1", ct0O1 = new JCheckBox());
        
        ct0O1.setName("ct0O1");
        ct0O1.setText(_("t0.isSelected() || t1.isSelected()"));
        ct0O1.setEnabled(false);
    }

    protected void createCt1() {
        $objectMap.put("ct1", ct1 = new JCheckBox());
        
        ct1.setName("ct1");
        ct1.setText(_("t1.isSelected()"));
        ct1.setEnabled(false);
    }

    protected void createF0() {
        $objectMap.put("f0", f0 = Boolean.FALSE);
    }

    protected void createF1() {
        $objectMap.put("f1", f1 = Boolean.FALSE);
    }

    protected void createFile() {
        $objectMap.put("file", file = new java.io.File("."));
    }

    protected void createIt0() {
        $objectMap.put("It0", It0 = new JToggleButton());
        
        It0.setName("It0");
        It0.setText(_("model1.f0"));
        It0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__It0"));
    }

    protected void createIt1() {
        $objectMap.put("It1", It1 = new JToggleButton());
        
        It1.setName("It1");
        It1.setText(_("model1.f1"));
        It1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__It1"));
    }

    protected void createModel0() {
        $objectMap.put("model0", model0 = new DefaultDemoUIModel());
    }

    protected void createModel1() {
        $objectMap.put("model1", model1 = new DefaultDemoUIModel());
    }

    protected void createMt0() {
        $objectMap.put("Mt0", Mt0 = new JToggleButton());
        
        Mt0.setName("Mt0");
        Mt0.setText(_("model0.f0"));
        Mt0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__Mt0"));
    }

    protected void createMt1() {
        $objectMap.put("Mt1", Mt1 = new JToggleButton());
        
        Mt1.setName("Mt1");
        Mt1.setText(_("model0.f1"));
        Mt1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__Mt1"));
    }

    protected void createT0() {
        $objectMap.put("t0", t0 = new JToggleButton());
        
        t0.setName("t0");
        t0.setText(_("f0"));
        t0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__t0"));
    }

    protected void createT1() {
        $objectMap.put("t1", t1 = new JToggleButton());
        
        t1.setName("t1");
        t1.setText(_("f1"));
        t1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__t1"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToMainFrame();
        // inline complete setup of $Table0
        $Table0.add($JPanel0, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel1, new GridBagConstraints(0, 1, 3, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel2, new GridBagConstraints(0, 2, 3, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel3, new GridBagConstraints(0, 3, 3, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(t0, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(t1, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JButton0, new GridBagConstraints(2, 4, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel4, new GridBagConstraints(0, 5, 3, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel5, new GridBagConstraints(0, 6, 3, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel6, new GridBagConstraints(0, 7, 3, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(Mt0, new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(Mt1, new GridBagConstraints(1, 8, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JButton1, new GridBagConstraints(2, 8, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel7, new GridBagConstraints(0, 9, 3, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel8, new GridBagConstraints(0, 10, 3, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel9, new GridBagConstraints(0, 11, 3, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(It0, new GridBagConstraints(0, 12, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(It1, new GridBagConstraints(1, 12, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JButton2, new GridBagConstraints(2, 12, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel10, new GridBagConstraints(0, 13, 3, 1, 0.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JPanel0
        $JPanel0.add(cf0);
        $JPanel0.add(cf1);
        $JPanel0.add(cf0O1);
        $JPanel0.add(cf0A1);
        // inline complete setup of $JPanel1
        $JPanel1.add(ct0);
        $JPanel1.add(ct1);
        $JPanel1.add(ct0O1);
        $JPanel1.add(ct0A1);
        // inline complete setup of $JPanel2
        $JPanel2.add(cgett0);
        $JPanel2.add(cgett1);
        $JPanel2.add(cgett0O1);
        $JPanel2.add(cgett0A1);
        // inline complete setup of $JPanel3
        $JPanel3.add(cfile);
        $JPanel3.add(cgetfile);
        // inline complete setup of $JPanel4
        $JPanel4.add(cmt0);
        $JPanel4.add(cmt1);
        $JPanel4.add(cmt0O1);
        $JPanel4.add(cmt0A1);
        // inline complete setup of $JPanel5
        $JPanel5.add(cmgett0);
        $JPanel5.add(cmgett1);
        $JPanel5.add(cmgett0O1);
        $JPanel5.add(cmgett0A1);
        // inline complete setup of $JPanel6
        $JPanel6.add(cMfile);
        $JPanel6.add(cMgetfile);
        // inline complete setup of $JPanel7
        $JPanel7.add(cit0);
        $JPanel7.add(cit1);
        $JPanel7.add(cit0O1);
        $JPanel7.add(cit0A1);
        // inline complete setup of $JPanel8
        $JPanel8.add(cigett0);
        $JPanel8.add(cigett1);
        $JPanel8.add(cigett0O1);
        $JPanel8.add(cigett0A1);
        // inline complete setup of $JPanel9
        $JPanel9.add(cIfile);
        $JPanel9.add(cIgetfile);
        // inline complete setup of $JPanel10
        $JPanel10.add(bindingsLabel);
        $JPanel10.add($JScrollPane0, BorderLayout.CENTER);
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(bindings);
        
        // apply 33 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 29 property setters
        cfile.setBorder(new TitledBorder("file.getAbsolutePath()"));
        cfile.setVisible(!$bindings.containsKey("cfile.text"));
        SwingUtil.setText(cfile, file.getAbsolutePath());
        
        cgetfile.setBorder(new TitledBorder("getFile().getAbsolutePath()"));
        cgetfile.setVisible($bindings.containsKey("cgetfile.text"));
        cMfile.setBorder(new TitledBorder("model0.getFile().getAbsolutePath()"));
        cMfile.setVisible($bindings.containsKey("cMfile.text"));
        cMgetfile.setBorder(new TitledBorder("getModel0().getFile().getAbsolutePath()"));
        cMgetfile.setVisible($bindings.containsKey("cMgetfile.text"));
        cIfile.setBorder(new TitledBorder("model1.getFile().getAbsolutePath()"));
        cIfile.setVisible($bindings.containsKey("cIfile.text"));
        cIgetfile.setBorder(new TitledBorder("getModel1().getFile().getAbsolutePath()"));
        cIgetfile.setVisible($bindings.containsKey("cIgetfile.text"));
        SwingUtil.setText(bindingsLabel, $bindings.size() + " bindings.");
        
        $JScrollPane0.setColumnHeaderView(bindingsLabel);
        bindings.setModel(new DefaultListModel());
        cfile.setBackground(Color.GRAY);
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("mainFrame", mainFrame);
        createF0();
        createF1();
        createFile();
        createModel0();
        createModel1();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1,0));
        createCf0();
        createCf1();
        createCf0O1();
        createCf0A1();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new GridLayout(1,0));
        createCt0();
        createCt1();
        createCt0O1();
        createCt0A1();
        // inline creation of $JPanel2
        $objectMap.put("$JPanel2", $JPanel2 = new JPanel());
        
        $JPanel2.setName("$JPanel2");
        $JPanel2.setLayout(new GridLayout(1,0));
        createCgett0();
        createCgett1();
        createCgett0O1();
        createCgett0A1();
        // inline creation of $JPanel3
        $objectMap.put("$JPanel3", $JPanel3 = new JPanel());
        
        $JPanel3.setName("$JPanel3");
        $JPanel3.setLayout(new GridLayout(1,0));
        createCfile();
        createCgetfile();
        createT0();
        createT1();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(_("file..."));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $JPanel4
        $objectMap.put("$JPanel4", $JPanel4 = new JPanel());
        
        $JPanel4.setName("$JPanel4");
        $JPanel4.setLayout(new GridLayout(1,0));
        createCmt0();
        createCmt1();
        createCmt0O1();
        createCmt0A1();
        // inline creation of $JPanel5
        $objectMap.put("$JPanel5", $JPanel5 = new JPanel());
        
        $JPanel5.setName("$JPanel5");
        $JPanel5.setLayout(new GridLayout(1,0));
        createCmgett0();
        createCmgett1();
        createCmgett0O1();
        createCmgett0A1();
        // inline creation of $JPanel6
        $objectMap.put("$JPanel6", $JPanel6 = new JPanel());
        
        $JPanel6.setName("$JPanel6");
        $JPanel6.setLayout(new GridLayout(1,0));
        createCMfile();
        createCMgetfile();
        createMt0();
        createMt1();
        // inline creation of $JButton1
        $objectMap.put("$JButton1", $JButton1 = new JButton());
        
        $JButton1.setName("$JButton1");
        $JButton1.setText(_("model0.file..."));
        $JButton1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton1"));
        // inline creation of $JPanel7
        $objectMap.put("$JPanel7", $JPanel7 = new JPanel());
        
        $JPanel7.setName("$JPanel7");
        $JPanel7.setLayout(new GridLayout(1,0));
        createCit0();
        createCit1();
        createCit0O1();
        createCit0A1();
        // inline creation of $JPanel8
        $objectMap.put("$JPanel8", $JPanel8 = new JPanel());
        
        $JPanel8.setName("$JPanel8");
        $JPanel8.setLayout(new GridLayout(1,0));
        createCigett0();
        createCigett1();
        createCigett0O1();
        createCigett0A1();
        // inline creation of $JPanel9
        $objectMap.put("$JPanel9", $JPanel9 = new JPanel());
        
        $JPanel9.setName("$JPanel9");
        $JPanel9.setLayout(new GridLayout(1,0));
        createCIfile();
        createCIgetfile();
        createIt0();
        createIt1();
        // inline creation of $JButton2
        $objectMap.put("$JButton2", $JButton2 = new JButton());
        
        $JButton2.setName("$JButton2");
        $JButton2.setText(_("model1.file..."));
        $JButton2.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton2"));
        // inline creation of $JPanel10
        $objectMap.put("$JPanel10", $JPanel10 = new JPanel());
        
        $JPanel10.setName("$JPanel10");
        $JPanel10.setLayout(new BorderLayout());
        createBindingsLabel();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createBindings();
        // inline creation of mainFrame
        setName("mainFrame");
        setLayout(new BorderLayout());
        
        // registers 33 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 33 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_CF0_SELECTED, true ,"f0") {
        
            @Override
            public void processDataBinding() {
                cf0.setSelected(isF0());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_CF1_SELECTED, true ,"f1") {
        
            @Override
            public void processDataBinding() {
                cf1.setSelected(isF1());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_CF0_O1_SELECTED, true ,"f0" ,"f1") {
        
            @Override
            public void processDataBinding() {
                cf0O1.setSelected(isF0() || isF1());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_CF0_A1_SELECTED, true ,"f0" ,"f1") {
        
            @Override
            public void processDataBinding() {
                cf0A1.setSelected(isF0() && isF1());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CT0_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (t0 != null) {
                    $bindingSources.put("t0.getModel()", t0.getModel());
                    t0.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    t0.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.feature.databinding.BindingExtremeDemo.this, BINDING_CT0_SELECTED));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (t0 != null) {
                    ct0.setSelected(t0.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (t0 != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("t0.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    }
                    t0.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.feature.databinding.BindingExtremeDemo.this, BINDING_CT0_SELECTED));
                }
            }
        
            public void $pr$u0(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CT1_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (t1 != null) {
                    $bindingSources.put("t1.getModel()", t1.getModel());
                    t1.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u1"));
                    t1.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.feature.databinding.BindingExtremeDemo.this, BINDING_CT1_SELECTED));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (t1 != null) {
                    ct1.setSelected(t1.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (t1 != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("t1.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u1"));
                    }
                    t1.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.feature.databinding.BindingExtremeDemo.this, BINDING_CT1_SELECTED));
                }
            }
        
            public void $pr$u1(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CT0_O1_SELECTED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (t0 != null) {
                    $bindingSources.put("t0.getModel()", t0.getModel());
                    t0.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u2"));
                    t0.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.feature.databinding.BindingExtremeDemo.this, BINDING_CT0_O1_SELECTED));
                }
                if (t1 != null) {
                    $bindingSources.put("t1.getModel()", t1.getModel());
                    t1.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u2"));
                    t1.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.feature.databinding.BindingExtremeDemo.this, BINDING_CT0_O1_SELECTED));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (t0 != null && t1 != null) {
                    ct0O1.setSelected(t0.isSelected() || t1.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (t0 != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("t0.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u2"));
                    }
                    t0.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.feature.databinding.BindingExtremeDemo.this, BINDING_CT0_O1_SELECTED));
                }
                if (t1 != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("t1.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u2"));
                    }
                    t1.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.feature.databinding.BindingExtremeDemo.this, BINDING_CT0_O1_SELECTED));
                }
            }
        
            public void $pr$u2(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CT0_A1_SELECTED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (t0 != null) {
                    $bindingSources.put("t0.getModel()", t0.getModel());
                    t0.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u3"));
                    t0.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.feature.databinding.BindingExtremeDemo.this, BINDING_CT0_A1_SELECTED));
                }
                if (t1 != null) {
                    $bindingSources.put("t1.getModel()", t1.getModel());
                    t1.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u3"));
                    t1.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.feature.databinding.BindingExtremeDemo.this, BINDING_CT0_A1_SELECTED));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (t0 != null && t1 != null) {
                    ct0A1.setSelected(t0.isSelected() && t1.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (t0 != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("t0.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u3"));
                    }
                    t0.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.feature.databinding.BindingExtremeDemo.this, BINDING_CT0_A1_SELECTED));
                }
                if (t1 != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("t1.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u3"));
                    }
                    t1.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.feature.databinding.BindingExtremeDemo.this, BINDING_CT0_A1_SELECTED));
                }
            }
        
            public void $pr$u3(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CGETT0_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (getT0() != null) {
                    $bindingSources.put("getT0().getModel()", getT0().getModel());
                    getT0().getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u4"));
                    getT0().addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.feature.databinding.BindingExtremeDemo.this, BINDING_CGETT0_SELECTED));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getT0() != null) {
                    cgett0.setSelected(getT0().isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getT0() != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("getT0().getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u4"));
                    }
                    getT0().removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.feature.databinding.BindingExtremeDemo.this, BINDING_CGETT0_SELECTED));
                }
            }
        
            public void $pr$u4(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CGETT1_SELECTED, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("t1", this);
                if (getT1() != null) {
                    $bindingSources.put("getT1().getModel()", getT1().getModel());
                    getT1().getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u5"));
                    getT1().addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.feature.databinding.BindingExtremeDemo.this, BINDING_CGETT1_SELECTED));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getT1() != null) {
                    cgett1.setSelected(getT1().isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("t1", this);
                if (getT1() != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("getT1().getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u5"));
                    }
                    getT1().removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.feature.databinding.BindingExtremeDemo.this, BINDING_CGETT1_SELECTED));
                }
            }
        
            public void $pr$u5(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CGETT0_O1_SELECTED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (getT0() != null) {
                    $bindingSources.put("getT0().getModel()", getT0().getModel());
                    getT0().getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u6"));
                    getT0().addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.feature.databinding.BindingExtremeDemo.this, BINDING_CGETT0_O1_SELECTED));
                }
                addPropertyChangeListener("t1", this);
                if (getT1() != null) {
                    $bindingSources.put(" getT1().getModel()",  getT1().getModel());
                     getT1().getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u6"));
                    getT1().addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.feature.databinding.BindingExtremeDemo.this, BINDING_CGETT0_O1_SELECTED));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getT0() != null && getT1() != null) {
                    cgett0O1.setSelected(getT0().isSelected() || getT1().isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getT0() != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("getT0().getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u6"));
                    }
                    getT0().removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.feature.databinding.BindingExtremeDemo.this, BINDING_CGETT0_O1_SELECTED));
                }
                removePropertyChangeListener("t1", this);
                if (getT1() != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove(" getT1().getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u6"));
                    }
                    getT1().removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.feature.databinding.BindingExtremeDemo.this, BINDING_CGETT0_O1_SELECTED));
                }
            }
        
            public void $pr$u6(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CGETT0_A1_SELECTED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (getT0() != null) {
                    $bindingSources.put("getT0().getModel()", getT0().getModel());
                    getT0().getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u7"));
                    getT0().addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.feature.databinding.BindingExtremeDemo.this, BINDING_CGETT0_A1_SELECTED));
                }
                addPropertyChangeListener("t1", this);
                if (getT1() != null) {
                    $bindingSources.put(" getT1().getModel()",  getT1().getModel());
                     getT1().getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u7"));
                    getT1().addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.feature.databinding.BindingExtremeDemo.this, BINDING_CGETT0_A1_SELECTED));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getT0() != null && getT1() != null) {
                    cgett0A1.setSelected(getT0().isSelected() && getT1().isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getT0() != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("getT0().getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u7"));
                    }
                    getT0().removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.feature.databinding.BindingExtremeDemo.this, BINDING_CGETT0_A1_SELECTED));
                }
                removePropertyChangeListener("t1", this);
                if (getT1() != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove(" getT1().getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u7"));
                    }
                    getT1().removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.feature.databinding.BindingExtremeDemo.this, BINDING_CGETT0_A1_SELECTED));
                }
            }
        
            public void $pr$u7(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_CGETFILE_TEXT, true ,"file") {
        
            @Override
            public void processDataBinding() {
                if (getFile() != null) {
                    SwingUtil.setText(cgetfile, getFile().getAbsolutePath());
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CMT0_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model0 != null) {
                    model0.addPropertyChangeListener("f0", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model0 != null) {
                    cmt0.setSelected(model0.isF0());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model0 != null) {
                    model0.removePropertyChangeListener("f0", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CMT1_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model0 != null) {
                    model0.addPropertyChangeListener("f1", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model0 != null) {
                    cmt1.setSelected(model0.isF1());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model0 != null) {
                    model0.removePropertyChangeListener("f1", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CMT0_O1_SELECTED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model0 != null) {
                    model0.addPropertyChangeListener("f0", this);
                }
                if (model0 != null) {
                    model0.addPropertyChangeListener("f1", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model0 != null) {
                    cmt0O1.setSelected(model0.isF0() || model0.isF1());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model0 != null) {
                    model0.removePropertyChangeListener("f0", this);
                }
                if (model0 != null) {
                    model0.removePropertyChangeListener("f1", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CMT0_A1_SELECTED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model0 != null) {
                    model0.addPropertyChangeListener("f0", this);
                }
                if (model0 != null) {
                    model0.addPropertyChangeListener("f1", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model0 != null) {
                    cmt0A1.setSelected(model0.isF0() && model0.isF1());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model0 != null) {
                    model0.removePropertyChangeListener("f0", this);
                }
                if (model0 != null) {
                    model0.removePropertyChangeListener("f1", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CMGETT0_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (getModel0() != null) {
                    getModel0().addPropertyChangeListener("f0", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getModel0() != null) {
                    cmgett0.setSelected(getModel0().isF0());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getModel0() != null) {
                    getModel0().removePropertyChangeListener("f0", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CMGETT1_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (getModel0() != null) {
                    getModel0().addPropertyChangeListener("f1", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getModel0() != null) {
                    cmgett1.setSelected(getModel0().isF1());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getModel0() != null) {
                    getModel0().removePropertyChangeListener("f1", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CMGETT0_O1_SELECTED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (getModel0() != null) {
                    getModel0().addPropertyChangeListener("f0", this);
                }
                if (getModel0() != null) {
                    getModel0().addPropertyChangeListener("f1", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getModel0() != null) {
                    cmgett0O1.setSelected(getModel0().isF0() || getModel0().isF1());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getModel0() != null) {
                    getModel0().removePropertyChangeListener("f0", this);
                }
                if (getModel0() != null) {
                    getModel0().removePropertyChangeListener("f1", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CMGETT0_A1_SELECTED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (getModel0() != null) {
                    getModel0().addPropertyChangeListener("f0", this);
                }
                if (getModel0() != null) {
                    getModel0().addPropertyChangeListener("f1", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getModel0() != null) {
                    cmgett0A1.setSelected(getModel0().isF0() && getModel0().isF1());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getModel0() != null) {
                    getModel0().removePropertyChangeListener("f0", this);
                }
                if (getModel0() != null) {
                    getModel0().removePropertyChangeListener("f1", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_C_MFILE_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model0 != null) {
                    model0.addPropertyChangeListener("file", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model0 != null && model0.getFile() != null) {
                    SwingUtil.setText(cMfile, model0.getFile().getAbsolutePath());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model0 != null) {
                    model0.removePropertyChangeListener("file", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_C_MGETFILE_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (getModel0() != null) {
                    getModel0().addPropertyChangeListener("file", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getModel0() != null && getModel0().getFile() != null) {
                    SwingUtil.setText(cMgetfile, getModel0().getFile().getAbsolutePath());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getModel0() != null) {
                    getModel0().removePropertyChangeListener("file", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CIT0_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (((DemoUIModel)model1) != null) {
                    ((DemoUIModel)model1).addPropertyChangeListener("f0", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model1 != null) {
                    cit0.setSelected(((DemoUIModel)model1).isF0());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (((DemoUIModel)model1) != null) {
                    ((DemoUIModel)model1).removePropertyChangeListener("f0", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CIT1_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (((DemoUIModel)model1) != null) {
                    ((DemoUIModel)model1).addPropertyChangeListener("f1", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model1 != null) {
                    cit1.setSelected(((DemoUIModel)model1).isF1());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (((DemoUIModel)model1) != null) {
                    ((DemoUIModel)model1).removePropertyChangeListener("f1", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CIT0_O1_SELECTED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (((DemoUIModel)model1) != null) {
                    ((DemoUIModel)model1).addPropertyChangeListener("f0", this);
                }
                if (((DemoUIModel)model1) != null) {
                    ((DemoUIModel)model1).addPropertyChangeListener("f1", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model1 != null) {
                    cit0O1.setSelected(((DemoUIModel)model1).isF0() || ((DemoUIModel)model1).isF1());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (((DemoUIModel)model1) != null) {
                    ((DemoUIModel)model1).removePropertyChangeListener("f0", this);
                }
                if (((DemoUIModel)model1) != null) {
                    ((DemoUIModel)model1).removePropertyChangeListener("f1", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CIT0_A1_SELECTED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (((DemoUIModel)model1) != null) {
                    ((DemoUIModel)model1).addPropertyChangeListener("f0", this);
                }
                if (((DemoUIModel)model1) != null) {
                    ((DemoUIModel)model1).addPropertyChangeListener("f1", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model1 != null) {
                    cit0A1.setSelected(((DemoUIModel)model1).isF0() && ((DemoUIModel)model1).isF1());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (((DemoUIModel)model1) != null) {
                    ((DemoUIModel)model1).removePropertyChangeListener("f0", this);
                }
                if (((DemoUIModel)model1) != null) {
                    ((DemoUIModel)model1).removePropertyChangeListener("f1", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CIGETT0_SELECTED, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("model1", this);
                if (getModel1() != null) {
                    getModel1().addPropertyChangeListener("f0", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getModel1() != null) {
                    cigett0.setSelected(getModel1().isF0());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("model1", this);
                if (getModel1() != null) {
                    getModel1().removePropertyChangeListener("f0", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CIGETT1_SELECTED, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("model1", this);
                if (getModel1() != null) {
                    getModel1().addPropertyChangeListener("f1", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getModel1() != null) {
                    cigett1.setSelected(getModel1().isF1());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("model1", this);
                if (getModel1() != null) {
                    getModel1().removePropertyChangeListener("f1", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CIGETT0_O1_SELECTED, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("model1", this);
                if (getModel1() != null) {
                    getModel1().addPropertyChangeListener("f0", this);
                }
                if (getModel1() != null) {
                    getModel1().addPropertyChangeListener("f1", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getModel1() != null) {
                    cigett0O1.setSelected(getModel1().isF0() || getModel1().isF1());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("model1", this);
                if (getModel1() != null) {
                    getModel1().removePropertyChangeListener("f0", this);
                }
                if (getModel1() != null) {
                    getModel1().removePropertyChangeListener("f1", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CIGETT0_A1_SELECTED, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("model1", this);
                if (getModel1() != null) {
                    getModel1().addPropertyChangeListener("f0", this);
                }
                if (getModel1() != null) {
                    getModel1().addPropertyChangeListener("f1", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getModel1() != null) {
                    cigett0A1.setSelected(getModel1().isF0() && getModel1().isF1());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("model1", this);
                if (getModel1() != null) {
                    getModel1().removePropertyChangeListener("f0", this);
                }
                if (getModel1() != null) {
                    getModel1().removePropertyChangeListener("f1", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_C_IFILE_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model1 != null) {
                    model1.addPropertyChangeListener("file", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model1 != null && model1.getFile() != null) {
                    SwingUtil.setText(cIfile, model1.getFile().getAbsolutePath());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model1 != null) {
                    model1.removePropertyChangeListener("file", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_C_IGETFILE_TEXT, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("model1", this);
                if (getModel1() != null) {
                    getModel1().addPropertyChangeListener("file", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getModel1() != null && getModel1().getFile() != null) {
                    SwingUtil.setText(cIgetfile, getModel1().getFile().getAbsolutePath());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("model1", this);
                if (getModel1() != null) {
                    getModel1().removePropertyChangeListener("file", this);
                }
            }
        });
    }

}