package jaxx.demo.component.swing;

/*-
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2016 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import jaxx.demo.DemoHelpBroker;
import jaxx.demo.DemoPanel;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.css.DataBinding;
import jaxx.runtime.css.Pseudoclasses;
import jaxx.runtime.swing.VBox;
import jaxx.runtime.swing.help.JAXXHelpUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class JButtonDemo extends DemoPanel implements JAXXHelpUI<DemoHelpBroker> {

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAJ1UO28TQRAeO7GD84AkVl4iSCGEBsEZChBSIshLEYnMQ0SgCBdhfbexN1rfLrd7ySUIxE/gJ0BPg0RHhSioKWgQfwEhClrE7Pp1iR1isOTTafabb76dme/efIeUCuDsNokiJwh9zSrUWVvY2Lhb3KauXqbKDZjUIoDqL5GEZAH6vEZcaThXyJv0XC09tyQqUvjUj2XP5qFX6T1OVZlSreHMwQxXqdx643g2kmFQZ22Iasf66ueP5EvvxeskQCRRXRqvMnVcVvMm3XlIMk/DMFbaITlO/BLKCJhfQr0DJrbEiVJ3SIU+gefQk4e0JAGSaZju/MqWw+ZHUkO/FnKZVsQ94lOu4bxV62HAcescjtpFCc7aYqi18A1YSkuQ1jBQphzzt0jI9SpKHzQqHaPcqSpvQtOS+i7DGiMGE9VYVyukRFdd4ceAMw8XRXRZw9iB1lXx5sjgMg14n2IVySmqE76GbJy8JtkAhxv43i3iu3sWbiJj9lRDyoZxYKcPVMVVcJqr0JxVogCpIMSwhvFC6/bcx6Pq3owf2htDaE9/j2a/vP/2bqW+LL1Ye6QtNLbrOEQZCEkDzUzpU9VNCTXjudtEzhYgoyhHo1gjTLYRtl47RnFYb8iOy6Q7t4gqI0Wq5+uHj6OPP3dBcgV6uSDeCjH4VcjocoBdENyL5M15q6h/9wQ+B/HfpSGzhf2/pNg+til55bpptAhoKRChj4vRXeQhrYO2iIvvqYWAER5hjybb9KghtJj59Cu7/na+3qcE6p44Et7sVeoRpJnPmU+trWqOaWujPqlo6ImmM9p5BdAtPbWNko19MYdT9jnT0pQEojaNQTRceDodshZLFS2Ziltr+lkUGraL9qbmzYFDLpU1q3RQ9lqnZZ2YidpLiNvsHxRc7VhB05btBcR8e1z95KHl6wqoZ0NmQc1c8SPDNOHMbS0UmzKua0WEiood9FuHA8+WRcD2MZfwBc5KfsV+nofnqps4RTR+FfH29EZL5YR5Zjto7ZCRw9xYAQN98P+E3ZpGf+MY7YSDuaZhJ+c8oslUkfkezvmIS04cy2fCm39RZBj+AITdsq8rCAAA";
    private static final Log log = LogFactory.getLog(JButtonDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton fancyButon;
    protected ImageIcon pencil;
    protected JButton simpleButon;
    protected JButtonDemo topDemoPanel = this;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private VBox $VBox0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public void buttonClicked(JButton button) {
        JOptionPane.showMessageDialog(this, button.getText() + " clicked!",
        "onActionPerformed",
        JOptionPane.INFORMATION_MESSAGE);
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public JButtonDemo(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public JButtonDemo(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public JButtonDemo(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public JButtonDemo(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public JButtonDemo() {
        $initialize();
    }

    public JButtonDemo(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public JButtonDemo(boolean param0) {
        super(param0);
        $initialize();
    }

    public JButtonDemo(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__fancyButon(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        buttonClicked((JButton) event.getSource());
    }

    public void doActionPerformed__on__simpleButon(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        buttonClicked((JButton) event.getSource());
    }

    public void doMouseEntered__on__fancyButon(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.applyProperty(JButtonDemo.this, fancyButon, "foreground", new Color(255, 0, 0), Pseudoclasses.wrap(fancyButon.getForeground()), 0);
        if (!(value instanceof DataBinding)) {
            fancyButon.setForeground((Color) value);
        }
        value = Pseudoclasses.applyProperty(JButtonDemo.this, fancyButon, "font-style", "italic", Pseudoclasses.wrap((fancyButon.getFont().getStyle() & Font.ITALIC) != 0 ? "italic" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (fancyButon.getFont() != null) {
            if (((String) value).equals("italic")) {
                fancyButon.setFont(fancyButon.getFont().deriveFont(fancyButon.getFont().getStyle() | Font.ITALIC));
            } else {
                fancyButon.setFont(fancyButon.getFont().deriveFont(fancyButon.getFont().getStyle() & ~Font.ITALIC));
            }
        }
        }
    }

    public void doMouseExited__on__fancyButon(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.removeProperty(JButtonDemo.this, fancyButon, "foreground", new Color(255, 0, 0), Pseudoclasses.wrap(fancyButon.getForeground()), 0);
        if (!(value instanceof DataBinding)) {
            fancyButon.setForeground((Color) value);
        }
        value = Pseudoclasses.removeProperty(JButtonDemo.this, fancyButon, "font-style", "italic", Pseudoclasses.wrap((fancyButon.getFont().getStyle() & Font.ITALIC) != 0 ? "italic" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (fancyButon.getFont() != null) {
            if (((String) value).equals("italic")) {
                fancyButon.setFont(fancyButon.getFont().deriveFont(fancyButon.getFont().getStyle() | Font.ITALIC));
            } else {
                fancyButon.setFont(fancyButon.getFont().deriveFont(fancyButon.getFont().getStyle() & ~Font.ITALIC));
            }
        }
        }
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getFancyButon() {
        return fancyButon;
    }

    public ImageIcon getPencil() {
        return pencil;
    }

    public JButton getSimpleButon() {
        return simpleButon;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(DemoHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected VBox get$VBox0() {
        return $VBox0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToTopDemoPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add($VBox0);
    }

    protected void createFancyButon() {
        $objectMap.put("fancyButon", fancyButon = new JButton());
        
        fancyButon.setName("fancyButon");
        fancyButon.setText(t("Fancy Button"));
        if (fancyButon.getFont() != null) {
            fancyButon.setFont(fancyButon.getFont().deriveFont((float) 18));
        }
        fancyButon.setForeground(new Color(0, 0, 255));
        if (fancyButon.getFont() != null) {
            fancyButon.setFont(new Font("Arial", fancyButon.getFont().getStyle(), fancyButon.getFont().getSize()));
        }
        fancyButon.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__fancyButon"));
        fancyButon.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__fancyButon"));
        fancyButon.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__fancyButon"));
        fancyButon.putClientProperty("help", "ui.component.swing.buttons.JButtonDemo.fancyButon");
    }

    @Override
    protected void createHelpDefaultId() {
        $objectMap.put("helpDefaultId", helpDefaultId = "ui.component.swing.buttons.JButtonDemo");
    }

    protected void createPencil() {
        $objectMap.put("pencil", pencil = new ImageIcon(getClass().getResource("/jaxx/demo/images/pencil_black.gif")));
    }

    protected void createSimpleButon() {
        $objectMap.put("simpleButon", simpleButon = new JButton());
        
        simpleButon.setName("simpleButon");
        simpleButon.setText(t("Simple Button"));
        simpleButon.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__simpleButon"));
        simpleButon.putClientProperty("help", "ui.component.swing.buttons.JButtonDemo.simpleButon");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToTopDemoPanel();
        // inline complete setup of $VBox0
        $VBox0.add(simpleButon);
        $VBox0.add(fancyButon);
        
        // apply 1 property setters
        fancyButon.setIcon(pencil);
        // late initializer
        // help broker setup
        DemoHelpBroker _broker = getBroker();
        registerHelpId(_broker, topDemoPanel, "ui.component.swing.buttons.JButtonDemo");
        registerHelpId(_broker, simpleButon, "ui.component.swing.buttons.JButtonDemo.simpleButon");
        registerHelpId(_broker, fancyButon, "ui.component.swing.buttons.JButtonDemo.fancyButon");
        _broker.prepareUI(this);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("topDemoPanel", topDemoPanel);
        createPencil();
        // inline creation of $VBox0
        $objectMap.put("$VBox0", $VBox0 = new VBox());
        
        $VBox0.setName("$VBox0");
        $VBox0.setHorizontalAlignment(0);
        $VBox0.setVerticalAlignment(0);
        createSimpleButon();
        createFancyButon();
        // inline creation of topDemoPanel
        setName("topDemoPanel");
        topDemoPanel.putClientProperty("help", "ui.component.swing.buttons.JButtonDemo");
        
        $completeSetup();
    }

}