/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.application.swing.table;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import jaxx.runtime.SwingUtil;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.table.TableColumnModelExt;
import org.nuiton.jaxx.application.swing.table.ColumnIdentifier;

public abstract class AbstractApplicationTableModel<R extends Serializable>
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(AbstractApplicationTableModel.class);
    protected List<R> rows;
    protected Set<ColumnIdentifier<?>> noneEditableCols;
    protected final boolean createNewRow;
    protected final boolean createEmptyRowIsEmpty;
    protected final List<ColumnIdentifier<R>> identifiers;

    public abstract R createNewRow();

    protected AbstractApplicationTableModel(TableColumnModelExt columnModel, boolean createNewRow, boolean createEmptyRowIsEmpty) {
        this.identifiers = Lists.newArrayListWithCapacity((int)columnModel.getColumnCount());
        for (TableColumn tc : columnModel.getColumns(true)) {
            this.identifiers.add((ColumnIdentifier)tc.getIdentifier());
        }
        this.createNewRow = createNewRow;
        this.createEmptyRowIsEmpty = createEmptyRowIsEmpty;
    }

    public final List<R> getRows() {
        return this.rows;
    }

    public final void setRows(List<R> data) {
        Preconditions.checkNotNull(data, (Object)"Data list can not be null.");
        this.onBeforeRowsChanged(this.rows);
        this.rows = null;
        if (this.createEmptyRowIsEmpty && data.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Creates a first empty row on tableModel " + this));
            }
            data.add(this.createNewRow());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Set " + data.size() + " row(s) in table model " + this));
        }
        this.rows = data;
        this.onRowsChanged(data);
        this.fireTableDataChanged();
    }

    public boolean isCreateNewRow() {
        return this.createNewRow;
    }

    public boolean isCreateEmptyRowIsEmpty() {
        return this.createEmptyRowIsEmpty;
    }

    public final void addNewRow() {
        R newValue = this.createNewRow();
        this.addNewRow(newValue);
    }

    public final void addNewRow(R newValue) {
        this.addNewRow(this.getRowCount(), newValue);
    }

    public final void addNewRow(int rowIndex, R newValue) {
        Preconditions.checkNotNull(newValue, (Object)"Row can not be null.");
        List<R> data = this.getRows();
        Preconditions.checkNotNull(data, (Object)"Data list can not be null.");
        data.add(rowIndex, newValue);
        this.onRowAdded(rowIndex, newValue);
        this.fireTableRowsInserted(rowIndex, rowIndex);
    }

    public final void fireTableRowsInserted(R newValue) {
        Preconditions.checkNotNull(newValue, (Object)"Row can not be null.");
        int rowIndex = this.getRowIndex(newValue);
        this.fireTableRowsInserted(rowIndex, rowIndex);
    }

    public final int updateRow(R row) {
        Preconditions.checkNotNull(row, (Object)"Row can not be null.");
        List<R> data = this.getRows();
        Preconditions.checkNotNull(data, (Object)"Data list can not be null.");
        int rowIndex = data.indexOf(row);
        this.onRowUpdated(rowIndex, row);
        this.fireTableRowsUpdated(rowIndex, rowIndex);
        return rowIndex;
    }

    public final R removeRow(int rowIndex) {
        SwingUtil.ensureRowIndex((TableModel)this, (int)rowIndex);
        List<R> data = this.getRows();
        Serializable row = (Serializable)data.remove(rowIndex);
        this.onRowRemoved(rowIndex, row);
        this.fireTableRowsDeleted(rowIndex, rowIndex);
        return (R)row;
    }

    protected void onRowsChanged(List<R> newRows) {
    }

    protected void onBeforeRowsChanged(List<R> oldRows) {
    }

    protected void onRowAdded(int rowIndex, R row) {
    }

    protected void onRowUpdated(int rowIndex, R row) {
    }

    protected void onRowRemoved(int rowIndex, R row) {
    }

    public final int getRowIndex(R row) {
        return this.rows == null ? -1 : this.rows.indexOf(row);
    }

    public final R getEntry(int rowIndex) {
        SwingUtil.ensureRowIndex((TableModel)this, (int)rowIndex);
        List<R> data = this.getRows();
        return (R)(data == null ? null : (Serializable)data.get(rowIndex));
    }

    public final void setNoneEditableCols(ColumnIdentifier<?> ... noneEditableCols) {
        this.noneEditableCols = Sets.newHashSet((Object[])noneEditableCols);
    }

    @Override
    public final int getRowCount() {
        return this.rows == null ? 0 : this.rows.size();
    }

    @Override
    public final int getColumnCount() {
        return this.identifiers.size();
    }

    @Override
    public final Object getValueAt(int rowIndex, int columnIndex) {
        R entry = this.getEntry(rowIndex);
        ColumnIdentifier<R> identifier = this.getIdentifier(columnIndex);
        if (log.isDebugEnabled()) {
            log.debug((Object)("columnIndex: " + columnIndex + " :: " + identifier.getPropertyName()));
        }
        return identifier.getValue(entry);
    }

    @Override
    public final void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("setValueAt " + aValue));
        }
        R entry = this.getEntry(rowIndex);
        ColumnIdentifier<R> identifier = this.getIdentifier(columnIndex);
        this.setValueAt(aValue, rowIndex, columnIndex, identifier, entry);
    }

    @Override
    public final boolean isCellEditable(int rowIndex, int columnIndex) {
        ColumnIdentifier<R> identifier = this.getIdentifier(columnIndex);
        return this.isCellEditable(rowIndex, columnIndex, identifier);
    }

    protected void setValueAt(Object aValue, int rowIndex, int columnIndex, ColumnIdentifier<R> propertyName, R entry) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("setValueAt " + aValue));
        }
        propertyName.setValue(entry, aValue);
    }

    protected boolean isCellEditable(int rowIndex, int columnIndex, ColumnIdentifier<R> propertyName) {
        return !this.noneEditableCols.contains(propertyName);
    }

    public final void fireTableCellUpdated(int rowIndex, ColumnIdentifier<R> ... identifiers) {
        for (ColumnIdentifier<R> identifier : identifiers) {
            int columnIndex = this.identifiers.indexOf(identifier);
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }
    }

    public final void fireTableRowUpdatedShell(Set<R> shell) {
        int minRowIndex1 = this.getColumnCount();
        int maxRowIndex1 = 0;
        for (Serializable r : shell) {
            int rowIndex1 = this.getRowIndex(r);
            minRowIndex1 = Math.min(minRowIndex1, rowIndex1);
            maxRowIndex1 = Math.max(maxRowIndex1, rowIndex1);
        }
        this.fireTableRowsUpdated(minRowIndex1, maxRowIndex1);
    }

    protected void collectShell(R row, Set<R> collectedRows) {
        collectedRows.add(row);
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.getIdentifier(columnIndex).getPropertyName();
    }

    protected ColumnIdentifier<R> getIdentifier(int columnIndex) {
        return this.identifiers.get(columnIndex);
    }

    public int getColumnIndex(final String propertyName) {
        return Iterables.indexOf(this.identifiers, (Predicate)new Predicate<ColumnIdentifier<R>>(){

            public boolean apply(ColumnIdentifier<R> input) {
                return ObjectUtils.equals((Object)propertyName, (Object)input.getPropertyName());
            }
        });
    }

    public Pair<Integer, Integer> getCell(R row, String propertyName) {
        int rowIndex = this.getRowIndex(row);
        int columnIndex = this.getColumnIndex(propertyName);
        return Pair.of((Object)rowIndex, (Object)columnIndex);
    }

    public void moveUp(R row) {
        int rowIndex = this.getRowIndex(row);
        if (log.isInfoEnabled()) {
            log.info((Object)("Will move up row of index: " + rowIndex));
        }
        this.rows.remove(rowIndex);
        this.rows.add(rowIndex - 1, row);
        this.fireTableRowsUpdated(rowIndex - 1, rowIndex);
    }

    public void moveDown(R row) {
        int rowIndex = this.getRowIndex(row);
        if (log.isInfoEnabled()) {
            log.info((Object)("Will move down row of index: " + rowIndex));
        }
        this.rows.remove(rowIndex);
        this.rows.add(rowIndex + 1, row);
        this.fireTableRowsUpdated(rowIndex, rowIndex + 1);
    }

    public boolean isFirstRow(R row) {
        int rowIndex = this.getRowIndex(row);
        return rowIndex == 0;
    }

    public boolean isLastRow(R row) {
        int rowIndex = this.getRowIndex(row);
        return rowIndex == this.getRowCount() - 1;
    }
}

