/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.application.bean;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeListenerProxy;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.application.ApplicationTechnicalException;
import org.nuiton.jaxx.application.bean.JavaBeanObject;
import org.nuiton.jaxx.application.bean.RemoveablePropertyChangeListener;

public class JavaBeanObjectUtil {
    private static final Log log = LogFactory.getLog(JavaBeanObjectUtil.class);

    public static void removeAllPropertyChangeListeners(Iterable<? extends JavaBeanObject> beans) {
        for (JavaBeanObject javaBeanObject : beans) {
            JavaBeanObjectUtil.removeAllPropertyChangeListeners(javaBeanObject);
        }
    }

    public static void removeAllPropertyChangeListeners(JavaBeanObject bean) {
        JavaBeanObjectUtil.removePropertyChangeListeners(bean, (Predicate<PropertyChangeListener>)Predicates.alwaysTrue());
    }

    public static void removeAllRemovablePropertyChangeListeners(JavaBeanObject bean) {
        JavaBeanObjectUtil.removePropertyChangeListeners(bean, (Predicate<PropertyChangeListener>)((Predicate)input -> input instanceof RemoveablePropertyChangeListener));
    }

    public static void removePropertyChangeListeners(JavaBeanObject bean, Predicate<PropertyChangeListener> predicate) {
        PropertyChangeListener[] propertyChangeListeners;
        for (PropertyChangeListener listener : propertyChangeListeners = bean.getPropertyChangeListeners()) {
            if (listener instanceof PropertyChangeListenerProxy) {
                PropertyChangeListenerProxy listenerProxy = (PropertyChangeListenerProxy)listener;
                listener = (PropertyChangeListener)listenerProxy.getListener();
            }
            if (!predicate.apply((Object)listener)) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Remove listener: " + listener));
            }
            bean.removePropertyChangeListener(listener);
        }
    }

    public static void setProperty(Object bean, String property, Object value) {
        Preconditions.checkNotNull((Object)bean);
        Preconditions.checkNotNull((Object)property);
        try {
            PropertyUtils.setSimpleProperty((Object)bean, (String)property, (Object)value);
        }
        catch (Exception e) {
            throw new ApplicationTechnicalException(String.format("Could not set property %1s not found on object of type %2s", property, bean.getClass().getName()), e);
        }
    }

    public static Object getProperty(Object bean, String property) {
        Preconditions.checkNotNull((Object)bean);
        Preconditions.checkNotNull((Object)property);
        try {
            return PropertyUtils.getSimpleProperty((Object)bean, (String)property);
        }
        catch (Exception e) {
            throw new ApplicationTechnicalException(String.format("Could not get property %1s on object of type %2s", property, bean.getClass().getName()), e);
        }
    }
}

