/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.i18n.plugin.parser.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import org.apache.maven.plugin.logging.Log;
import org.nuiton.i18n.plugin.parser.AbstractFileParser;
import org.nuiton.i18n.plugin.parser.AbstractI18nParserMojo;
import org.nuiton.i18n.plugin.parser.FileParser;
import org.nuiton.i18n.plugin.parser.I18nSourceEntry;
import org.nuiton.i18n.plugin.parser.ParserException;
import org.nuiton.i18n.plugin.parser.SourceEntry;
import org.nuiton.io.FileUpdater;
import org.nuiton.io.FileUpdaterHelper;
import org.nuiton.io.SortedProperties;
import org.nuiton.processor.filters.I18nFilter;

public class ParserJavaMojo
extends AbstractI18nParserMojo {
    protected String defaultIncludes;
    protected File defaultBasedir;
    protected File cp;

    @Override
    public String[] getDefaultIncludes() {
        return new String[]{this.defaultIncludes};
    }

    @Override
    public String[] getDefaultExcludes() {
        return I18nSourceEntry.EMPTY_STRING_ARRAY;
    }

    @Override
    public File getDefaultBasedir() {
        return this.defaultBasedir;
    }

    @Override
    public FileUpdater newFileUpdater(SourceEntry entry) {
        return FileUpdaterHelper.newJavaFileUpdater((File)entry.getBasedir(), (File)this.cp);
    }

    @Override
    @Deprecated
    protected String getKeyModifierStart() {
        return "_\\(\\s*\"";
    }

    @Override
    @Deprecated
    protected String getKeyModifierEnd() {
        return "\"\\s*(\\)|,|\\+|$)";
    }

    @Override
    protected String getOutGetter() {
        return "java.getter";
    }

    @Override
    public FileParser newFileParser() {
        return new JavaFileParser(this.getLog(), this.encoding, this.oldParser, this.showTouchedFiles);
    }

    protected static class JavaFileParser
    extends AbstractFileParser {
        protected final I18nFilter filter = new I18nFilter();

        public JavaFileParser(Log log, String encoding, SortedProperties oldParser, boolean showTouchedFiles) {
            super(log, encoding, oldParser, showTouchedFiles);
        }

        @Override
        public void parseFile(File file) throws IOException {
            String line = null;
            LineNumberReader lnr = new LineNumberReader(new InputStreamReader(new FileInputStream(file)));
            try {
                while ((line = lnr.readLine()) != null) {
                    this.parseLine(file, line);
                }
            }
            catch (Exception e) {
                if (line != null) {
                    this.getLog().error((CharSequence)("could not parse line (" + lnr.getLineNumber() + ") '" + line + "' of file " + file));
                }
                throw new ParserException(e);
            }
            finally {
                lnr.close();
            }
        }

        @Override
        public void parseLine(File file, String line) throws IOException {
            String[] keys;
            String keysSet = this.filter.parse(line);
            if (keysSet.equals("")) {
                return;
            }
            this.setTouched(true);
            for (String key : keys = keysSet.split("=")) {
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)(file.getName() + " detected key = " + key));
                }
                this.registerKey(key);
            }
        }
    }
}

