
package org.nuiton.guix.tags.swing;

import javax.swing.event.TreeSelectionListener;

/**
 * Handles the tree tag
 *
 * @author kmorin
 */
public class TreeHandler extends ComponentHandler {

    public TreeHandler() {
    }

    @Override
    public Class getClassToGenerate() {
        return javax.swing.JTree.class;
    }

    @Override
    protected void configureProxyEventInfo() {
        super.configureProxyEventInfo();
        addProxyEventInfo("getSelectionCount", TreeSelectionListener.class, "selectionModel");
        addProxyEventInfo("getSelectionPath", TreeSelectionListener.class, "selectionModel");
        addProxyEventInfo("getSelectionPaths", TreeSelectionListener.class, "selectionModel");
        addProxyEventInfo("getSelectionRows", TreeSelectionListener.class, "selectionModel");
        addProxyEventInfo("getSelectionValue", TreeSelectionListener.class, "selectionModel");
    }
}
