/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.plugin.writer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.nuiton.eugene.models.Model;
import org.nuiton.eugene.plugin.writer.BaseModelFileWriter;
import org.nuiton.plugin.PluginHelper;
import org.nuiton.plugin.PluginIOContext;
import org.nuiton.util.FasterCachedResourceResolver;
import org.nuiton.util.FileUtil;
import org.nuiton.util.Resource;
import org.nuiton.util.ResourceResolver;

public abstract class BaseXmiToModelFileWriter
extends BaseModelFileWriter {
    public static final String PROP_RESOLVER = "resolver";
    public static final String PROP_EXTRACTED_PACKAGES = "extractedPackages";
    public static final String PROP_FULL_PACKAGE_PATH = "fullPackagePath";
    protected TransformerFactory transformerFactory;

    protected abstract String getStyleSheet(File var1);

    protected abstract String getExtension();

    public String getInputProtocol() {
        return "xmi";
    }

    public <M extends Model> String getOutputProtocol(Class<M> modelType) {
        return null;
    }

    public boolean acceptInclude(String include) {
        return include.startsWith("xmi:") || include.endsWith(".xmi") || include.endsWith(".uml");
    }

    public String getDefaultIncludes() {
        return "**/*.xmi";
    }

    public String getDefaultInputDirectory() {
        return "src/main/xmi";
    }

    public String getDefaultOutputDirectory() {
        return "models";
    }

    protected TransformerFactory getTransformerFactory() {
        if (this.transformerFactory == null) {
            this.transformerFactory = TransformerFactory.newInstance();
        }
        return this.transformerFactory;
    }

    public String getFullPackagePath() {
        return (String)this.getProperty(PROP_FULL_PACKAGE_PATH, String.class);
    }

    public String getExtractedPackages() {
        return (String)this.getProperty(PROP_EXTRACTED_PACKAGES, String.class);
    }

    public String getResolver() {
        return (String)this.getProperty(PROP_RESOLVER, String.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(File outputDir, File inputDirectory, String includePattern, boolean overwrite) throws IOException {
        long t0 = System.nanoTime();
        try {
            this.getLog().info((CharSequence)("Processing XSL tranformation on " + inputDirectory + " for " + includePattern));
            this.getLog().info((CharSequence)(" with fullPackagePath   : " + this.getFullPackagePath()));
            this.getLog().info((CharSequence)(" with extractedPackages : " + this.getExtractedPackages()));
            this.getLog().info((CharSequence)(" with resolver          : " + this.getResolver()));
            List files = PluginHelper.getIncludedFiles((File)inputDirectory, (String[])new String[]{includePattern}, null);
            this.actionXsl(outputDir, inputDirectory, files, this.getClassLoader(), overwrite);
        }
        finally {
            this.getLog().info((CharSequence)("xsl done in " + PluginHelper.convertTime((long)(System.nanoTime() - t0))));
        }
        this.getLog().info((CharSequence)"Copy resources files");
        PluginIOContext ioContext = new PluginIOContext();
        ioContext.setInput(inputDirectory);
        ioContext.setOutput(outputDir);
        PluginHelper.copyFiles((PluginIOContext)ioContext, null, (String[])new String[]{includePattern}, (boolean)overwrite);
    }

    protected void actionXsl(File outputDir, File dir, List<File> files, ClassLoader fixedClassLoader, boolean overwrite) throws IOException {
        for (File file : files) {
            try {
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("treate file : " + file));
                }
                URIResolver fileResolver = this.getUriResolver(file, fixedClassLoader);
                String styleSheet = this.getStyleSheet(file);
                URL xsl = Resource.getURL((String)styleSheet);
                String extension = "." + FileUtil.extension((File)file, (String[])new String[0]);
                String filename = FileUtil.basename((File)file, (String[])new String[]{extension}).concat(".").concat(this.getExtension());
                String relatifPath = file.getParentFile().getAbsolutePath().substring(dir.getAbsolutePath().length());
                File dstDir = outputDir;
                if (!relatifPath.isEmpty()) {
                    dstDir = new File(dstDir, relatifPath);
                    dstDir.mkdirs();
                }
                File result = new File(dstDir, filename);
                if (!overwrite && file.lastModified() < result.lastModified()) {
                    this.getLog().info((CharSequence)("file up-to-date : " + result));
                    continue;
                }
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("generate " + result));
                }
                Transformer transformer = this.getTransformerFactory().newTransformer(new StreamSource(xsl.openStream()));
                transformer.setParameter(PROP_FULL_PACKAGE_PATH, this.getFullPackagePath());
                transformer.setURIResolver(fileResolver);
                transformer.transform(new StreamSource(file), new StreamResult(new FileOutputStream(result)));
            }
            catch (Exception e) {
                throw new IOException(e.getMessage(), e);
            }
        }
    }

    protected URIResolver getUriResolver(File model, ClassLoader cl) {
        URIResolver result = null;
        try {
            Class<?> clazz = Class.forName(this.getResolver(), true, cl);
            try {
                Constructor<?> withBaseConstructor = clazz.getConstructor(String.class);
                String base = model.getParentFile().getAbsolutePath();
                result = (URIResolver)withBaseConstructor.newInstance(base);
            }
            catch (Exception eee) {
                this.getLog().warn((CharSequence)"Unable to instantiate resolver with String parameter", (Throwable)eee);
            }
            if (result == null) {
                result = (URIResolver)clazz.newInstance();
            }
            if (result instanceof ResourceResolver) {
                ((ResourceResolver)result).setVerbose(this.getConfiguration().isVerbose());
                ((ResourceResolver)result).setCl(cl);
                if (result instanceof FasterCachedResourceResolver) {
                    boolean offline = this.getConfiguration().isOffline();
                    this.getLog().debug((CharSequence)("using offline mode  ? : " + offline));
                    ((FasterCachedResourceResolver)result).setOffline(offline);
                }
            }
        }
        catch (Exception eee) {
            this.getLog().warn((CharSequence)"Unable to instantiate resolver using the default constructor", (Throwable)eee);
        }
        return result;
    }
}

