package org.chorem.vradi.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.BusinessEntityImpl;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyTreeNode;
import org.nuiton.wikitty.entities.WikittyTreeNodeAbstract;
import org.nuiton.wikitty.entities.WikittyTreeNodeImpl;
import org.nuiton.wikitty.entities.WikittyUser;
import org.nuiton.wikitty.entities.WikittyUserAbstract;
import org.nuiton.wikitty.entities.WikittyUserImpl;


public  abstract class ModificationTagAbstract extends BusinessEntityImpl implements ModificationTag {

    public static final List<WikittyExtension> extensions;
    public static final WikittyExtension extensionModificationTag;
    /**
     * getLastModified :
     * @return Date 
     */

    @Override
    public Date getLastModified() {
        Date value = ModificationTagHelper.getLastModified(getWikitty());
        return value;
}

    /**
     * setLastModified :
     * @param lastModified 
     */

    @Override
    public void setLastModified(Date lastModified) {
        Date oldValue = getLastModified();
        ModificationTagHelper.setLastModified(getWikitty(), lastModified);
        getPropertyChangeSupport().firePropertyChange(ModificationTag.FIELD_MODIFICATIONTAG_LASTMODIFIED, oldValue, getLastModified());
}

    /**
     * getLastModifier :
     * @return String 
     */

    @Override
    public String getLastModifier() {
        String value = ModificationTagHelper.getLastModifier(getWikitty());
        return value;
}

    /**
     * setLastModifier :
     * @param lastModifier 
     */

    @Override
    public void setLastModifier(String lastModifier) {
        String oldValue = getLastModifier();
        ModificationTagHelper.setLastModifier(getWikitty(), lastModifier);
        getPropertyChangeSupport().firePropertyChange(ModificationTag.FIELD_MODIFICATIONTAG_LASTMODIFIER, oldValue, getLastModifier());
}

    /**
     * getLastStatusModifier :
     * @return String 
     */

    @Override
    public String getLastStatusModifier() {
        String value = ModificationTagHelper.getLastStatusModifier(getWikitty());
        return value;
}

    /**
     * setLastStatusModifier :
     * @param lastStatusModifier 
     */

    @Override
    public void setLastStatusModifier(String lastStatusModifier) {
        String oldValue = getLastStatusModifier();
        ModificationTagHelper.setLastStatusModifier(getWikitty(), lastStatusModifier);
        getPropertyChangeSupport().firePropertyChange(ModificationTag.FIELD_MODIFICATIONTAG_LASTSTATUSMODIFIER, oldValue, getLastStatusModifier());
}

    /**
     * ModificationTagAbstract :
     */

    public ModificationTagAbstract() {
        super();
}

    /**
     * ModificationTagAbstract :
     * @param wikitty 
     */

    public ModificationTagAbstract(Wikitty wikitty) {
        super(wikitty);
}

    /**
     * ModificationTagAbstract :
     * @param businessEntityImpl 
     */

    public ModificationTagAbstract(BusinessEntityImpl businessEntityImpl) {
        super(businessEntityImpl.getWikitty());
}

    /**
     * getStaticExtensions :
     * @return Collection<WikittyExtension> 
     */

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
}

static {
    
        extensionModificationTag =
                new WikittyExtension(EXT_MODIFICATIONTAG,
                                     "2.0", // version
                                     null,
                                     WikittyUtil.buildFieldMapExtension( // building field map
                                             "Date lastModified unique=\"true\" documentation=\"Last modification date.\"", 
                                             "String lastModifier unique=\"true\" documentation=\"Last modification user name.\"", 
                                             "String lastStatusModifier unique=\"true\" documentation=\"TODO document me !\""));

        // init extensions
        List<WikittyExtension> exts = new ArrayList<WikittyExtension>();

        exts.add(extensionModificationTag);
        extensions = Collections.unmodifiableList(exts);

    }
    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        return getWikitty().toString();
}


} //ModificationTagAbstract
