/* *##% Pollen
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>. ##%*/

package org.chorem.pollen.votecounting.dto;

/**
 * Classe DTO représentant un choix et les valeurs du vote correspondant.
 *
 * @version $Id: ChoiceDTO.java 2615 2009-07-01 13:47:45Z nrannou $
 */
public class ChoiceDTO {

    private String idChoice;

    private double value;

    private double percentage;

    private int nbVotes;

    private boolean result;

    public ChoiceDTO() {
    }

    public ChoiceDTO(String idChoice, double value, double percentage,
            int nbVotes) {
        this.idChoice = idChoice;
        this.value = value;
        this.percentage = percentage;
        this.nbVotes = nbVotes;
    }

    public String getIdChoice() {
        return idChoice;
    }

    public void setIdChoice(String idChoice) {
        this.idChoice = idChoice;
    }

    public double getValue() {
        return value;
    }

    public void setValue(double value) {
        this.value = value;
    }

    public double getPercentage() {
        return percentage;
    }

    public void setPercentage(double percentage) {
        this.percentage = percentage;
    }

    public int getNbVotes() {
        return nbVotes;
    }

    public void setNbVotes(int nbVotes) {
        this.nbVotes = nbVotes;
    }

    public boolean isResult() {
        return result;
    }

    public void setResult(boolean result) {
        this.result = result;
    }

}