/*
 * #%L
 * Pollen :: VoteCounting strategy :: Number
 * $Id: NumberStrategy.java 3593 2012-08-12 11:01:15Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.4.5/pollen-votecounting-strategy-number/src/main/java/org/chorem/pollen/votecounting/strategy/NumberStrategy.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.votecounting.strategy;

import org.chorem.pollen.votecounting.model.ChoiceScore;
import org.chorem.pollen.votecounting.model.ChoiceToVoteRenderType;
import org.chorem.pollen.votecounting.model.VoteCountingResult;
import org.chorem.pollen.votecounting.model.VoteForChoice;
import org.chorem.pollen.votecounting.model.Voter;

import java.util.Locale;
import java.util.Map;
import java.util.Set;

import static org.nuiton.i18n.I18n.n_;

/**
 * Number strategy.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.4.5
 */
public class NumberStrategy extends AbstractVoteCountingStrategy {

    public static final int ID = 3;

    @Override
    public int getId() {
        return ID;
    }

    @Override
    public String getI18nName() {
        return n_("pollen.voteCountingType.number");
    }

    @Override
    public String getI18nHelp() {
        return n_("pollen.voteCountingType.number.help");
    }

    @Override
    public VoteCountingResult votecount(Set<Voter> voters) {

        // get empty result by choice
        Map<String, ChoiceScore> resultByChoice = votersToResult(voters);

        for (Voter voter : voters) {
            // add this voter votes to result
            addVoterChoices(voter, resultByChoice);
        }
        // transform map of result to list of them (and sort them)
        VoteCountingResult result = resultToList(resultByChoice);
        return result;
    }

    @Override
    public String getDisplayVoteValue(Integer voteValue) {
        return voteValue == null ? "" : String.valueOf(voteValue);
    }

    @Override
    public boolean isChoiceInVote(Integer voteValue) {
        return voteValue != null && voteValue >= 0;
    }

    @Override
    public boolean isVoteValueNull(Integer voteValue) {
        return voteValue == null || voteValue == 0;
    }

    @Override
    public ChoiceToVoteRenderType getVoteValueEditorType() {
        return ChoiceToVoteRenderType.TEXTFIELD;
    }

    @Override
    public boolean isDisplayResultsByChoice() {
        return true;
    }

    @Override
    public boolean isVoteValueValid(Integer voteValue) {
        // no validation on not null vote value
        return true;
    }

    @Override
    public boolean isTotalVoteValueValid(int totalValues) {
        // no validation on total value
        return true;
    }

    @Override
    public String getTotalVoteValueNotValidMessage(Locale locale) {
        // no validation on total values, so no message
        return null;
    }

    @Override
    public String getVoteValueNotValidMessage(Locale locale) {
        // no validation on not null vote value, so no message
        return null;
    }

    public void addVoterChoices(Voter voter,
                                Map<String, ChoiceScore> resultByChoice) {

        double voterWeight = voter.getWeight();

        for (VoteForChoice voteForChoice : voter.getVoteForChoices()) {
            Double voteValue = voteForChoice.getVoteValue();
            if (voteValue != null) {

                // get score for choice
                String choiceId = voteForChoice.getChoiceId();
                ChoiceScore choiceScore = resultByChoice.get(choiceId);

                // compute score to add
                double scoreToAdd = voteValue * voterWeight;

                // add to score this weighted vote
                choiceScore.addScoreValue(scoreToAdd);
            }
        }
    }
}
