/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.votecounting.model;

import com.google.common.collect.Sets;
import java.util.Set;
import org.chorem.pollen.votecounting.model.VoteCountingResult;
import org.chorem.pollen.votecounting.model.VoteForChoice;
import org.chorem.pollen.votecounting.model.Voter;

public class GroupOfVoter
implements Voter {
    private String voterId;
    private double weight;
    private Set<VoteForChoice> voteForChoices;
    private Set<Voter> voters;
    private VoteCountingResult result;

    public static GroupOfVoter newVoter(String voterId, double weight, Set<VoteForChoice> voteForChoices, Set<Voter> voters) {
        GroupOfVoter result = new GroupOfVoter();
        result.setVoterId(voterId);
        result.setWeight(weight);
        if (voters != null) {
            for (VoteForChoice voteForChoice : voteForChoices) {
                result.addVoteForChoice(voteForChoice);
            }
        }
        result.setVoters(voters);
        return result;
    }

    @Override
    public String getVoterId() {
        return this.voterId;
    }

    @Override
    public double getWeight() {
        return this.weight;
    }

    @Override
    public Set<VoteForChoice> getVoteForChoices() {
        if (this.voteForChoices == null) {
            this.voteForChoices = Sets.newHashSet();
        }
        return this.voteForChoices;
    }

    public Set<Voter> getVoters() {
        return this.voters;
    }

    public VoteCountingResult getResult() {
        return this.result;
    }

    @Override
    public void setVoterId(String voterId) {
        this.voterId = voterId;
    }

    @Override
    public void setWeight(double weight) {
        this.weight = weight;
    }

    @Override
    public void addVoteForChoice(VoteForChoice voteForChoice) {
        this.getVoteForChoices().add(voteForChoice);
    }

    public void setVoters(Set<Voter> voters) {
        this.voters = voters;
    }

    public void setResult(VoteCountingResult result) {
        this.result = result;
    }
}

