/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.votecounting.model;

import java.math.BigDecimal;
import org.chorem.pollen.votecounting.model.ChoiceIdAble;

public class ChoiceScore
implements ChoiceIdAble,
Comparable<ChoiceScore> {
    private String choiceId;
    private BigDecimal scoreValue;

    public static ChoiceScore newScore(String choiceId, BigDecimal scoreValue) {
        ChoiceScore choiceScore = new ChoiceScore();
        choiceScore.setChoiceId(choiceId);
        choiceScore.setScoreValue(scoreValue);
        return choiceScore;
    }

    @Override
    public String getChoiceId() {
        return this.choiceId;
    }

    public BigDecimal getScoreValue() {
        return this.scoreValue;
    }

    public void setChoiceId(String choiceId) {
        this.choiceId = choiceId;
    }

    public void addScoreValue(double scoreToAdd) {
        BigDecimal newScoreValue = this.scoreValue == null ? BigDecimal.valueOf(scoreToAdd) : this.scoreValue.add(BigDecimal.valueOf(scoreToAdd));
        this.setScoreValue(newScoreValue);
    }

    public void setScoreValue(BigDecimal scoreValue) {
        this.scoreValue = scoreValue;
    }

    @Override
    public int compareTo(ChoiceScore o) {
        int i1 = this.scoreValue == null ? -1 : this.scoreValue.intValue();
        int i2 = o.scoreValue == null ? -1 : o.scoreValue.intValue();
        return i1 - i2;
    }
}

