/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.ui.actions.admin;

import com.google.common.base.Preconditions;
import org.apache.commons.lang3.StringUtils;
import org.chorem.pollen.business.persistence.UserAccount;
import org.chorem.pollen.services.exceptions.UserEmailAlreadyUsedException;
import org.chorem.pollen.services.exceptions.UserInvalidPasswordException;
import org.chorem.pollen.services.exceptions.UserLoginAlreadyUsedException;
import org.chorem.pollen.ui.actions.PollenActionSupport;
import org.nuiton.util.StringUtil;

public class ManageUsers
extends PollenActionSupport {
    private static final long serialVersionUID = 1L;
    protected String action;
    protected UserAccount user;

    public UserAccount getUser() {
        if (this.user == null) {
            this.user = this.getUserService().getNewUser();
        }
        return this.user;
    }

    public UserAccount getCreateUser() {
        return this.getUser();
    }

    public UserAccount getEditUser() {
        return this.getUser();
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public void validate() {
        if ("create".equals(this.action)) {
            UserAccount account = this.getCreateUser();
            if (StringUtils.isBlank((CharSequence)account.getLogin())) {
                this.addFieldError("createUser.login", this._("pollen.error.login.required", new Object[0]));
            }
            if (StringUtils.isBlank((CharSequence)account.getEmail())) {
                this.addFieldError("createUser.email", this._("pollen.error.email.required", new Object[0]));
            } else if (!StringUtil.isEmail((String)account.getEmail())) {
                this.addFieldError("createUser.email", this._("pollen.error.email.invalid", new Object[0]));
            }
        } else if ("edit".equals(this.action)) {
            UserAccount account = this.getEditUser();
            if (StringUtils.isBlank((CharSequence)account.getLogin())) {
                this.addFieldError("editUser.login", this._("pollen.error.pollAccount.votingId.required", new Object[0]));
            }
            if (StringUtils.isBlank((CharSequence)account.getEmail())) {
                this.addFieldError("editUser.email", this._("pollen.error.email.required", new Object[0]));
            } else if (!StringUtil.isEmail((String)account.getEmail())) {
                this.addFieldError("editUser.email", this._("pollen.error.email.invalid", new Object[0]));
            }
        }
    }

    public String create() throws Exception {
        Preconditions.checkNotNull((Object)this.user);
        String result = "input";
        try {
            this.getUserService().createUser(this.user, true);
            this.addFlashMessage(this._("pollen.information.user.created", new Object[]{this.user.getDisplayName()}));
            this.user = null;
            this.action = null;
            result = "success";
        }
        catch (UserLoginAlreadyUsedException e) {
            this.addFieldError("createUser.login", this._("pollen.error.user.login.already.used", new Object[0]));
        }
        catch (UserEmailAlreadyUsedException e) {
            this.addFieldError("createUser.email", this._("pollen.error.user.email.already.used", new Object[0]));
        }
        return result;
    }

    public String edit() throws Exception {
        Preconditions.checkNotNull((Object)this.user);
        String result = "input";
        try {
            this.getUserService().updateUser(this.user, null, true);
            this.addFlashMessage(this._("pollen.information.user.updated", new Object[]{this.user.getDisplayName()}));
            this.user = null;
            this.action = null;
            result = "success";
        }
        catch (UserEmailAlreadyUsedException e) {
            this.addFieldError("editUser.email", this._("pollen.error.user.email.already.used", new Object[0]));
        }
        catch (UserInvalidPasswordException e) {
            this.addFieldError("editUser.password", this._("pollen.error.user.invalid.password", new Object[0]));
        }
        return result;
    }

    public boolean isExists() {
        return StringUtils.isNotBlank((CharSequence)this.user.getTopiaId());
    }
}

