/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.business.converters;

import org.chorem.pollen.business.converters.DataConverter;
import org.chorem.pollen.business.converters.EnumController;
import org.chorem.pollen.business.dto.ChoiceDTO;
import org.chorem.pollen.business.dto.PollDTO;
import org.chorem.pollen.business.persistence.Choice;
import org.chorem.pollen.business.persistence.Comment;
import org.chorem.pollen.business.persistence.PersonToList;
import org.chorem.pollen.business.persistence.Poll;
import org.chorem.pollen.business.persistence.PollAccount;
import org.chorem.pollen.business.persistence.Vote;
import org.chorem.pollen.business.persistence.VoteToChoice;
import org.chorem.pollen.business.persistence.VotingList;
import org.chorem.pollen.business.services.ServicePollAccountImpl;
import org.chorem.pollen.votecounting.dto.CommentDTO;
import org.chorem.pollen.votecounting.dto.PollChoiceDTO;
import org.chorem.pollen.votecounting.dto.VoteToChoiceDTO;
import org.chorem.pollen.votecounting.dto.VotingGroupDTO;
import org.chorem.pollen.votecounting.dto.VotingPersonDTO;

public class DataVoteCountingConverter
extends DataConverter {
    public static org.chorem.pollen.votecounting.dto.PollDTO createPollDTOForVoteCounting(Poll ePoll) {
        org.chorem.pollen.votecounting.dto.PollDTO pollDTO = new org.chorem.pollen.votecounting.dto.PollDTO(ePoll.getPollId());
        pollDTO.setTitle(ePoll.getTitle());
        pollDTO.setDescription(ePoll.getDescription());
        pollDTO.setBeginChoiceDate(ePoll.getBeginChoiceDate());
        pollDTO.setBeginDate(ePoll.getBeginDate());
        pollDTO.setEndDate(ePoll.getEndDate());
        pollDTO.setAnonymous(ePoll.getAnonymous().booleanValue());
        pollDTO.setAnonymousVoteAllowed(ePoll.getAnonymousVoteAllowed().booleanValue());
        pollDTO.setPublicResults(ePoll.getPublicResults().booleanValue());
        pollDTO.setContinuousResults(ePoll.getContinuousResults().booleanValue());
        pollDTO.setChoiceAddAllowed(ePoll.getChoiceAddAllowed().booleanValue());
        pollDTO.setClosed(ePoll.getClosed().booleanValue());
        pollDTO.setCreatorId(ePoll.getCreator().getVotingId());
        pollDTO.setCreatorEmail(ePoll.getCreator().getEmail());
        pollDTO.setMaxChoiceNb(ePoll.getMaxChoiceNb().intValue());
        pollDTO.setPollType(EnumController.getPollType(ePoll));
        pollDTO.setChoiceType(EnumController.getChoiceType(ePoll));
        pollDTO.setVoteCounting(EnumController.getVoteCountingType(ePoll));
        for (Comment comment : ePoll.getComment()) {
            pollDTO.getComments().add(DataVoteCountingConverter.createPollCommentDTO(comment));
        }
        for (Choice choice : ePoll.getChoice()) {
            pollDTO.getChoices().add(DataVoteCountingConverter.createPollChoiceDTO(choice));
        }
        if (ePoll.getVotingList() != null && !ePoll.getVotingList().isEmpty()) {
            for (VotingList list : ePoll.getVotingList()) {
                pollDTO.getVotingGroups().add(DataVoteCountingConverter.createVotingGroupDTO(list));
            }
        } else {
            VotingGroupDTO group = new VotingGroupDTO("unique", 1.0);
            group.setName("unique");
            for (Vote vote : ePoll.getVote()) {
                group.getVotingPersons().add(DataVoteCountingConverter.createVotingPersonDTO(vote));
            }
            pollDTO.getVotingGroups().add(group);
        }
        return pollDTO;
    }

    private static CommentDTO createPollCommentDTO(Comment comment) {
        CommentDTO commentDTO = new CommentDTO(comment.getPollAccount().getVotingId(), comment.getText());
        return commentDTO;
    }

    private static PollChoiceDTO createPollChoiceDTO(Choice choice) {
        PollChoiceDTO choiceDTO = new PollChoiceDTO(choice.getTopiaId());
        choiceDTO.setName(choice.getName());
        choiceDTO.setDescription(choice.getDescription());
        return choiceDTO;
    }

    private static VotingGroupDTO createVotingGroupDTO(VotingList list) {
        VotingGroupDTO group = new VotingGroupDTO(list.getTopiaId(), list.getWeight().doubleValue());
        group.setName(list.getName());
        for (PersonToList pToList : list.getPollAccountPersonToList()) {
            Vote vote = DataVoteCountingConverter.getPollVoteByPollAccount(list.getPoll(), pToList.getPollAccount());
            if (vote == null) continue;
            group.getVotingPersons().add(DataVoteCountingConverter.createVotingPersonDTO(vote));
        }
        return group;
    }

    private static VotingPersonDTO createVotingPersonDTO(Vote vote) {
        VotingPersonDTO votingPerson = new VotingPersonDTO(vote.getPollAccount().getVotingId(), vote.getWeight().doubleValue());
        votingPerson.setEmail(vote.getPollAccount().getEmail());
        for (VoteToChoice vToChoice : vote.getChoiceVoteToChoice()) {
            if (vToChoice == null || vToChoice.getChoice() == null) continue;
            votingPerson.getChoices().add(DataVoteCountingConverter.createVoteToChoiceDTO(vToChoice));
        }
        return votingPerson;
    }

    private static VoteToChoiceDTO createVoteToChoiceDTO(VoteToChoice vToChoice) {
        String topiaId = vToChoice.getChoice().getTopiaId();
        VoteToChoiceDTO vote = new VoteToChoiceDTO(topiaId, (double)vToChoice.getVoteValue().intValue());
        return vote;
    }

    private static Vote getPollVoteByPollAccount(Poll poll, PollAccount account) {
        for (Vote vote : poll.getVote()) {
            if (!account.getTopiaId().equals(vote.getPollAccount().getTopiaId())) continue;
            return vote;
        }
        return null;
    }

    public static PollDTO createPollDTO(org.chorem.pollen.votecounting.dto.PollDTO pollDTO) {
        PollDTO bPollDTO = new PollDTO(pollDTO.getPollId());
        bPollDTO.setTitle(pollDTO.getTitle());
        bPollDTO.setDescription(pollDTO.getDescription());
        bPollDTO.setBeginChoiceDate(pollDTO.getBeginChoiceDate());
        bPollDTO.setBeginDate(pollDTO.getBeginDate());
        bPollDTO.setEndDate(pollDTO.getEndDate());
        bPollDTO.setAnonymous(pollDTO.isAnonymous());
        bPollDTO.setAnonymousVoteAllowed(pollDTO.isAnonymousVoteAllowed());
        bPollDTO.setPublicResults(pollDTO.isPublicResults());
        bPollDTO.setContinuousResults(pollDTO.isContinuousResults());
        bPollDTO.setChoiceAddAllowed(pollDTO.isChoiceAddAllowed());
        bPollDTO.setClosed(pollDTO.isClosed());
        bPollDTO.setCreatorId(pollDTO.getCreatorId());
        bPollDTO.setCreatorEmail(pollDTO.getCreatorEmail());
        bPollDTO.setMaxChoiceNb(pollDTO.getMaxChoiceNb());
        bPollDTO.setPollType(pollDTO.getPollType());
        bPollDTO.setChoiceType(pollDTO.getChoiceType());
        bPollDTO.setVoteCounting(pollDTO.getVoteCounting());
        for (CommentDTO comment : pollDTO.getComments()) {
            bPollDTO.getCommentDTOs().add(DataVoteCountingConverter.createPollCommentDTO(comment));
        }
        for (PollChoiceDTO choice : pollDTO.getChoices()) {
            bPollDTO.getChoiceDTOs().add(DataVoteCountingConverter.createPollChoiceDTO(choice));
        }
        return bPollDTO;
    }

    private static org.chorem.pollen.business.dto.CommentDTO createPollCommentDTO(CommentDTO commentDTO) {
        ServicePollAccountImpl spa = new ServicePollAccountImpl();
        PollAccount account = spa.createPollAccount(commentDTO.getVotingID(), null, null);
        org.chorem.pollen.business.dto.CommentDTO bCommentDTO = new org.chorem.pollen.business.dto.CommentDTO(commentDTO.getText(), null, account.getTopiaId());
        return bCommentDTO;
    }

    private static ChoiceDTO createPollChoiceDTO(PollChoiceDTO pollChoiceDTO) {
        ChoiceDTO bChoiceDTO = new ChoiceDTO();
        bChoiceDTO.setName(pollChoiceDTO.getName());
        bChoiceDTO.setDescription(pollChoiceDTO.getDescription());
        return bChoiceDTO;
    }
}

