/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.business.converters;

import org.chorem.pollen.business.converters.DataConverter;
import org.chorem.pollen.business.converters.EnumController;
import org.chorem.pollen.business.persistence.Choice;
import org.chorem.pollen.business.persistence.PersonToList;
import org.chorem.pollen.business.persistence.Poll;
import org.chorem.pollen.business.persistence.PollAccount;
import org.chorem.pollen.business.persistence.Vote;
import org.chorem.pollen.business.persistence.VoteToChoice;
import org.chorem.pollen.business.persistence.VotingList;
import org.chorem.pollen.votecounting.dto.PollChoiceDTO;
import org.chorem.pollen.votecounting.dto.PollDTO;
import org.chorem.pollen.votecounting.dto.VoteToChoiceDTO;
import org.chorem.pollen.votecounting.dto.VotingGroupDTO;
import org.chorem.pollen.votecounting.dto.VotingPersonDTO;

public class EntityToVoteCountingDTO
extends DataConverter {
    public static PollDTO createPollDTOForVoteCounting(Poll entity) {
        PollDTO dto = new PollDTO(entity.getPollId(), entity.getMaxChoiceNb(), EnumController.getPollType(entity), EnumController.getVoteCountingType(entity));
        for (Choice choice : entity.getChoice()) {
            dto.getChoices().add(EntityToVoteCountingDTO.createPollChoiceDTO(choice));
        }
        if (entity.getVotingList() != null && !entity.getVotingList().isEmpty()) {
            for (VotingList list : entity.getVotingList()) {
                dto.getVotingGroups().add(EntityToVoteCountingDTO.createVotingGroupDTO(list));
            }
        } else {
            VotingGroupDTO group = new VotingGroupDTO("unique", 1.0);
            for (Vote vote : entity.getVote()) {
                group.getVotingPersons().add(EntityToVoteCountingDTO.createVotingPersonDTO(vote));
            }
            dto.getVotingGroups().add(group);
        }
        return dto;
    }

    private static PollChoiceDTO createPollChoiceDTO(Choice choice) {
        PollChoiceDTO choiceDTO = new PollChoiceDTO(EntityToVoteCountingDTO.getChoiceId(choice));
        return choiceDTO;
    }

    private static VotingGroupDTO createVotingGroupDTO(VotingList list) {
        VotingGroupDTO group = new VotingGroupDTO(list.getTopiaId(), list.getWeight());
        for (PersonToList pToList : list.getPollAccountPersonToList()) {
            Vote vote = EntityToVoteCountingDTO.getPollVoteByPollAccount(list.getPoll(), pToList.getPollAccount());
            if (vote == null) continue;
            group.getVotingPersons().add(EntityToVoteCountingDTO.createVotingPersonDTO(vote));
        }
        return group;
    }

    private static VotingPersonDTO createVotingPersonDTO(Vote vote) {
        VotingPersonDTO votingPerson = new VotingPersonDTO(vote.getPollAccount().getVotingId(), vote.getWeight());
        for (VoteToChoice vToChoice : vote.getChoiceVoteToChoice()) {
            votingPerson.getChoices().add(EntityToVoteCountingDTO.createVoteToChoiceDTO(vToChoice));
        }
        return votingPerson;
    }

    private static VoteToChoiceDTO createVoteToChoiceDTO(VoteToChoice vToChoice) {
        VoteToChoiceDTO vote = new VoteToChoiceDTO(EntityToVoteCountingDTO.getChoiceId(vToChoice.getChoice()), (double)vToChoice.getVoteValue());
        return vote;
    }

    private static String getChoiceId(Choice choice) {
        return choice.getTopiaId();
    }

    private static Vote getPollVoteByPollAccount(Poll poll, PollAccount account) {
        for (Vote vote : poll.getVote()) {
            if (!account.getTopiaId().equals(vote.getPollAccount().getTopiaId())) continue;
            return vote;
        }
        return null;
    }
}

