/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.business;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.pollen.business.ServicePreventRule;
import org.chorem.pollen.business.converters.DataPreventRuleConverter;
import org.chorem.pollen.business.dto.PreventRuleDTO;
import org.chorem.pollen.business.persistence.PollenModelDAOHelper;
import org.chorem.pollen.business.persistence.PreventRule;
import org.chorem.pollen.business.persistence.PreventRuleDAO;
import org.chorem.pollen.business.utils.ContextUtil;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;

public class ServicePreventRuleImpl
implements ServicePreventRule {
    private TopiaContext rootContext = ContextUtil.getInstance().getContext();
    private TopiaContext transaction = null;
    private PreventRuleDAO preventRuleDAO = null;
    private DataPreventRuleConverter converter = new DataPreventRuleConverter();
    private static final Log log = LogFactory.getLog(ServicePreventRuleImpl.class);

    @Override
    public String createPreventRule(PreventRuleDTO preventRule) {
        String topiaId = "";
        try {
            this.transaction = this.rootContext.beginTransaction();
            this.preventRuleDAO = PollenModelDAOHelper.getPreventRuleDAO(this.transaction);
            PreventRule preventRuleEntity = (PreventRule)this.preventRuleDAO.create(new Object[0]);
            this.converter.setTransaction(this.transaction);
            this.converter.populatePreventRuleEntity(preventRule, preventRuleEntity);
            topiaId = preventRuleEntity.getTopiaId();
            this.transaction.commitTransaction();
            this.transaction.closeContext();
            if (log.isInfoEnabled()) {
                log.info((Object)("Entity created: " + topiaId));
            }
            return topiaId;
        }
        catch (TopiaException e) {
            this.doCatch(e);
            return "";
        }
    }

    @Override
    public List<PreventRule> createPreventRules(List<PreventRuleDTO> preventRules, String pollId, TopiaContext trans) {
        if (preventRules.isEmpty() || pollId.length() == 0) {
            return null;
        }
        ArrayList<PreventRule> result = null;
        try {
            this.transaction = trans;
            this.preventRuleDAO = PollenModelDAOHelper.getPreventRuleDAO(trans);
            this.converter.setTransaction(trans);
            result = new ArrayList<PreventRule>();
            for (PreventRuleDTO preventRule : preventRules) {
                PreventRule preventRuleEntity = (PreventRule)this.preventRuleDAO.create(new Object[0]);
                preventRule.setId(preventRuleEntity.getTopiaId());
                preventRule.setPollId(pollId);
                this.converter.populatePreventRuleEntity(preventRule, preventRuleEntity);
                result.add(preventRuleEntity);
            }
            return result;
        }
        catch (TopiaException e) {
            this.doCatch(e);
            return null;
        }
    }

    @Override
    public boolean updatePreventRule(PreventRuleDTO preventRuleDTO) {
        boolean resu = false;
        try {
            this.transaction = this.rootContext.beginTransaction();
            this.preventRuleDAO = PollenModelDAOHelper.getPreventRuleDAO(this.transaction);
            PreventRule preventRuleEntity = (PreventRule)this.preventRuleDAO.findByTopiaId(preventRuleDTO.getId());
            if (preventRuleEntity != null) {
                this.converter.setTransaction(this.transaction);
                this.converter.populatePreventRuleEntity(preventRuleDTO, preventRuleEntity);
                this.preventRuleDAO.update(preventRuleEntity);
                this.transaction.commitTransaction();
                resu = true;
            }
            this.transaction.closeContext();
            if (log.isInfoEnabled()) {
                log.info((Object)("Entity updated: " + preventRuleDTO.getId()));
            }
            return resu;
        }
        catch (TopiaException e) {
            this.doCatch(e);
            return false;
        }
    }

    @Override
    public boolean deletePreventRule(String preventRuleId) {
        try {
            this.transaction = this.rootContext.beginTransaction();
            this.preventRuleDAO = PollenModelDAOHelper.getPreventRuleDAO(this.transaction);
            PreventRule preventRuleEntity = (PreventRule)this.preventRuleDAO.findByTopiaId(preventRuleId);
            this.preventRuleDAO.delete(preventRuleEntity);
            this.transaction.commitTransaction();
            this.transaction.closeContext();
            if (log.isInfoEnabled()) {
                log.info((Object)("Entity deleted: " + preventRuleId));
            }
            return true;
        }
        catch (TopiaException e) {
            this.doCatch(e);
            return false;
        }
    }

    @Override
    public PreventRuleDTO findPreventRuleById(String preventRuleId) {
        PreventRuleDTO result = null;
        try {
            this.transaction = this.rootContext.beginTransaction();
            this.preventRuleDAO = PollenModelDAOHelper.getPreventRuleDAO(this.transaction);
            PreventRule preventRuleEntity = (PreventRule)this.preventRuleDAO.findByTopiaId(preventRuleId);
            if (preventRuleEntity != null) {
                this.converter.setTransaction(this.transaction);
                result = this.converter.createPreventRuleDTO(preventRuleEntity);
            }
            this.transaction.commitTransaction();
            this.transaction.closeContext();
            if (log.isInfoEnabled()) {
                log.info((Object)("Entity found: " + (result == null ? "null" : result.getId())));
            }
            return result;
        }
        catch (TopiaException e) {
            this.doCatch(e);
            return null;
        }
    }

    @Override
    public List<PreventRuleDTO> selectPreventRules(Map<String, Object> properties) {
        List<PreventRuleDTO> results = null;
        List preventRuleEntities = null;
        try {
            this.transaction = this.rootContext.beginTransaction();
            this.preventRuleDAO = PollenModelDAOHelper.getPreventRuleDAO(this.transaction);
            if (properties == null) {
                preventRuleEntities = this.preventRuleDAO.findAll();
                if (log.isWarnEnabled()) {
                    log.warn((Object)"Attention : toutes les r\u00e8gles de notification ont \u00e9t\u00e9 s\u00e9lectionn\u00e9es !");
                }
            } else {
                preventRuleEntities = this.preventRuleDAO.findAllByProperties(properties);
            }
            this.converter.setTransaction(this.transaction);
            results = this.converter.createPreventRuleDTOs(preventRuleEntities);
            this.transaction.commitTransaction();
            this.transaction.closeContext();
            if (log.isInfoEnabled()) {
                log.info((Object)("Entities found: " + (results == null ? "null" : Integer.valueOf(results.size()))));
            }
            return results;
        }
        catch (TopiaException e) {
            this.doCatch(e);
            return null;
        }
    }

    private void doCatch(TopiaException e) {
        try {
            if (this.transaction != null) {
                this.transaction.rollbackTransaction();
                this.transaction.closeContext();
            }
        }
        catch (TopiaException ex) {
            ex.printStackTrace();
        }
        e.printStackTrace();
    }
}

