/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.business;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.pollen.business.ServiceChoiceImpl;
import org.chorem.pollen.business.ServiceCommentImpl;
import org.chorem.pollen.business.ServiceListImpl;
import org.chorem.pollen.business.ServicePoll;
import org.chorem.pollen.business.ServicePollAccountImpl;
import org.chorem.pollen.business.ServicePreventRuleImpl;
import org.chorem.pollen.business.converters.DataPollConverter;
import org.chorem.pollen.business.dto.ChoiceDTO;
import org.chorem.pollen.business.dto.PollDTO;
import org.chorem.pollen.business.dto.PreventRuleDTO;
import org.chorem.pollen.business.persistence.Poll;
import org.chorem.pollen.business.persistence.PollAccount;
import org.chorem.pollen.business.persistence.PollDAO;
import org.chorem.pollen.business.persistence.PollenModelDAOHelper;
import org.chorem.pollen.business.persistence.PreventRule;
import org.chorem.pollen.business.persistence.UserAccount;
import org.chorem.pollen.business.persistence.UserAccountDAO;
import org.chorem.pollen.business.persistence.Vote;
import org.chorem.pollen.business.persistence.VoteDAO;
import org.chorem.pollen.business.utils.ContextUtil;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;

public class ServicePollImpl
implements ServicePoll {
    private TopiaContext rootContext = ContextUtil.getInstance().getContext();
    private TopiaContext transaction = null;
    private PollDAO pollDAO = null;
    private DataPollConverter converter = new DataPollConverter();
    private static final Log log = LogFactory.getLog(ServicePollImpl.class);

    @Override
    public String createPoll(PollDTO pollDTO) {
        String topiaId = "";
        try {
            this.transaction = this.rootContext.beginTransaction();
            this.pollDAO = PollenModelDAOHelper.getPollDAO(this.transaction);
            Poll pollEntity = (Poll)this.pollDAO.create(new Object[0]);
            if (log.isDebugEnabled()) {
                log.debug((Object)("service " + pollDTO.getVoteCounting() + " " + pollDTO.getPollType()));
            }
            this.converter.setTransaction(this.transaction);
            this.converter.populatePollEntity(pollDTO, pollEntity);
            ServicePollAccountImpl spa = new ServicePollAccountImpl();
            if (log.isDebugEnabled()) {
                log.debug((Object)("userId : " + pollDTO.getUserId()));
            }
            PollAccount pollAccountEntity = spa.createPollAccount(pollDTO.getCreatorId(), pollDTO.getCreatorEmail(), pollDTO.getUserId());
            if (log.isDebugEnabled()) {
                log.debug((Object)("pollAccountEntity created: " + pollAccountEntity != null ? 1 : 0));
            }
            pollEntity.setCreator(pollAccountEntity);
            topiaId = pollEntity.getTopiaId();
            ServiceChoiceImpl sChoice = new ServiceChoiceImpl();
            pollEntity.setChoice(sChoice.createChoices(pollDTO.getChoiceDTOs(), topiaId, this.transaction));
            ServiceCommentImpl sComment = new ServiceCommentImpl();
            pollEntity.setComment(sComment.createComments(pollDTO.getCommentDTOs(), topiaId, this.transaction));
            ServiceListImpl sList = new ServiceListImpl();
            pollEntity.setVotingList(sList.createVotingLists(pollDTO.getVotingListDTOs(), topiaId, this.transaction));
            ServicePreventRuleImpl sPreventRule = new ServicePreventRuleImpl();
            pollEntity.setPreventRule(sPreventRule.createPreventRules(pollDTO.getPreventRuleDTOs(), topiaId, this.transaction));
            this.transaction.commitTransaction();
            this.transaction.closeContext();
            if (log.isDebugEnabled()) {
                log.debug((Object)("creator after creation: " + pollEntity.getCreator()));
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("Entity created: " + topiaId));
            }
            return topiaId;
        }
        catch (TopiaException e) {
            this.doCatch(e);
            return "";
        }
    }

    @Override
    public boolean updatePoll(PollDTO pollDTO) {
        try {
            this.transaction = this.rootContext.beginTransaction();
            this.pollDAO = PollenModelDAOHelper.getPollDAO(this.transaction);
            Poll pollEntity = (Poll)this.pollDAO.findByTopiaId(pollDTO.getId());
            this.converter.setTransaction(this.transaction);
            this.converter.populatePollEntity(pollDTO, pollEntity);
            this.pollDAO.update(pollEntity);
            ServiceChoiceImpl sChoice = new ServiceChoiceImpl();
            for (ChoiceDTO choiceDTO : pollDTO.getChoiceDTOs()) {
                boolean updated = sChoice.updateChoice(choiceDTO);
                if (!updated) {
                    choiceDTO.setId(sChoice.createChoice(choiceDTO));
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Choice " + choiceDTO.getName() + " (" + choiceDTO.getId() + ") updated: " + updated));
            }
            ServicePreventRuleImpl sPreventRule = new ServicePreventRuleImpl();
            for (PreventRuleDTO preventRuleDTO : pollDTO.getPreventRuleDTOs()) {
                boolean updated = sPreventRule.updatePreventRule(preventRuleDTO);
                if (!updated) {
                    preventRuleDTO.setId(sPreventRule.createPreventRule(preventRuleDTO));
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("PreventRule (" + preventRuleDTO.getId() + ") updated: " + updated));
            }
            boolean valid = false;
            for (PreventRule currentRule : pollEntity.getPreventRule()) {
                for (PreventRuleDTO preventRuleDTO : pollDTO.getPreventRuleDTOs()) {
                    if (!currentRule.getTopiaId().equals(preventRuleDTO.getId())) continue;
                    valid = true;
                }
                if (valid) continue;
                sPreventRule.deletePreventRule(currentRule.getTopiaId());
            }
            this.transaction.commitTransaction();
            this.transaction.closeContext();
            if (log.isInfoEnabled()) {
                log.info((Object)("Entity updated: " + pollDTO.getId()));
            }
            return true;
        }
        catch (TopiaException e) {
            this.doCatch(e);
            return false;
        }
    }

    @Override
    public boolean deletePoll(String pollId) {
        try {
            this.transaction = this.rootContext.beginTransaction();
            this.pollDAO = PollenModelDAOHelper.getPollDAO(this.transaction);
            Poll pollEntity = (Poll)this.pollDAO.findByTopiaId(pollId);
            this.pollDAO.delete(pollEntity);
            this.transaction.commitTransaction();
            this.transaction.closeContext();
            if (log.isInfoEnabled()) {
                log.info((Object)("Entity deleted: " + pollId));
            }
            return true;
        }
        catch (TopiaException e) {
            this.doCatch(e);
            return false;
        }
    }

    @Override
    public PollDTO findPollById(String pollId) {
        PollDTO result = null;
        try {
            this.transaction = this.rootContext.beginTransaction();
            this.pollDAO = PollenModelDAOHelper.getPollDAO(this.transaction);
            Poll pollEntity = (Poll)this.pollDAO.findByTopiaId(pollId);
            if (pollEntity != null) {
                this.converter.setTransaction(this.transaction);
                result = this.converter.createPollDTO(pollEntity);
            }
            this.transaction.commitTransaction();
            this.transaction.closeContext();
            if (log.isInfoEnabled()) {
                log.info((Object)("Entity found: " + (result == null ? "null" : result.getId())));
            }
            return result;
        }
        catch (TopiaException e) {
            this.doCatch(e);
            return null;
        }
    }

    @Override
    public PollDTO findPollByPollId(String pollId) {
        PollDTO result = null;
        try {
            this.transaction = this.rootContext.beginTransaction();
            this.pollDAO = PollenModelDAOHelper.getPollDAO(this.transaction);
            Object pollEntity = this.pollDAO.findByPollId(pollId);
            if (pollEntity != null) {
                this.converter.setTransaction(this.transaction);
                result = this.converter.createPollDTO((Poll)pollEntity);
            }
            this.transaction.commitTransaction();
            this.transaction.closeContext();
            if (log.isInfoEnabled()) {
                log.info((Object)("Entity found: " + (result == null ? "null" : result.getId())));
            }
            return result;
        }
        catch (TopiaException e) {
            this.doCatch(e);
            return null;
        }
    }

    @Override
    public List<PollDTO> findPollsByName(String pollName) {
        List<PollDTO> results = null;
        List<Poll> pollEntities = null;
        try {
            this.transaction = this.rootContext.beginTransaction();
            this.pollDAO = PollenModelDAOHelper.getPollDAO(this.transaction);
            pollEntities = this.pollDAO.findAllByTitle(pollName);
            this.converter.setTransaction(this.transaction);
            results = this.converter.createPollDTOs(pollEntities);
            this.transaction.commitTransaction();
            this.transaction.closeContext();
            if (log.isInfoEnabled()) {
                log.info((Object)("Entities found: " + (results == null ? "null" : Integer.valueOf(results.size()))));
            }
            return results;
        }
        catch (TopiaException e) {
            this.doCatch(e);
            return null;
        }
    }

    @Override
    public List<PollDTO> findPollsByUser(String userId) {
        List<PollDTO> results = null;
        UserAccountDAO userDAO = null;
        try {
            this.transaction = this.rootContext.beginTransaction();
            userDAO = PollenModelDAOHelper.getUserAccountDAO(this.transaction);
            UserAccount user = (UserAccount)userDAO.findByTopiaId(userId);
            ArrayList<Poll> pollEntities = new ArrayList<Poll>();
            for (PollAccount pollAccount : user.getPollAccount()) {
                pollEntities.addAll(pollAccount.getPollsCreated());
            }
            this.converter.setTransaction(this.transaction);
            results = this.converter.createPollDTOs(pollEntities);
            this.transaction.commitTransaction();
            this.transaction.closeContext();
            if (log.isInfoEnabled()) {
                log.info((Object)("Entities found: " + (results == null ? "null" : Integer.valueOf(results.size()))));
            }
            return results;
        }
        catch (TopiaException e) {
            this.doCatch(e);
            return null;
        }
    }

    @Override
    public List<PollDTO> findRunningPolls(boolean withEndDate) {
        List<PollDTO> results = null;
        List pollEntities = null;
        try {
            this.transaction = this.rootContext.beginTransaction();
            pollEntities = withEndDate ? this.transaction.find("from " + Poll.class.getName() + " as poll where poll.endDate is not null and poll.endDate > current_timestamp()", new Object[0]) : this.transaction.find("from " + Poll.class.getName() + " as poll where poll.endDate is null or poll.endDate > current_timestamp()", new Object[0]);
            this.converter.setTransaction(this.transaction);
            results = this.converter.createPollDTOs(pollEntities);
            this.transaction.commitTransaction();
            this.transaction.closeContext();
            if (log.isInfoEnabled()) {
                log.info((Object)("Entities found: " + (results == null ? "null" : Integer.valueOf(results.size()))));
            }
            return results;
        }
        catch (TopiaException e) {
            this.doCatch(e);
            return null;
        }
    }

    @Override
    public List<PollDTO> selectPolls(Map<String, Object> properties) {
        List<PollDTO> results = null;
        List pollEntities = null;
        try {
            this.transaction = this.rootContext.beginTransaction();
            this.pollDAO = PollenModelDAOHelper.getPollDAO(this.transaction);
            if (properties == null) {
                pollEntities = this.pollDAO.findAll();
                if (log.isWarnEnabled()) {
                    log.warn((Object)"Attention : tous les sondages ont \u00e9t\u00e9 s\u00e9lectionn\u00e9s !");
                }
            } else {
                pollEntities = this.pollDAO.findAllByProperties(properties);
            }
            this.converter.setTransaction(this.transaction);
            results = this.converter.createPollDTOs(pollEntities);
            this.transaction.commitTransaction();
            this.transaction.closeContext();
            if (log.isInfoEnabled()) {
                log.info((Object)("Entities found: " + (results == null ? "null" : Integer.valueOf(results.size()))));
            }
            return results;
        }
        catch (TopiaException e) {
            this.doCatch(e);
            return null;
        }
    }

    @Override
    public String moderate(String pollId) {
        this.deletePoll(pollId);
        return "the poll has been deleted";
    }

    @Override
    public boolean addVoteToPoll(String pollId, String voteId) {
        try {
            this.transaction = this.rootContext.beginTransaction();
            this.pollDAO = PollenModelDAOHelper.getPollDAO(this.transaction);
            Poll pollEntity = (Poll)this.pollDAO.findByTopiaId(pollId);
            VoteDAO voteDAO = PollenModelDAOHelper.getVoteDAO(this.transaction);
            Vote voteEntity = (Vote)voteDAO.findByTopiaId(voteId);
            if (log.isDebugEnabled()) {
                log.debug((Object)(pollEntity + " " + voteEntity));
            }
            pollEntity.addVote(voteEntity);
            pollEntity.update();
            this.transaction.commitTransaction();
            this.transaction.closeContext();
            if (log.isInfoEnabled()) {
                log.info((Object)("Entity updated: " + pollId));
            }
            return true;
        }
        catch (TopiaException e) {
            this.doCatch(e);
            return false;
        }
    }

    private void doCatch(TopiaException e) {
        try {
            if (this.transaction != null) {
                this.transaction.rollbackTransaction();
                this.transaction.closeContext();
            }
        }
        catch (TopiaException ex) {
            ex.printStackTrace();
        }
        e.printStackTrace();
    }
}

