/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.business;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.pollen.business.ServiceList;
import org.chorem.pollen.business.ServicePollAccountImpl;
import org.chorem.pollen.business.converters.DataPersonListConverter;
import org.chorem.pollen.business.converters.DataVotingListConverter;
import org.chorem.pollen.business.dto.PersonListDTO;
import org.chorem.pollen.business.dto.PollAccountDTO;
import org.chorem.pollen.business.dto.VotingListDTO;
import org.chorem.pollen.business.persistence.PersonList;
import org.chorem.pollen.business.persistence.PersonListDAO;
import org.chorem.pollen.business.persistence.PollenModelDAOHelper;
import org.chorem.pollen.business.persistence.UserAccount;
import org.chorem.pollen.business.persistence.UserAccountDAO;
import org.chorem.pollen.business.persistence.VotingList;
import org.chorem.pollen.business.persistence.VotingListDAO;
import org.chorem.pollen.business.utils.ContextUtil;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;

public class ServiceListImpl
implements ServiceList {
    private TopiaContext rootContext = ContextUtil.getInstance().getContext();
    private TopiaContext transaction = null;
    private VotingListDAO votingListDAO = null;
    private PersonListDAO personListDAO = null;
    private DataVotingListConverter votingListConverter = new DataVotingListConverter();
    private DataPersonListConverter personListConverter = new DataPersonListConverter();
    private static final Log log = LogFactory.getLog(ServiceListImpl.class);

    @Override
    public String createVotingList(VotingListDTO votingList) {
        String topiaId = "";
        try {
            this.transaction = this.rootContext.beginTransaction();
            this.votingListDAO = PollenModelDAOHelper.getVotingListDAO(this.transaction);
            VotingList votingListEntity = (VotingList)this.votingListDAO.create(new Object[0]);
            this.votingListConverter.setTransaction(this.transaction);
            this.votingListConverter.populateVotingListEntity(votingList, votingListEntity);
            ServicePollAccountImpl spa = new ServicePollAccountImpl();
            for (PollAccountDTO account : votingList.getPollAccountDTOs()) {
                if (spa.findPollAccountById(account.getId()) != null) continue;
                account.setId(spa.createPollAccount(account));
            }
            this.votingListConverter.populatePersonVotingList(votingList, votingListEntity);
            topiaId = votingListEntity.getTopiaId();
            this.transaction.commitTransaction();
            this.transaction.closeContext();
            if (log.isInfoEnabled()) {
                log.info((Object)("Entity created: " + topiaId));
            }
            return topiaId;
        }
        catch (TopiaException e) {
            this.doCatch(e);
            return "";
        }
    }

    @Override
    public List<VotingList> createVotingLists(List<VotingListDTO> votingLists, String pollId, TopiaContext trans) {
        if (votingLists.isEmpty() || pollId.length() == 0) {
            return null;
        }
        ArrayList<VotingList> result = null;
        try {
            this.transaction = trans;
            this.votingListDAO = PollenModelDAOHelper.getVotingListDAO(this.transaction);
            this.votingListConverter.setTransaction(this.transaction);
            result = new ArrayList<VotingList>();
            for (VotingListDTO votingList : votingLists) {
                VotingList votingListEntity = (VotingList)this.votingListDAO.create(new Object[0]);
                votingList.setPollId(pollId);
                this.votingListConverter.populateVotingListEntity(votingList, votingListEntity);
                ServicePollAccountImpl spa = new ServicePollAccountImpl();
                for (PollAccountDTO account : votingList.getPollAccountDTOs()) {
                    if (spa.findPollAccountById(account.getId()) != null) continue;
                    account.setId(spa.createPollAccount(account));
                }
                this.votingListConverter.populatePersonVotingList(votingList, votingListEntity);
                result.add(votingListEntity);
            }
            return result;
        }
        catch (TopiaException e) {
            this.doCatch(e);
            return null;
        }
    }

    @Override
    public boolean updateVotingList(VotingListDTO votingList) {
        try {
            this.transaction = this.rootContext.beginTransaction();
            this.votingListDAO = PollenModelDAOHelper.getVotingListDAO(this.transaction);
            VotingList entity = (VotingList)this.votingListDAO.findByTopiaId(votingList.getId());
            this.votingListConverter.setTransaction(this.transaction);
            this.votingListConverter.populateVotingListEntity(votingList, entity);
            this.votingListDAO.update(entity);
            this.transaction.commitTransaction();
            this.transaction.closeContext();
            if (log.isInfoEnabled()) {
                log.info((Object)("Entity updated: " + votingList.getId()));
            }
            return true;
        }
        catch (TopiaException e) {
            this.doCatch(e);
            return false;
        }
    }

    @Override
    public boolean deleteVotingList(String votingListId) {
        try {
            this.transaction = this.rootContext.beginTransaction();
            this.votingListDAO = PollenModelDAOHelper.getVotingListDAO(this.transaction);
            VotingList entity = (VotingList)this.votingListDAO.findByTopiaId(votingListId);
            this.votingListDAO.delete(entity);
            this.transaction.commitTransaction();
            this.transaction.closeContext();
            if (log.isInfoEnabled()) {
                log.info((Object)("Entity deleted: " + votingListId));
            }
            return true;
        }
        catch (TopiaException e) {
            this.doCatch(e);
            return false;
        }
    }

    @Override
    public VotingListDTO findVotingListById(String votingListId) {
        VotingListDTO result = null;
        try {
            this.transaction = this.rootContext.beginTransaction();
            this.votingListDAO = PollenModelDAOHelper.getVotingListDAO(this.transaction);
            VotingList votingListEntity = (VotingList)this.votingListDAO.findByTopiaId(votingListId);
            if (votingListEntity != null) {
                this.votingListConverter.setTransaction(this.transaction);
                result = this.votingListConverter.createVotingListDTO(votingListEntity);
            }
            this.transaction.commitTransaction();
            this.transaction.closeContext();
            if (log.isInfoEnabled()) {
                log.info((Object)("Entity found: " + (result == null ? "null" : result.getId())));
            }
            return result;
        }
        catch (TopiaException e) {
            this.doCatch(e);
            return null;
        }
    }

    @Override
    public List<VotingListDTO> findVotingListByName(String name) {
        List<VotingListDTO> results = null;
        List<VotingList> votingListEntities = null;
        try {
            this.transaction = this.rootContext.beginTransaction();
            this.votingListDAO = PollenModelDAOHelper.getVotingListDAO(this.transaction);
            votingListEntities = this.votingListDAO.findAllByName(name);
            this.votingListConverter.setTransaction(this.transaction);
            results = this.votingListConverter.createVotingListDTOs(votingListEntities);
            this.transaction.commitTransaction();
            this.transaction.closeContext();
            if (log.isInfoEnabled()) {
                log.info((Object)("Entities found: " + (results == null ? "null" : Integer.valueOf(results.size()))));
            }
            return results;
        }
        catch (TopiaException e) {
            this.doCatch(e);
            return null;
        }
    }

    @Override
    public List<VotingListDTO> selectVotingList(Map<String, Object> properties) {
        List<VotingListDTO> results = null;
        List votingListEntities = null;
        try {
            this.transaction = this.rootContext.beginTransaction();
            this.votingListDAO = PollenModelDAOHelper.getVotingListDAO(this.transaction);
            if (properties == null) {
                votingListEntities = this.votingListDAO.findAll();
                if (log.isWarnEnabled()) {
                    log.warn((Object)"Attention : toutes les listes ont \u00e9t\u00e9 s\u00e9lectionn\u00e9s !");
                }
            } else {
                votingListEntities = this.votingListDAO.findAllByProperties(properties);
            }
            this.votingListConverter.setTransaction(this.transaction);
            results = this.votingListConverter.createVotingListDTOs(votingListEntities);
            this.transaction.commitTransaction();
            this.transaction.closeContext();
            if (log.isInfoEnabled()) {
                log.info((Object)("Entities found: " + (results == null ? "null" : Integer.valueOf(results.size()))));
            }
            return results;
        }
        catch (TopiaException e) {
            this.doCatch(e);
            return null;
        }
    }

    @Override
    public String createPersonList(PersonListDTO personList) {
        String topiaId = "";
        try {
            this.transaction = this.rootContext.beginTransaction();
            this.personListDAO = PollenModelDAOHelper.getPersonListDAO(this.transaction);
            PersonList entity = (PersonList)this.personListDAO.create(new Object[0]);
            this.personListConverter.setTransaction(this.transaction);
            this.personListConverter.populatePersonListEntity(personList, entity);
            ServicePollAccountImpl spa = new ServicePollAccountImpl();
            for (PollAccountDTO account : personList.getPollAccountDTOs()) {
                account.setPersonListId(entity.getTopiaId());
            }
            entity.setPollAccount(spa.createPollAccounts(personList.getPollAccountDTOs(), this.transaction));
            topiaId = entity.getTopiaId();
            this.transaction.commitTransaction();
            this.transaction.closeContext();
            if (log.isInfoEnabled()) {
                log.info((Object)("Entity created: " + topiaId));
            }
            return topiaId;
        }
        catch (TopiaException e) {
            this.doCatch(e);
            return "";
        }
    }

    @Override
    public boolean createPersonLists(List<PersonListDTO> personLists, String userId, TopiaContext trans) {
        if (personLists.isEmpty() || userId.length() == 0) {
            return false;
        }
        try {
            this.transaction = trans;
            this.personListDAO = PollenModelDAOHelper.getPersonListDAO(this.transaction);
            this.personListConverter.setTransaction(this.transaction);
            for (PersonListDTO personList : personLists) {
                PersonList entity = (PersonList)this.personListDAO.create(new Object[0]);
                ServicePollAccountImpl spa = new ServicePollAccountImpl();
                for (PollAccountDTO account : personList.getPollAccountDTOs()) {
                    account.setPersonListId(entity.getTopiaId());
                }
                entity.setPollAccount(spa.createPollAccounts(personList.getPollAccountDTOs(), this.transaction));
                personList.setUserId(userId);
                this.personListConverter.populatePersonListEntity(personList, entity);
            }
            return true;
        }
        catch (TopiaException e) {
            this.doCatch(e);
            return false;
        }
    }

    @Override
    public boolean updatePersonList(PersonListDTO personList) {
        try {
            this.transaction = this.rootContext.beginTransaction();
            this.personListDAO = PollenModelDAOHelper.getPersonListDAO(this.transaction);
            PersonList entity = (PersonList)this.personListDAO.findByTopiaId(personList.getId());
            this.personListConverter.setTransaction(this.transaction);
            this.personListConverter.populatePersonListEntity(personList, entity);
            this.personListDAO.update(entity);
            ServicePollAccountImpl spa = new ServicePollAccountImpl();
            for (PollAccountDTO pollAccountDTO : personList.getPollAccountDTOs()) {
                pollAccountDTO.setPersonListId(entity.getTopiaId());
                boolean updated = spa.updatePollAccount(pollAccountDTO);
                if (!updated) {
                    pollAccountDTO.setId(spa.createPollAccount(pollAccountDTO));
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("PollAccount " + pollAccountDTO.getVotingId() + " (" + pollAccountDTO.getId() + ") updated: " + updated));
            }
            this.transaction.commitTransaction();
            this.transaction.closeContext();
            if (log.isInfoEnabled()) {
                log.info((Object)("Entity updated: " + personList.getId()));
            }
            return true;
        }
        catch (TopiaException e) {
            this.doCatch(e);
            return false;
        }
    }

    @Override
    public boolean deletePersonList(String personListId) {
        try {
            this.transaction = this.rootContext.beginTransaction();
            this.personListDAO = PollenModelDAOHelper.getPersonListDAO(this.transaction);
            PersonList entity = (PersonList)this.personListDAO.findByTopiaId(personListId);
            this.personListDAO.delete(entity);
            this.transaction.commitTransaction();
            this.transaction.closeContext();
            if (log.isInfoEnabled()) {
                log.info((Object)("Entity deleted: " + personListId));
            }
            return true;
        }
        catch (TopiaException e) {
            this.doCatch(e);
            return false;
        }
    }

    @Override
    public PersonListDTO findPersonListById(String personListId) {
        PersonListDTO result = null;
        try {
            this.transaction = this.rootContext.beginTransaction();
            this.personListDAO = PollenModelDAOHelper.getPersonListDAO(this.transaction);
            PersonList personListEntity = (PersonList)this.personListDAO.findByTopiaId(personListId);
            if (personListEntity != null) {
                this.personListConverter.setTransaction(this.transaction);
                result = this.personListConverter.createPersonListDTO(personListEntity);
            }
            this.transaction.commitTransaction();
            this.transaction.closeContext();
            if (log.isInfoEnabled()) {
                log.info((Object)("Entity found: " + (result == null ? "null" : result.getId())));
            }
            return result;
        }
        catch (TopiaException e) {
            this.doCatch(e);
            return null;
        }
    }

    @Override
    public List<PersonListDTO> findPersonListByName(String name) {
        List<PersonListDTO> results = null;
        List<PersonList> personListEntities = null;
        try {
            this.transaction = this.rootContext.beginTransaction();
            this.personListDAO = PollenModelDAOHelper.getPersonListDAO(this.transaction);
            personListEntities = this.personListDAO.findAllByName(name);
            this.personListConverter.setTransaction(this.transaction);
            results = this.personListConverter.createPersonListDTOs(personListEntities);
            this.transaction.commitTransaction();
            this.transaction.closeContext();
            if (log.isInfoEnabled()) {
                log.info((Object)("Entities found: " + (results == null ? "null" : Integer.valueOf(results.size()))));
            }
            return results;
        }
        catch (TopiaException e) {
            this.doCatch(e);
            return null;
        }
    }

    @Override
    public List<PersonListDTO> findPersonListByUser(String userId) {
        List<PersonListDTO> results = null;
        ArrayList<PersonList> personListEntities = null;
        UserAccountDAO userDAO = null;
        try {
            this.transaction = this.rootContext.beginTransaction();
            userDAO = PollenModelDAOHelper.getUserAccountDAO(this.transaction);
            UserAccount user = (UserAccount)userDAO.findByTopiaId(userId);
            personListEntities = new ArrayList<PersonList>();
            personListEntities.addAll(user.getFavoriteList());
            this.personListConverter.setTransaction(this.transaction);
            results = this.personListConverter.createPersonListDTOs(personListEntities);
            this.transaction.commitTransaction();
            this.transaction.closeContext();
            if (log.isInfoEnabled()) {
                log.info((Object)("Entities found: " + (results == null ? "null" : Integer.valueOf(results.size()))));
            }
            return results;
        }
        catch (TopiaException e) {
            this.doCatch(e);
            return null;
        }
    }

    @Override
    public List<PersonListDTO> selectPersonList(Map<String, Object> properties) {
        List<PersonListDTO> results = null;
        List personListEntities = null;
        try {
            this.transaction = this.rootContext.beginTransaction();
            this.personListDAO = PollenModelDAOHelper.getPersonListDAO(this.transaction);
            if (properties == null) {
                personListEntities = this.personListDAO.findAll();
                if (log.isWarnEnabled()) {
                    log.warn((Object)"Attention : toutes les listes ont \u00e9t\u00e9 s\u00e9lectionn\u00e9s !");
                }
            } else {
                personListEntities = this.personListDAO.findAllByProperties(properties);
            }
            this.personListConverter.setTransaction(this.transaction);
            results = this.personListConverter.createPersonListDTOs(personListEntities);
            this.transaction.commitTransaction();
            this.transaction.closeContext();
            if (log.isInfoEnabled()) {
                log.info((Object)("Entities found: " + (results == null ? "null" : Integer.valueOf(results.size()))));
            }
            return results;
        }
        catch (TopiaException e) {
            this.doCatch(e);
            return null;
        }
    }

    @Override
    public String createPersonToList(PollAccountDTO account) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean updatePersonToList(PollAccountDTO account) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean deletePersonToList(String accountId) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private void doCatch(TopiaException e) {
        try {
            if (this.transaction != null) {
                this.transaction.rollbackTransaction();
                this.transaction.closeContext();
            }
        }
        catch (TopiaException ex) {
            ex.printStackTrace();
        }
        e.printStackTrace();
    }
}

