/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.business;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.pollen.business.ServiceAuth;
import org.chorem.pollen.business.converters.DataUserConverter;
import org.chorem.pollen.business.dto.UserDTO;
import org.chorem.pollen.business.persistence.PollenModelDAOHelper;
import org.chorem.pollen.business.persistence.UserAccount;
import org.chorem.pollen.business.persistence.UserAccountDAO;
import org.chorem.pollen.business.utils.ContextUtil;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;

public class ServiceAuthImpl
implements ServiceAuth {
    private TopiaContext rootContext = ContextUtil.getInstance().getContext();
    private TopiaContext transaction = null;
    private UserAccountDAO userDAO = null;
    private DataUserConverter converter = new DataUserConverter();
    private static final Log log = LogFactory.getLog(ServiceAuthImpl.class);

    @Override
    public UserDTO isLoginRight(String login, String password) {
        UserDTO result = null;
        try {
            this.transaction = this.rootContext.beginTransaction();
            this.userDAO = PollenModelDAOHelper.getUserAccountDAO(this.transaction);
            Object userEntity = this.userDAO.findByLogin(login);
            result = userEntity != null && password.equals(userEntity.getPassword()) ? this.converter.createUserDTO((UserAccount)userEntity) : null;
            this.transaction.commitTransaction();
            this.transaction.closeContext();
            if (log.isInfoEnabled()) {
                log.info((Object)("Entity found: " + (result == null ? "null" : result.getLogin())));
            }
            return result;
        }
        catch (TopiaException e) {
            this.doCatch(e);
            return null;
        }
    }

    private void doCatch(TopiaException e) {
        try {
            if (this.transaction != null) {
                this.transaction.rollbackTransaction();
                this.transaction.closeContext();
            }
        }
        catch (TopiaException ex) {
            ex.printStackTrace();
        }
        e.printStackTrace();
    }
}

