/* *##% Pollen
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>. ##%*/

package org.chorem.pollen.business.dto;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * Classe DTO représentant un utilisateur.
 *
 * @author amine
 * @author rannou
 * @version $Id: UserDTO.java 2615 2009-07-01 13:47:45Z nrannou $
 */
public class UserDTO implements Serializable {

    private String id = "";

    private String login = "";

    private String firstName = "";

    private String lastName = "";

    private boolean administrator = false;

    private String langage = "";

    private String email = "";

    private List<PersonListDTO> personListDTOs = new ArrayList<PersonListDTO>();

    private List<PollAccountDTO> pollAccountDTOs = new ArrayList<PollAccountDTO>();

    public UserDTO() {

    }

    public UserDTO(String id) {
        this.id = id;
    }

    public UserDTO(String login, String firstName, String lastName) {
        this.login = login;
        this.firstName = firstName;
        this.lastName = lastName;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getLogin() {
        return login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getFirstName() {
        return firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public boolean isAdministrator() {
        return administrator;
    }

    public void isAdministrator(boolean administrator) {
        this.administrator = administrator;
    }

    public String getLangage() {
        return langage;
    }

    public void setLangage(String langage) {
        this.langage = langage;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public List<PersonListDTO> getPersonListDTOs() {
        return personListDTOs;
    }

    public void setPersonListDTOs(List<PersonListDTO> personListDTOs) {
        this.personListDTOs = personListDTOs;
    }

    public List<PollAccountDTO> getPollAccountDTOs() {
        return pollAccountDTOs;
    }

    public void setPollAccountDTOs(List<PollAccountDTO> pollAccountDTOs) {
        this.pollAccountDTOs = pollAccountDTOs;
    }

}
