/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.identity;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.business.api.IdentityService;
import org.chorem.lima.entity.Identity;
import org.chorem.lima.entity.IdentityImpl;
import org.chorem.lima.service.LimaServiceFactory;
import org.chorem.lima.ui.identity.IdentityForm;

public class IdentityHandler {
    protected IdentityService identityService;
    protected IdentityForm view;
    private static final Log log = LogFactory.getLog(IdentityHandler.class);

    public IdentityHandler(IdentityForm view) {
        this.view = view;
        this.identityService = (IdentityService)LimaServiceFactory.getService(IdentityService.class);
    }

    public Identity getIdentity() {
        Identity identity = this.identityService.getIdentity();
        if (identity == null) {
            identity = new IdentityImpl();
        }
        return identity;
    }

    public void updateIdentity() {
        Identity identity = this.getIdentity();
        identity.setName(this.view.getNameTextField().getText());
        identity.setDescription(this.view.getDescriptionTextField().getText());
        identity.setAddress(this.view.getAddressTextField().getText());
        identity.setAddress2(this.view.getAddress2TextField().getText());
        identity.setZipCode(this.view.getZipCodeTextField().getText());
        identity.setCity(this.view.getCityTextField().getText());
        identity.setBusinessNumber(this.view.getBusinessNumberTextField().getText());
        identity.setVatNumber(this.view.getVatNumberTextField().getText());
        identity.setClassificationCode(this.view.getClassificationCodeTextField().getText());
        identity.setPhoneNumber(this.view.getPhoneNumberTextField().getText());
        identity.setEmail(this.view.getEmailTextField().getText());
        this.identityService.updateIdentity(identity);
    }
}

