package org.chorem.lima.ui.fiscalperiod;

/*
 * #%L
 * Lima :: Swing
 * %%
 * Copyright (C) 2008 - 2015 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class FiscalPeriodView extends JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BLOCK_ENABLED = "blockEnabled";
    public static final String PROPERTY_DELETE_ENABLED = "deleteEnabled";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_BLOCK_BUTTON_ENABLED = "blockButton.enabled";
    public static final String BINDING_REMOVE_BUTTON_ENABLED = "removeButton.enabled";
    public static final String BINDING_UPDATE_BUTTON_ENABLED = "updateButton.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK2VQW8bRRTHX9w6iZ24NHGapqJFaSmiHLpuEQWhIChJE5LITStsVVV9gPHuJJ4y3tnOzNZbVUV8BD4C3LkgceOEOHDugQviKyDEgSvqm1nHu+vdKI6ED+t45r3//N7bef/88BeUlYTLj0kUOTL0NetTZ/fThw/vdR9TV9+hypUs0EJC/JkqQakDc95oXWl4s9M06Y1hemND9APhUz+VvdaEqtLPOFU9SrWGS9kMV6lGa7S9FgWhPFQdQRWpfvfP36VvvW++LwFEAdLVsJTV47KSSk43ocQ8DYt40lPS4MQ/QAzJ/APkrZm1DU6U2iN9+gS+hpkmTAdEopiGK5OXbDVsfhRomL26e5/4lN/QcEPIA8ftCUn7Dmd94oTM2WfKJTygkgnP2bI/7tsfDxgdBIHVmdYw0yO+x6nU8MFJRbbjzERrvsuF+9WmT7qcYjMWTN2O6YWzLgSnxE9Cax7lVNNhrFlcSDFpDF8nyLRkJCJHDbCTzm47XjZRlVFwhXjeeqi18DXUM+HxqglbShDDwCOaJlsXsvtztoQjt+exOeLp0em1q7stVwrOzZvBF3M+A5RsZUtY3k91tm06cldgfzS8f5JXkiQmnVzIKWu4eWJRI7Y60jyj8NW5mgl/SPlGusgmU7qVCUAaCa9nZgmn1EmmNBmjqQ6UZYjLGlY6+cH+HLfikV4ZG2kjaHf/W67//vOfP20dznEVzz5XGJqyIZyvQAqsXjNz9GvxEIea8cZdEqx1oBKXbD3qYgFYa7iNcHhefO9NurNNVA8lyjN//PLr8pcvT0FpC6pcEG+LmPgdqOiexC4I7kXBJ7ct0fxgFp9nDRve7n2M1vGLK+8TrmiE5V8sKH/E0K389m+99ePtwxZMIdKFI8OTNpQfwTTzOfOpNbOhTxWa11ygaOiJxI+KHAqSQQ6GN/Kmfd7KFVrSUCX2xuy4Zo7Ppq/tdZ8OcDCNVJsFbRqhaZ6zFzcd5aANRKGR/9DWbP5ag7Q9HAdxCnnpoXfVnzN1J21R1955MQaZma3r1GN6nHIlTxnbTxFoxplOxLqIrOsp582jLmZQXS4UHWc9n2e1VliEmjbJ/7ur9QxqbLcT9DX+d1LY17RlT0C75Aoe9v0NhEG3fsAUs8N3WssQv2aVkJlxxBsmxWCbsoMekpXefa+IIW/Dx4Hg6NcyPqvhred5b3VaO3ufNTe/aG02NzfaO/f2XhQdP+bYE5w9zckzgR2DMx/hpSSrXeZ76O4f59SnzLM6gWK5b44223lEK/L2BCJjhRyj9gqflsVukgoAAA==";
    private static final Log log = LogFactory.getLog(FiscalPeriodView.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton addButton;
    protected JButton blockButton;
    protected Boolean blockEnabled;
    protected Boolean deleteEnabled;
    protected FiscalPeriodTable fiscalPeriodTable;
    protected FiscalPeriodTableModel fiscalPeriodTableModel;
    protected FiscalPeriodViewHandler handler;
    protected JButton removeButton;
    protected ListSelectionModel selectionModel;
    protected JToolBar toolBar;
    protected JButton updateButton;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private FiscalPeriodView $JPanel0 = this;
    private JScrollPane $JScrollPane0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    void $afterCompleteSetup() {
            getHandler().init();
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public FiscalPeriodView(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public FiscalPeriodView(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FiscalPeriodView() {
        $initialize();
    }

    public FiscalPeriodView(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FiscalPeriodView(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public FiscalPeriodView(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FiscalPeriodView(boolean param0) {
        super(param0);
        $initialize();
    }

    public FiscalPeriodView(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__addButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.addFiscalPeriod();
    }

    public void doActionPerformed__on__blockButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.blockFiscalPeriod();
    }

    public void doActionPerformed__on__removeButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.deleteFiscalPeriod();
    }

    public void doActionPerformed__on__updateButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.updateFiscalPeriod();
    }

    public void doValueChanged__on__selectionModel(ListSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.onSelectionChanged(event);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getAddButton() {
        return addButton;
    }

    public JButton getBlockButton() {
        return blockButton;
    }

    public Boolean getBlockEnabled() {
        return blockEnabled;
    }

    public Boolean getDeleteEnabled() {
        return deleteEnabled;
    }

    public FiscalPeriodTable getFiscalPeriodTable() {
        return fiscalPeriodTable;
    }

    public FiscalPeriodTableModel getFiscalPeriodTableModel() {
        return fiscalPeriodTableModel;
    }

    public FiscalPeriodViewHandler getHandler() {
        return handler;
    }

    public JButton getRemoveButton() {
        return removeButton;
    }

    public ListSelectionModel getSelectionModel() {
        return selectionModel;
    }

    public JToolBar getToolBar() {
        return toolBar;
    }

    public JButton getUpdateButton() {
        return updateButton;
    }

    public Boolean isBlockEnabled() {
        return blockEnabled !=null && blockEnabled;
    }

    public Boolean isDeleteEnabled() {
        return deleteEnabled !=null && deleteEnabled;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBlockEnabled(Boolean blockEnabled) {
        Boolean oldValue = this.blockEnabled;
        this.blockEnabled = blockEnabled;
        firePropertyChange(PROPERTY_BLOCK_ENABLED, oldValue, blockEnabled);
    }

    public void setDeleteEnabled(Boolean deleteEnabled) {
        Boolean oldValue = this.deleteEnabled;
        this.deleteEnabled = deleteEnabled;
        firePropertyChange(PROPERTY_DELETE_ENABLED, oldValue, deleteEnabled);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToToolBar() {
        if (!allComponentsCreated) {
            return;
        }
        toolBar.add(addButton);
        toolBar.add(updateButton);
        toolBar.add(blockButton);
        toolBar.add(removeButton);
    }

    protected void createAddButton() {
        $objectMap.put("addButton", addButton = new JButton());
        
        addButton.setName("addButton");
        addButton.setToolTipText(t("lima.fiscalPeriod.add"));
        addButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__addButton"));
    }

    protected void createBlockButton() {
        $objectMap.put("blockButton", blockButton = new JButton());
        
        blockButton.setName("blockButton");
        blockButton.setToolTipText(t("lima.fiscalPeriod.block"));
        blockButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__blockButton"));
    }

    protected void createBlockEnabled() {
        $objectMap.put("blockEnabled", blockEnabled = false);
    }

    protected void createDeleteEnabled() {
        $objectMap.put("deleteEnabled", deleteEnabled = false);
    }

    protected void createFiscalPeriodTable() {
        $objectMap.put("fiscalPeriodTable", fiscalPeriodTable = new FiscalPeriodTable(handler));
        
        fiscalPeriodTable.setName("fiscalPeriodTable");
        fiscalPeriodTable.setColumnControlVisible(true);
        fiscalPeriodTable.setSortable(false);
        fiscalPeriodTable.setRowHeight(24);
    }

    protected void createFiscalPeriodTableModel() {
        $objectMap.put("fiscalPeriodTableModel", fiscalPeriodTableModel = new FiscalPeriodTableModel());
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new FiscalPeriodViewHandler(this));
    }

    protected void createRemoveButton() {
        $objectMap.put("removeButton", removeButton = new JButton());
        
        removeButton.setName("removeButton");
        removeButton.setToolTipText(t("lima.fiscalPeriod.delete"));
        removeButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__removeButton"));
    }

    protected void createSelectionModel() {
        $objectMap.put("selectionModel", selectionModel = new DefaultListSelectionModel());
        
        selectionModel.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__selectionModel"));
    }

    protected void createToolBar() {
        $objectMap.put("toolBar", toolBar = new JToolBar());
        
        toolBar.setName("toolBar");
        toolBar.setFloatable(false);
    }

    protected void createUpdateButton() {
        $objectMap.put("updateButton", updateButton = new JButton());
        
        updateButton.setName("updateButton");
        updateButton.setToolTipText(t("lima.fiscalPeriod.update"));
        updateButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__updateButton"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $JPanel0
        add(toolBar, BorderLayout.PAGE_START);
        add($JScrollPane0, BorderLayout.CENTER);
        addChildrenToToolBar();
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(fiscalPeriodTable);
        
        // apply 3 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 8 property setters
        fiscalPeriodTable.setModel(fiscalPeriodTableModel);
        fiscalPeriodTable.setSelectionModel(selectionModel);
        addButton.setIcon(SwingUtil.createActionIcon("fiscalPeriod-new"));
        updateButton.setIcon(SwingUtil.createActionIcon("fiscalPeriod-edit"));
        blockButton.setIcon(SwingUtil.createActionIcon("fiscalPeriod-close"));
        removeButton.setIcon(SwingUtil.createActionIcon("fiscalPeriod-remove"));
        selectionModel.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$JPanel0", $JPanel0);
        createHandler();
        createBlockEnabled();
        createDeleteEnabled();
        createToolBar();
        createAddButton();
        createUpdateButton();
        createBlockButton();
        createRemoveButton();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createFiscalPeriodTableModel();
        createFiscalPeriodTable();
        createSelectionModel();
        // inline creation of $JPanel0
        setName("$JPanel0");
        setLayout(new BorderLayout());
        
        // registers 3 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 3 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_UPDATE_BUTTON_ENABLED, true ,"deleteEnabled") {
        
            @Override
            public void processDataBinding() {
                updateButton.setEnabled(isDeleteEnabled());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_BLOCK_BUTTON_ENABLED, true ,"blockEnabled") {
        
            @Override
            public void processDataBinding() {
                blockButton.setEnabled(isBlockEnabled());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_REMOVE_BUTTON_ENABLED, true ,"deleteEnabled") {
        
            @Override
            public void processDataBinding() {
                removeButton.setEnabled(isDeleteEnabled());
            }
        });
    }

}