/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.fiscalControlExport;

import com.google.common.base.Charsets;
import java.awt.Color;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.rmi.server.ExportException;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.LimaSwingConfig;
import org.chorem.lima.business.ExportResult;
import org.chorem.lima.business.LimaServiceFactory;
import org.chorem.lima.business.api.EntryBookService;
import org.chorem.lima.business.api.ExportService;
import org.chorem.lima.business.api.FiscalPeriodService;
import org.chorem.lima.business.api.IdentityService;
import org.chorem.lima.entity.EntryBook;
import org.chorem.lima.entity.FiscalPeriod;
import org.chorem.lima.entity.Identity;
import org.chorem.lima.ui.fiscalControlExport.FiscalControlExportView;
import org.chorem.lima.ui.importexport.ImportExportWaitView;
import org.chorem.lima.util.ErrorHelper;
import org.jdesktop.swingx.painter.BusyPainter;
import org.nuiton.i18n.I18n;

public class FiscalControlExportViewHandler {
    private static final Log log = LogFactory.getLog(FiscalControlExportViewHandler.class);
    protected FiscalControlExportView view;
    protected FiscalPeriodService fiscalPeriodService;
    protected EntryBookService entryBookService;
    protected IdentityService identityService;
    protected ExportService exportService;
    private ImportExportWaitView waitView;

    public FiscalControlExportViewHandler(FiscalControlExportView view) {
        this.view = view;
        this.fiscalPeriodService = (FiscalPeriodService)LimaServiceFactory.getService(FiscalPeriodService.class);
        this.entryBookService = (EntryBookService)LimaServiceFactory.getService(EntryBookService.class);
        this.identityService = (IdentityService)LimaServiceFactory.getService(IdentityService.class);
        this.exportService = (ExportService)LimaServiceFactory.getService(ExportService.class);
    }

    public void init() {
        List fiscalPeriods = this.fiscalPeriodService.getAllBlockedFiscalPeriods();
        this.view.getFiscalPeriodComboBoxModel().setObjects(fiscalPeriods);
        if (!fiscalPeriods.isEmpty()) {
            this.view.getFiscalPeriodComboBoxModel().setSelectedItem(fiscalPeriods.get(fiscalPeriods.size() - 1));
        }
        List entryBooks = this.entryBookService.getAllEntryBooks();
        this.view.getEntryBookAtNewComboBoxModel().setObjects(entryBooks);
        Identity identity = this.identityService.getIdentity();
        this.view.getSirenWarnLabel().setVisible(StringUtils.isBlank((CharSequence)identity.getBusinessNumber()));
    }

    public void export() {
        FiscalPeriod fiscalPeriod = (FiscalPeriod)this.view.getFiscalPeriodComboBoxModel().getSelectedItem();
        EntryBook entryBookAtNew = (EntryBook)this.view.getEntryBookAtNewComboBoxModel().getSelectedItem();
        if (fiscalPeriod != null && entryBookAtNew != null) {
            String fileName = this.exportService.getFiscalControlFileName(fiscalPeriod);
            File homeDirectory = new File(System.getProperty("user.home"));
            File exportFile = new File(homeDirectory, fileName);
            JFileChooser chooser = new JFileChooser();
            chooser.setFileSelectionMode(0);
            chooser.setSelectedFile(exportFile);
            String approveButtonText = I18n.t((String)"lima.importExport.export", (Object[])new Object[0]);
            chooser.setDialogTitle(approveButtonText);
            chooser.setApproveButtonText(approveButtonText);
            if (chooser.showOpenDialog(this.view) == 0) {
                Object[] options;
                exportFile = chooser.getSelectedFile();
                boolean continueExport = true;
                if (!exportFile.getName().equals(fileName)) {
                    options = new String[]{I18n.t((String)"lima.fiscalControlExport.file.nonConformanceName.continue", (Object[])new Object[0]), I18n.t((String)"lima.fiscalControlExport.file.nonConformanceName.cancel", (Object[])new Object[0])};
                    boolean bl = continueExport = 0 == JOptionPane.showOptionDialog(this.view, I18n.t((String)"lima.fiscalControlExport.file.nonConformanceName", (Object[])new Object[]{exportFile.getName(), fileName}), I18n.t((String)"lima.fiscalControlExport.file.nonConformanceName.title", (Object[])new Object[0]), 2, 2, null, options, options[0]);
                }
                if (continueExport && exportFile.exists()) {
                    options = new String[]{I18n.t((String)"lima.fiscalControlExport.file.overwrite.continue", (Object[])new Object[0]), I18n.t((String)"lima.fiscalControlExport.file.overwrite.cancel", (Object[])new Object[0])};
                    boolean bl = continueExport = 0 == JOptionPane.showOptionDialog(this.view, I18n.t((String)"lima.fiscalControlExport.file.overwrite", (Object[])new Object[]{exportFile.getName()}), I18n.t((String)"lima.fiscalControlExport.file.overwrite.title", (Object[])new Object[0]), 2, 2, null, options, options[0]);
                }
                if (continueExport) {
                    this.waitView = new ImportExportWaitView();
                    this.waitView.setLocationRelativeTo(this.view);
                    BusyPainter busyPainter = this.waitView.getBusylabel().getBusyPainter();
                    busyPainter.setHighlightColor(new Color(44, 61, 146).darker());
                    busyPainter.setBaseColor(new Color(168, 204, 241).brighter());
                    new ExportWorker(fiscalPeriod, entryBookAtNew, exportFile).execute();
                    this.waitView.setVisible(true);
                    this.view.dispose();
                }
            }
        }
    }

    protected class ExportWorker
    extends SwingWorker<ExportResult, Void> {
        protected FiscalPeriod fiscalPeriod;
        protected EntryBook entryBookAtNew;
        protected File exportFile;

        public ExportWorker(FiscalPeriod fiscalPeriod, EntryBook entryBookAtNew, File exportFile) {
            this.fiscalPeriod = fiscalPeriod;
            this.entryBookAtNew = entryBookAtNew;
            this.exportFile = exportFile;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected ExportResult doInBackground() throws Exception {
            ExportResult exportResult = FiscalControlExportViewHandler.this.exportService.exportFiscalControl(this.fiscalPeriod, this.entryBookAtNew, Charsets.UTF_8.toString());
            List exportExceptions = exportResult.getExportExceptions();
            if (exportExceptions != null && !exportExceptions.isEmpty()) throw (ExportException)exportExceptions.get(0);
            BufferedWriter out = null;
            try {
                out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(this.exportFile)));
                out.write(exportResult.getExportData());
                out.flush();
                out.close();
                IOUtils.closeQuietly((Writer)out);
                return exportResult;
            }
            catch (IOException eee) {
                if (!log.isErrorEnabled()) return exportResult;
                log.error((Object)("Can't write file " + this.exportFile), (Throwable)eee);
                return exportResult;
            }
            finally {
                IOUtils.closeQuietly(out);
            }
        }

        @Override
        protected void done() {
            try {
                FiscalControlExportViewHandler.this.waitView.setVisible(false);
                ExportResult exportResult = (ExportResult)this.get();
                JOptionPane.showMessageDialog(FiscalControlExportViewHandler.this.view, I18n.t((String)"lima.fiscalControlExport.success", (Object[])new Object[0]), I18n.t((String)"lima.fiscalControlExport.success.title", (Object[])new Object[0]), 1);
            }
            catch (Exception ex) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Can't get result message", (Throwable)ex);
                }
                ErrorHelper errorHelper = new ErrorHelper(LimaSwingConfig.getInstance());
                errorHelper.showErrorDialog(null, ex.getMessage(), ex);
            }
        }
    }
}

