/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.common;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.business.LimaServiceFactory;
import org.chorem.lima.business.api.FinancialTransactionService;
import org.chorem.lima.business.exceptions.AfterLastFiscalPeriodException;
import org.chorem.lima.business.exceptions.BeforeFirstFiscalPeriodException;
import org.chorem.lima.business.exceptions.LockedEntryBookException;
import org.chorem.lima.business.exceptions.LockedFinancialPeriodException;
import org.chorem.lima.business.utils.EntryComparator;
import org.chorem.lima.entity.Entry;
import org.chorem.lima.entity.EntryImpl;
import org.chorem.lima.entity.FinancialTransaction;
import org.chorem.lima.entity.FinancialTransactionImpl;
import org.chorem.lima.ui.common.TableModelWithGroup;
import org.chorem.lima.ui.financialtransaction.AccountColumn;
import org.chorem.lima.ui.financialtransaction.CreditColumn;
import org.chorem.lima.ui.financialtransaction.DayColumn;
import org.chorem.lima.ui.financialtransaction.DebitColumn;
import org.chorem.lima.ui.financialtransaction.DescriptionColumn;
import org.chorem.lima.ui.financialtransaction.VoucherColumn;
import org.nuiton.i18n.I18n;

public class FinancialTransactionTableModel
extends TableModelWithGroup<Entry> {
    private static final long serialVersionUID = -7495388454688562991L;
    protected static final Log log = LogFactory.getLog(FinancialTransactionTableModel.class);
    protected FinancialTransactionService financialTransactionService;

    public FinancialTransactionTableModel() {
        this.setComparator(new EntryComparator());
        this.financialTransactionService = (FinancialTransactionService)LimaServiceFactory.getService(FinancialTransactionService.class);
    }

    @Override
    protected void initColumn() {
        this.addColumn(new DayColumn());
        this.addColumn(new VoucherColumn());
        this.addColumn(new AccountColumn());
        this.addColumn(new DescriptionColumn());
        this.addColumn(new DebitColumn());
        this.addColumn(new CreditColumn());
    }

    public void setTransactions(List<FinancialTransaction> transactions) {
        this.clear();
        for (FinancialTransaction transaction : transactions) {
            this.addAll(transaction.getEntry());
        }
    }

    public FinancialTransaction getTransactionAt(int row) {
        Entry entry = (Entry)this.get(row);
        return entry.getFinancialTransaction();
    }

    @Override
    public int indexOf(FinancialTransaction transaction) {
        Entry entry;
        int index = 0;
        Collection entriesTransaction = transaction.getEntry();
        Iterator i$ = this.values.iterator();
        while (i$.hasNext() && !entriesTransaction.contains(entry = (Entry)i$.next())) {
            ++index;
        }
        return index;
    }

    @Override
    public boolean contains(FinancialTransaction transaction) {
        boolean result = false;
        for (Entry entry : transaction.getEntry()) {
            if (!this.contains(entry)) continue;
            result = true;
            break;
        }
        return result;
    }

    public Entry addEntry(Entry entry) throws BeforeFirstFiscalPeriodException, AfterLastFiscalPeriodException, LockedFinancialPeriodException, LockedEntryBookException {
        EntryImpl newEntry = null;
        FinancialTransaction transaction = entry.getFinancialTransaction();
        if (this.contains(transaction)) {
            newEntry = new EntryImpl();
            newEntry.setFinancialTransaction(transaction);
            newEntry.setVoucher(entry.getVoucher());
            newEntry.setAccount(entry.getAccount());
            newEntry.setDescription(entry.getDescription());
            newEntry.setAmount(entry.getAmount());
            newEntry.setDebit(entry.isDebit());
            newEntry = this.financialTransactionService.createEntry((Entry)newEntry);
            transaction.addEntry((Entry)newEntry);
            this.financialTransactionService.updateFinancialTransaction(transaction);
            this.addValue(newEntry);
        }
        return newEntry;
    }

    public void removeTransaction(int row) throws LockedFinancialPeriodException, LockedEntryBookException {
        FinancialTransaction transaction = this.getTransactionAt(row);
        this.removeAll(transaction.getEntry());
        this.financialTransactionService.removeFinancialTransaction(transaction);
    }

    public void removeEntry(int row) throws LockedFinancialPeriodException, LockedEntryBookException {
        Entry entry = (Entry)this.get(row);
        FinancialTransaction transaction = entry.getFinancialTransaction();
        if (transaction.sizeEntry() > 1) {
            this.financialTransactionService.removeEntry(entry);
            transaction.removeEntry(entry);
            this.remove(entry);
        } else {
            this.financialTransactionService.removeFinancialTransaction(transaction);
            this.removeAll(transaction.getEntry());
        }
    }

    public FinancialTransaction addTransaction(FinancialTransaction transaction) throws LockedFinancialPeriodException, LockedEntryBookException, AfterLastFiscalPeriodException, BeforeFirstFiscalPeriodException {
        FinancialTransactionImpl newTransaction = new FinancialTransactionImpl();
        newTransaction.setEntryBook(transaction.getEntryBook());
        newTransaction.setTransactionDate(transaction.getTransactionDate());
        newTransaction = this.financialTransactionService.createFinancialTransaction((FinancialTransaction)newTransaction);
        if (transaction.getEntry() == null || transaction.getEntry().isEmpty()) {
            EntryImpl newEntry = new EntryImpl();
            newEntry.setFinancialTransaction((FinancialTransaction)newTransaction);
            newEntry = this.financialTransactionService.createEntry((Entry)newEntry);
            newTransaction.addEntry((Entry)newEntry);
        } else {
            for (Entry entry : transaction.getEntry()) {
                EntryImpl newEntry = new EntryImpl();
                newEntry.setFinancialTransaction((FinancialTransaction)newTransaction);
                newEntry.setVoucher(entry.getVoucher());
                newEntry.setAccount(entry.getAccount());
                newEntry.setDescription(entry.getDescription());
                newEntry.setAmount(entry.getAmount());
                newEntry.setDebit(entry.isDebit());
                newEntry = this.financialTransactionService.createEntry((Entry)newEntry);
                newTransaction.addEntry((Entry)newEntry);
            }
            this.financialTransactionService.updateFinancialTransaction((FinancialTransaction)newTransaction);
        }
        this.addAll(newTransaction.getEntry());
        return newTransaction;
    }

    public BigDecimal getBalanceTransactionInRow(int row) {
        FinancialTransaction transaction = this.getTransactionAt(row);
        BigDecimal debit = transaction.getAmountDebit();
        BigDecimal credit = transaction.getAmountCredit();
        BigDecimal balance = debit.subtract(credit);
        return balance;
    }

    @Override
    public boolean sameGroup(Entry e1, Entry e2) {
        return e1.getFinancialTransaction().equals(e2.getFinancialTransaction());
    }

    public boolean updateEntry(Entry entry) {
        boolean updated = false;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Update Entry");
        }
        try {
            this.financialTransactionService.updateEntry(entry);
            updated = true;
        }
        catch (LockedEntryBookException e) {
            this.errorHelper.showErrorMessage(I18n.t((String)"lima.entry.update.error.closedEntryBook", (Object[])new Object[]{e.getClosedPeriodicEntryBook().getEntryBook().getCode(), e.getClosedPeriodicEntryBook().getEntryBook().getLabel(), e.getClosedPeriodicEntryBook().getFinancialPeriod().getBeginDate(), e.getClosedPeriodicEntryBook().getFinancialPeriod().getEndDate()}));
        }
        catch (LockedFinancialPeriodException e) {
            this.errorHelper.showErrorMessage(I18n.t((String)"lima.entry.update.error.lockedFinancialPeriod", (Object[])new Object[]{e.getFinancialPeriod().getBeginDate(), e.getFinancialPeriod().getEndDate()}));
        }
        return updated;
    }

    public boolean updateTransaction(FinancialTransaction transaction) {
        boolean update = false;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Update transaction");
        }
        try {
            this.financialTransactionService.updateFinancialTransaction(transaction);
            update = true;
        }
        catch (LockedFinancialPeriodException e) {
            this.errorHelper.showErrorMessage(I18n.t((String)"lima.financialTransaction.update.error.lockedFinancialPeriod", (Object[])new Object[]{e.getFinancialPeriod().getBeginDate(), e.getFinancialPeriod().getEndDate()}));
        }
        catch (AfterLastFiscalPeriodException e) {
            this.errorHelper.showErrorMessage(I18n.t((String)"lima.financialTransaction.update.error.afterLastFiscalPeriod", (Object[])new Object[]{e.getDate()}));
        }
        catch (BeforeFirstFiscalPeriodException e) {
            this.errorHelper.showErrorMessage(I18n.t((String)"lima.financialTransaction.update.error.beforeFirstFiscalPeriod", (Object[])new Object[]{e.getDate()}));
        }
        catch (LockedEntryBookException e) {
            this.errorHelper.showErrorMessage(I18n.t((String)"lima.financialTransaction.update.error.lockedEntryBook", (Object[])new Object[]{e.getClosedPeriodicEntryBook().getEntryBook().getCode(), e.getClosedPeriodicEntryBook().getEntryBook().getLabel(), e.getClosedPeriodicEntryBook().getFinancialPeriod().getBeginDate(), e.getClosedPeriodicEntryBook().getFinancialPeriod().getEndDate()}));
        }
        return update;
    }

    public void fireTransaction(FinancialTransaction transaction) {
        int firstRow = this.indexOf(transaction);
        int lastRow = firstRow + transaction.sizeEntry() - 1;
        this.fireTableRowsUpdated(firstRow, lastRow);
    }
}

