/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.combobox;

import java.util.Collections;
import java.util.List;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import org.chorem.lima.business.LimaServiceFactory;
import org.chorem.lima.business.ServiceListener;
import org.chorem.lima.business.api.AccountService;
import org.chorem.lima.business.api.ImportService;
import org.chorem.lima.business.utils.AccountComparator;
import org.chorem.lima.entity.Account;
import org.nuiton.decorator.DecoratorUtil;
import org.nuiton.decorator.JXPathDecorator;

public class AccountComboBox
extends BeanFilterableComboBox<Account>
implements ServiceListener {
    protected AccountService accountService;
    protected boolean leafAccounts;

    public AccountComboBox() {
        this.initializeAccountComboBox();
    }

    public AccountComboBox(JAXXContext parentContext) {
        super(parentContext);
        this.initializeAccountComboBox();
    }

    private void initializeAccountComboBox() {
        this.leafAccounts = false;
        this.accountService = (AccountService)LimaServiceFactory.getService(AccountService.class);
        LimaServiceFactory.addServiceListener(AccountService.class, (ServiceListener)this);
        LimaServiceFactory.addServiceListener(ImportService.class, (ServiceListener)this);
        this.init((JXPathDecorator)DecoratorUtil.newMultiJXPathDecorator(Account.class, (String)"${accountNumber}$s##${label}$s", (String)"##", (String)" - "), this.getDataList());
    }

    public boolean isLeafAccounts() {
        return this.leafAccounts;
    }

    public void setLeafAccounts(boolean leafAccounts) {
        this.leafAccounts = leafAccounts;
    }

    public List<Account> getDataList() {
        List result = this.leafAccounts ? this.accountService.getAllLeafAccounts() : this.accountService.getAllAccounts();
        Collections.sort(result, new AccountComparator());
        return result;
    }

    public void refresh() {
        this.setData(this.getDataList());
    }

    public void notifyMethod(String serviceName, String methodName) {
        if (serviceName.contains("Account") || methodName.contains("importAll")) {
            this.refresh();
        }
    }
}

