/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.home;

import java.util.List;
import javax.swing.event.HyperlinkEvent;
import jaxx.runtime.JAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.LimaSwingApplicationContext;
import org.chorem.lima.business.LimaServiceFactory;
import org.chorem.lima.business.ServiceListener;
import org.chorem.lima.business.api.EntryBookService;
import org.chorem.lima.business.api.FinancialTransactionService;
import org.chorem.lima.business.api.FiscalPeriodService;
import org.chorem.lima.business.api.ImportService;
import org.chorem.lima.entity.FiscalPeriod;
import org.chorem.lima.ui.MainView;
import org.chorem.lima.ui.home.AbstractHomePane;
import org.chorem.lima.ui.home.HomeView;
import org.nuiton.i18n.I18n;

public class FinancialTransactionsPane
extends AbstractHomePane
implements ServiceListener {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(FinancialTransactionsPane.class);
    protected FinancialTransactionService financialTransactionService = (FinancialTransactionService)LimaServiceFactory.getService(FinancialTransactionService.class);
    protected FiscalPeriodService fiscalPeriodService = (FiscalPeriodService)LimaServiceFactory.getService(FiscalPeriodService.class);
    protected EntryBookService entryBookService = (EntryBookService)LimaServiceFactory.getService(EntryBookService.class);

    public FinancialTransactionsPane(HomeView view) {
        super(view);
        LimaServiceFactory.addServiceListener(FinancialTransactionService.class, (ServiceListener)this);
        LimaServiceFactory.addServiceListener(FiscalPeriodService.class, (ServiceListener)this);
        LimaServiceFactory.addServiceListener(ImportService.class, (ServiceListener)this);
        this.refresh();
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (HyperlinkEvent.EventType.ACTIVATED.equals(e.getEventType())) {
            if (e.getDescription().equals("#financialtransactionunbalanced")) {
                MainView ui = (MainView)LimaSwingApplicationContext.MAIN_UI_ENTRY_DEF.getContextValue((JAXXContext)this.view);
                ui.getHandler().showTransactionUnbalancedView((JAXXContext)ui);
            } else if (e.getDescription().equals("#financialtransactionbalanced")) {
                MainView ui = (MainView)LimaSwingApplicationContext.MAIN_UI_ENTRY_DEF.getContextValue((JAXXContext)this.view);
                ui.getHandler().showTransactionView((JAXXContext)ui);
            }
        }
    }

    public void refresh() {
        log.debug((Object)"Rafra\u00eechissement financial transaction pane");
        String htmlBegin = "<font face='sans-serif' size=3><p style=vertical-align:'bottom', horizontal-align:'center'>";
        String htmlEnd = "</p></font>";
        List unblockedFiscalPeriods = this.fiscalPeriodService.getAllUnblockedFiscalPeriods();
        List entryBooks = this.entryBookService.getAllEntryBooks();
        if (unblockedFiscalPeriods.size() != 0 && entryBooks.size() != 0) {
            List financialTransactionsInexact = this.financialTransactionService.getAllInexactFinancialTransactions((FiscalPeriod)unblockedFiscalPeriods.get(0));
            if (financialTransactionsInexact.size() > 0) {
                this.setBackground(RED_BACKGROUND);
                String transactionsString = I18n.t((String)"lima.home.entries.error", (Object[])new Object[]{financialTransactionsInexact.size()}) + "<br/><br/><a href='#financialtransactionunbalanced'>" + I18n.t((String)"lima.home.entries.error.modify", (Object[])new Object[0]) + "</a>";
                this.setText(htmlBegin + transactionsString + htmlEnd);
            } else {
                List financialTransactionsBal = this.financialTransactionService.getAllFinancialTransactionsBalanced((FiscalPeriod)unblockedFiscalPeriods.get(0));
                if (financialTransactionsBal.size() > 0) {
                    this.setBackground(GREEN_BACKGROUND);
                    String transactionsString = I18n.t((String)"lima.home.entries.balanced", (Object[])new Object[]{financialTransactionsBal.size()}) + "<br/><br/><a href='#financialtransactionbalanced'>" + I18n.t((String)"lima.home.entries.modify", (Object[])new Object[0]) + "</a>";
                    this.setText(htmlBegin + transactionsString + htmlEnd);
                } else {
                    this.setBackground(RED_BACKGROUND);
                    String transactionsString = I18n.t((String)"lima.home.entries.nothing", (Object[])new Object[0]) + "<br/><br/><a href='#financialtransactionbalanced'>" + I18n.t((String)"lima.home.entries.create", (Object[])new Object[0]) + "</a>";
                    this.setText(htmlBegin + transactionsString + htmlEnd);
                }
            }
        } else {
            this.setBackground(RED_BACKGROUND);
            this.setText("");
        }
    }

    public void notifyMethod(String serviceName, String methodeName) {
        log.debug((Object)("Nom de la m\u00e9thode : " + methodeName));
        if (methodeName.contains("importEntries") || methodeName.contains("importAll") || methodeName.contains("importAs")) {
            this.refresh();
        }
    }
}

