/*
 * #%L
 * Lima :: Swing
 * %%
 * Copyright (C) 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package org.chorem.lima.ui.lettering;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author sletellier <letellier@codelutin.com>
 */
public class LetteringEditModel implements Serializable {

    public static final String PROPERTY_DEBIT = "debit";

    public static final String PROPERTY_CREDIT = "credit";

    public static final String PROPERTY_SOLD = "sold";

    public static final String PROPERTY_LETTRED = "lettred";

    public static final String PROPERTY_UNLETTRED = "unLettred";

    public static final String PROPERTY_EQUALIZED = "equalized";

    protected final PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    protected LetteringTableModel model;
    protected boolean lettred;
    protected boolean unLettred;
    protected boolean equalized;
    protected BigDecimal debit = BigDecimal.ZERO;
    protected BigDecimal credit = BigDecimal.ZERO;
    protected BigDecimal sold = BigDecimal.ZERO;

    public boolean isEqualized() {
        return equalized;
    }

    public void setEqualized(boolean equalized) {
        boolean oldEqualized = isEqualized();
        this.equalized = equalized;
        firePropertyChange(PROPERTY_EQUALIZED, oldEqualized, this.equalized);
    }

    public boolean isLettred() {
        return lettred;
    }

    public void setLettred(boolean lettred) {
        boolean oldLettrer = isLettred();
        if(lettred && (sold == BigDecimal.ZERO || sold.doubleValue() == 0)){
            this.lettred = lettred;
        }else{
            this.lettred = false;
        }
        firePropertyChange(PROPERTY_LETTRED, oldLettrer, this.lettred);
    }

    public boolean isUnLettred() {
        return unLettred;
    }

    public void setUnLettred(boolean unLettred) {
        boolean oldDelettrer = isUnLettred();
        this.unLettred = unLettred;
        firePropertyChange(PROPERTY_UNLETTRED, oldDelettrer, this.unLettred);
    }

    public BigDecimal getDebit() {
        return debit;
    }

    public void setDebit(BigDecimal debit) {
        BigDecimal oldDebit = getDebit();

        if (debit !=  BigDecimal.ZERO){
            this.debit = debit.add(oldDebit);
        }else{
            this.debit = BigDecimal.ZERO;
        }

        firePropertyChange(PROPERTY_DEBIT, oldDebit, this.debit);
    }

    public BigDecimal getCredit() {
        return credit;
    }

    public void setCredit(BigDecimal credit) {
        BigDecimal oldCredit = getCredit();

        if (credit != BigDecimal.ZERO){
            this.credit = credit.add(oldCredit);
        }else{
            this.credit=BigDecimal.ZERO;
        }

        firePropertyChange(PROPERTY_CREDIT, oldCredit, this.credit);
    }

    public BigDecimal getSold() {
        return sold;
    }

    public void setSolde(BigDecimal solde, boolean credit) {
        BigDecimal oldSolde = getSold();

        if (solde != BigDecimal.ZERO){
            if (credit){
                this.sold = oldSolde.subtract(solde);
            }else{
                this.sold = oldSolde.add(solde);
            }
        }else{
            this.sold =BigDecimal.ZERO;
        }

        firePropertyChange(PROPERTY_SOLD, oldSolde, this.sold);
    }

    public void resetDebitCreditBalance(){
        setDebit(BigDecimal.ZERO);
        setCredit(BigDecimal.ZERO);
        setSolde(BigDecimal.ZERO, false);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        pcs.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        pcs.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        pcs.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        pcs.removePropertyChangeListener(propertyName, listener);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        pcs.firePropertyChange(propertyName, oldValue, newValue);
    }

    protected void firePropertyChange(String propertyName, Object newValue) {
        firePropertyChange(propertyName, null, newValue);
    }
}
