package org.chorem.lima.ui.fiscalperiod;

/*
 * #%L
 * Lima :: Swing
 * %%
 * Copyright (C) 2008 - 2015 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dialog.ModalityType;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXDatePicker;
import static org.nuiton.i18n.I18n.t;

public class AddPeriod extends JDialog implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_MODIFY_PERIOD = "modifyPeriod";
    public static final String PROPERTY_VALIDATE = "validate";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_BEGIN_DATE_PICKER_ENABLED = "beginDatePicker.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAJ1Vz0/UQBR+rO4uLCAokWBEReGgMemaGE8QRSFEyKJEPBD34mw7uww7O1PbKZQQjH+Cf4LevZh482Q8ePbgxfgvGOPBq/HNtLR0qbq6h6Z5v7733n7f66uvUPQ9uLhFwtDyAqFYh1ortzc27je2qK0WqW97zFXSg+jXV4BCHQadxO4rmK7XdHo1Tq8uyI4rBRWHsmdrUPHVLqf+JqVKwblshu371fXEPRu6gXdQNWkqr+qL798Kz51nLwsAoYvdDeIoU3/LSic5XoMCcxScQqRtUuVEtLANj4kW9jusbQuc+P490qFP4CmUa1ByiYfFFFzqfWRTw+SHroJRl3pMOkvS6ywywmVLwRXptSx7U3q0Y3HWIVbArCbzbcKjWOu246yZN9c1hUoKhjrSYc3dyKzgpG7W0gNYd6TklIg0tH+bcOYQZWY4kdrLMw9Jg9NrCiYyK/N3cAGW8enIgSThRIO2mFjESjXSoBz3plHDOGHFGHXoySRjJMlYY3abegqm9KxbSJ+2km6UGVorG2lItsAQFU4CqG3jWf9w7E9zz2QD+mdW1oig/Fp3t8aana9kE2HrucYykXcCpaTQMeeT0IJs67fp2OrB2cwKkc9WyueUcH11KHoBmnHn9aMSeICuiPwTXeTXBY335/jYp7df3iwdML6C2KdzQw8JFpnoehLJpJiGHonoHijGq6vEna3DgE85qt2oeTKnsfXYjc0hXkQ2nW7dJf4mliiWP797P/744zEoLEGFS+IsER2/DANq08MtSO6E7q1509HQTj8+R3VvCoqKKY4rGjfEj1gfkdpqokRC3MVkzi6ShhoDH36Mrb+eP9hHH/Z35rfh6U6Kj6DEBGeCmhsQyztX84OuTwNHpjLOEzbkKNuNtXbVPKtHxi8gPbkmNqaghPe6xLKv4LiiIR6bEbMcLWHLxISBLnjdjKvfbsARcf4NG1dfpkJrHK/H2N5F5q8eOiiXr+znYXTL+d8GHNnLiDUdbzgdDyPygDNnoAfUuPCgKXyg6gpSkkmxbEuRaD0PLHb1DlM2MLLdBYE3Iq88mnv4c047tEkCrha49Ol9ZBbRhfFvnsM9kakGEw4ep5tHAPr0s9IDQImTXRko7W/+f5UifoaI/hLMRWKaIgq/n41A0f9uTZvbf2jrAlb4BZlRBLK2CAAA";
    private static final Log log = LogFactory.getLog(AddPeriod.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel beginDateLabel;
    protected JXDatePicker beginDatePicker;
    protected JButton cancel;
    protected JLabel endDateLabel;
    protected JXDatePicker endDatePicker;
    protected Boolean modifyPeriod;
    protected JButton ok;
    protected AddPeriod periodFormDialog = this;
    protected Boolean validate;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
            protected void performOk() {
                setValidate(true);
                dispose();
            }
    
            protected void performCancel() {
                setValidate(false);
                dispose();
            }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AddPeriod(Frame param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AddPeriod(JAXXContext parentContext, Frame param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AddPeriod() {
        $initialize();
    }

    public AddPeriod(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AddPeriod(Frame param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AddPeriod(JAXXContext parentContext, Frame param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AddPeriod(Frame param0) {
        super(param0);
        $initialize();
    }

    public AddPeriod(JAXXContext parentContext, Frame param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AddPeriod(Dialog param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public AddPeriod(JAXXContext parentContext, Dialog param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AddPeriod(Dialog param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public AddPeriod(JAXXContext parentContext, Dialog param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AddPeriod(Window param0) {
        super(param0);
        $initialize();
    }

    public AddPeriod(JAXXContext parentContext, Window param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AddPeriod(Window param0, String param1, ModalityType param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public AddPeriod(JAXXContext parentContext, Window param1, String param2, ModalityType param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AddPeriod(Window param0, String param1, ModalityType param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public AddPeriod(JAXXContext parentContext, Window param1, String param2, ModalityType param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AddPeriod(Window param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AddPeriod(JAXXContext parentContext, Window param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AddPeriod(Frame param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public AddPeriod(JAXXContext parentContext, Frame param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AddPeriod(Frame param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public AddPeriod(JAXXContext parentContext, Frame param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AddPeriod(Window param0, ModalityType param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AddPeriod(JAXXContext parentContext, Window param1, ModalityType param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AddPeriod(Dialog param0) {
        super(param0);
        $initialize();
    }

    public AddPeriod(JAXXContext parentContext, Dialog param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AddPeriod(Dialog param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AddPeriod(JAXXContext parentContext, Dialog param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AddPeriod(Dialog param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AddPeriod(JAXXContext parentContext, Dialog param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancel(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        performCancel();
    }

    public void doActionPerformed__on__ok(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        performOk();
    }

    public void doWindowClosing__on__periodFormDialog(WindowEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        performCancel();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JLabel getBeginDateLabel() {
        return beginDateLabel;
    }

    public JXDatePicker getBeginDatePicker() {
        return beginDatePicker;
    }

    public JButton getCancel() {
        return cancel;
    }

    public JLabel getEndDateLabel() {
        return endDateLabel;
    }

    public JXDatePicker getEndDatePicker() {
        return endDatePicker;
    }

    public Boolean getModifyPeriod() {
        return modifyPeriod;
    }

    public JButton getOk() {
        return ok;
    }

    public Boolean getValidate() {
        return validate;
    }

    public Boolean isModifyPeriod() {
        return modifyPeriod !=null && modifyPeriod;
    }

    public Boolean isValidate() {
        return validate !=null && validate;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setModifyPeriod(Boolean modifyPeriod) {
        Boolean oldValue = this.modifyPeriod;
        this.modifyPeriod = modifyPeriod;
        firePropertyChange(PROPERTY_MODIFY_PERIOD, oldValue, modifyPeriod);
    }

    public void setValidate(Boolean validate) {
        Boolean oldValue = this.validate;
        this.validate = validate;
        firePropertyChange(PROPERTY_VALIDATE, oldValue, validate);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToPeriodFormDialog() {
        if (!allComponentsCreated) {
            return;
        }
        add($Table0, BorderLayout.CENTER);
        add($JPanel0, BorderLayout.SOUTH);
    }

    protected void createBeginDateLabel() {
        $objectMap.put("beginDateLabel", beginDateLabel = new JLabel());
        
        beginDateLabel.setName("beginDateLabel");
        beginDateLabel.setText(t("lima.date.begin"));
    }

    protected void createBeginDatePicker() {
        $objectMap.put("beginDatePicker", beginDatePicker = new JXDatePicker());
        
        beginDatePicker.setName("beginDatePicker");
    }

    protected void createCancel() {
        $objectMap.put("cancel", cancel = new JButton());
        
        cancel.setName("cancel");
        cancel.setText(t("lima.cancel"));
        cancel.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancel"));
    }

    protected void createEndDateLabel() {
        $objectMap.put("endDateLabel", endDateLabel = new JLabel());
        
        endDateLabel.setName("endDateLabel");
        endDateLabel.setText(t("lima.date.end"));
    }

    protected void createEndDatePicker() {
        $objectMap.put("endDatePicker", endDatePicker = new JXDatePicker());
        
        endDatePicker.setName("endDatePicker");
    }

    protected void createModifyPeriod() {
        $objectMap.put("modifyPeriod", modifyPeriod = false);
    }

    protected void createOk() {
        $objectMap.put("ok", ok = new JButton());
        
        ok.setName("ok");
        ok.setText(t("lima.ok"));
        ok.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__ok"));
    }

    protected void createValidate() {
        $objectMap.put("validate", validate = false);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToPeriodFormDialog();
        // inline complete setup of $Table0
        $Table0.add(beginDateLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(beginDatePicker, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(endDateLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(endDatePicker, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JPanel0
        $JPanel0.add(cancel);
        $JPanel0.add(ok);
        
        // apply 1 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 7 property setters
        setDefaultCloseOperation(JDialog.DO_NOTHING_ON_CLOSE);
        beginDateLabel.setLabelFor(beginDatePicker);
        endDateLabel.setLabelFor(endDatePicker);
        cancel.setIcon(SwingUtil.createActionIcon("cancel"));
        ok.setIcon(SwingUtil.createActionIcon("ok"));
        // late initializer
        periodFormDialog.pack();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("periodFormDialog", periodFormDialog);
        createModifyPeriod();
        createValidate();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createBeginDateLabel();
        createBeginDatePicker();
        createEndDateLabel();
        createEndDatePicker();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1,0));
        createCancel();
        createOk();
        // inline creation of periodFormDialog
        setName("periodFormDialog");
        periodFormDialog.getContentPane().setLayout(new BorderLayout());
        setModal(true);
        setTitle(t("lima.fiscalPeriod.form"));
        periodFormDialog.addWindowListener(JAXXUtil.getEventListener(WindowListener.class, "windowClosing", this, "doWindowClosing__on__periodFormDialog"));
        
        getRootPane().setDefaultButton(ok);// registers 1 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 1 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_BEGIN_DATE_PICKER_ENABLED, true ,"modifyPeriod") {
        
            @Override
            public void processDataBinding() {
                beginDatePicker.setEnabled(!isModifyPeriod());
            }
        });
    }

}