package org.chorem.lima.ui.financialstatementchart;

/*
 * #%L
 * Lima :: Swing
 * %%
 * Copyright (C) 2008 - 2015 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JToolBar.Separator;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.decorator.HighlighterFactory;
import static org.nuiton.i18n.I18n.t;

public class FinancialStatementChartView extends JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_HANDLER = "handler";
    public static final String PROPERTY_SELECTED_ROW = "selectedRow";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ADD_FINANCIAL_STATEMENT_MOVEMENT_ENABLED = "addFinancialStatementMovement.enabled";
    public static final String BINDING_REMOVE_BUTTON_ENABLED = "removeButton.enabled";
    public static final String BINDING_UPDATE_BUTTON_ENABLED = "updateButton.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1Wz28bRRSeuDhp7CTQJjSp2kAAV0qkdlyFA4fwoyTEJMZJUddCFT7Qye4kO+14Z5mdrTeKijhy5E+AOxckbpwQB84cuCD+BYQ4cEW8mbW9tnecpCKWvLZn3vvm+2befM/f/YmKkUSvPSZJgmUcKNamuP7+w4f3Dx5TV31AI1eyUAmJ0tdEARVaqOz1xyOF3mg1dHq1m17dEu1QBDQYyN5ooFKkjjmNfEqVQsvDGW4UVZ3+9EYSxrKH2idlQ/3m778KX3tffltAKAmB3RxIWTkrK1PyQgMVmKfQVVjpKalyEhwBDcmCI+A7q8e2OImifdKmn6Mv0FQDTYZEAphCr59fssEw+Umo0OVK/WMSUH5XoZqQR9j1haRtzFmb4JjhQxaQwGWER4oo2gZE1ydS4Vpv3OmNb+nxTxjthKFBn1RoyieBx6lUaO9ioHdSvGyFckQ5lAX1HoiOQlf0FmG9bXhTCE5JMMBFwcgm4KAFHZXgqAP7iuvNdFhHTfeDbxDPy9PYocTTYuaHADZjpUSgE6/285et+XviqfnUQYvDCTNx6EFUhjU6DxsH2ePnGZy3VGPnFyo9oRWHQs0QKAg48VdsW5FFDGOUXZ+6T8YuMVupO64UnOtyAuzFIexsaninp5WktEkOOFXoo/9fJM0emoa/NSC/wSLlmFphItgTnin4Ifn5CCgeiW4MXV8wBpwZQ3ZzJ1qoKGMYVmiplfeSBzCVusjSiItoQDP777X5337844dazzpKsPbL1tAB54MrHUoRQlEyvfSLqW/EivHqHgk3Wmg6vR/GFm9aiDndaSAH66X3R6fjHRL5AFGc+v2nn689+vUSKtRQiQvi1YiO34WD8yXsguBeEr53zzCa6VyG50uaGxzsIUSr9GCLh3B+NAH5Ny3y+xwOpn/5Z975/l5vCyaA0vWx4dk2FD9FkyzgLKDGP7vWaPXLchjR2BOZBdpMEWVuEXYN5E3zfCsntKBQiZiK2XVFABf/MFeXd8AL7vhd6yhr3CYLmzTRpm2qPJ+C03AMmUmsF94wu6G/vYNOd6ezCF8CbTTQxwJ95soJi5zMQFfXno3IeXWMnHbXyUYFVcYJ6iWMk3S6YV6sqEWLKOqxnJiF1IOMMWOodKncWNnID5n3xXK9buGatgI723TudLaDreR569vGJ209o3yWDJ90bjvRz+4PK6fB9vW8nJYsnEyrGqW0PK46TbSN12DLOwetGZ8d+RzeimrDrZ/sZL9T3zzGrqSwrAOCOdX/7ULoPasB7awY7yUdBX8RuZCr6+vrt7vvNV0Ws9Fgb1Lo1km+YWFnd//DxvZnznZje6u5e3//mU1U1nLPkgQ2PsnJsQD9aO5tqHGycsACDxi/mwOe0M/SORDn+ssbzjruKzvaGqD9Bxu6x+UQDAAA";
    public static final String PROPERTY$LIST_SELECTION_MODEL0 = "$ListSelectionModel0";
    private static final Log log = LogFactory.getLog(FinancialStatementChartView.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton addFinancialStatementHeader;
    protected JButton addFinancialStatementMovement;
    protected JButton checkButton;
    protected FinancialStatementChartViewHandler handler;
    protected JButton importButton;
    protected JButton removeButton;
    protected Boolean selectedRow;
    protected JToolBar toolBar;
    protected FinancialStatementChartTreeTable treeTable;
    protected JButton updateButton;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private FinancialStatementChartView $JPanel0 = this;
    private JScrollPane $JScrollPane0;
    private Separator $JToolBar$Separator0;
    private ListSelectionModel $ListSelectionModel0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public FinancialStatementChartView(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public FinancialStatementChartView(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialStatementChartView() {
        $initialize();
    }

    public FinancialStatementChartView(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialStatementChartView(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public FinancialStatementChartView(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialStatementChartView(boolean param0) {
        super(param0);
        $initialize();
    }

    public FinancialStatementChartView(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__addFinancialStatementHeader(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.addFinancialStatementHeader();
    }

    public void doActionPerformed__on__addFinancialStatementMovement(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.addFinancialStatementMovement();
    }

    public void doActionPerformed__on__checkButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.financialStatementChartCheck();
    }

    public void doActionPerformed__on__importButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.importFinancialStatementChart();
    }

    public void doActionPerformed__on__removeButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.removeFinancialStatement();
    }

    public void doActionPerformed__on__updateButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.updateFinancialStatement();
    }

    public void doValueChanged__on__$ListSelectionModel0(ListSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setSelectedRow(treeTable.getSelectedRow() != -1);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getAddFinancialStatementHeader() {
        return addFinancialStatementHeader;
    }

    public JButton getAddFinancialStatementMovement() {
        return addFinancialStatementMovement;
    }

    public JButton getCheckButton() {
        return checkButton;
    }

    public FinancialStatementChartViewHandler getHandler() {
        return handler;
    }

    public JButton getImportButton() {
        return importButton;
    }

    public JButton getRemoveButton() {
        return removeButton;
    }

    public Boolean getSelectedRow() {
        return selectedRow;
    }

    public JToolBar getToolBar() {
        return toolBar;
    }

    public FinancialStatementChartTreeTable getTreeTable() {
        return treeTable;
    }

    public JButton getUpdateButton() {
        return updateButton;
    }

    public Boolean isSelectedRow() {
        return selectedRow !=null && selectedRow;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void set$ListSelectionModel0(ListSelectionModel $ListSelectionModel0) {
        ListSelectionModel oldValue = this.$ListSelectionModel0;
        this.$ListSelectionModel0 = $ListSelectionModel0;
        firePropertyChange(PROPERTY$LIST_SELECTION_MODEL0, oldValue, $ListSelectionModel0);
    }

    public void setHandler(FinancialStatementChartViewHandler handler) {
        FinancialStatementChartViewHandler oldValue = this.handler;
        this.handler = handler;
        firePropertyChange(PROPERTY_HANDLER, oldValue, handler);
    }

    public void setSelectedRow(Boolean selectedRow) {
        Boolean oldValue = this.selectedRow;
        this.selectedRow = selectedRow;
        firePropertyChange(PROPERTY_SELECTED_ROW, oldValue, selectedRow);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected Separator get$JToolBar$Separator0() {
        return $JToolBar$Separator0;
    }

    protected ListSelectionModel get$ListSelectionModel0() {
        return $ListSelectionModel0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToToolBar() {
        if (!allComponentsCreated) {
            return;
        }
        toolBar.add(addFinancialStatementHeader);
        toolBar.add(addFinancialStatementMovement);
        toolBar.add(updateButton);
        toolBar.add(removeButton);
        toolBar.add(importButton);
        toolBar.add($JToolBar$Separator0);
        toolBar.add(checkButton);
    }

    protected void createAddFinancialStatementHeader() {
        $objectMap.put("addFinancialStatementHeader", addFinancialStatementHeader = new JButton());
        
        addFinancialStatementHeader.setName("addFinancialStatementHeader");
        addFinancialStatementHeader.setToolTipText(t("lima.financialStatement.header.add"));
        addFinancialStatementHeader.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__addFinancialStatementHeader"));
    }

    protected void createAddFinancialStatementMovement() {
        $objectMap.put("addFinancialStatementMovement", addFinancialStatementMovement = new JButton());
        
        addFinancialStatementMovement.setName("addFinancialStatementMovement");
        addFinancialStatementMovement.setToolTipText(t("lima.financialStatement.movement.add"));
        addFinancialStatementMovement.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__addFinancialStatementMovement"));
    }

    protected void createCheckButton() {
        $objectMap.put("checkButton", checkButton = new JButton());
        
        checkButton.setName("checkButton");
        checkButton.setToolTipText(t("lima.financialStatement.check"));
        checkButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__checkButton"));
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new FinancialStatementChartViewHandler(this));
    }

    protected void createImportButton() {
        $objectMap.put("importButton", importButton = new JButton());
        
        importButton.setName("importButton");
        importButton.setToolTipText(t("lima.importExport.import"));
        importButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__importButton"));
    }

    protected void createRemoveButton() {
        $objectMap.put("removeButton", removeButton = new JButton());
        
        removeButton.setName("removeButton");
        removeButton.setToolTipText(t("lima.remove.shortcut"));
        removeButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__removeButton"));
    }

    protected void createSelectedRow() {
        $objectMap.put("selectedRow", selectedRow = false);
    }

    protected void createToolBar() {
        $objectMap.put("toolBar", toolBar = new JToolBar());
        
        toolBar.setName("toolBar");
        toolBar.setFloatable(false);
    }

    protected void createTreeTable() {
        $objectMap.put("treeTable", treeTable = new FinancialStatementChartTreeTable(getHandler()));
        
        treeTable.setName("treeTable");
    }

    protected void createUpdateButton() {
        $objectMap.put("updateButton", updateButton = new JButton());
        
        updateButton.setName("updateButton");
        updateButton.setToolTipText(t("lima.update.shortcut"));
        updateButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__updateButton"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $JPanel0
        add(toolBar, BorderLayout.PAGE_START);
        add($JScrollPane0);
        addChildrenToToolBar();
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(treeTable);
        
        // apply 3 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 10 property setters
        treeTable.setTreeTableModel(new FinancialStatementChartTreeTableModel());
        addFinancialStatementHeader.setIcon(SwingUtil.createActionIcon("financialStatement-add-header"));
        addFinancialStatementMovement.setIcon(SwingUtil.createActionIcon("financialStatement-add-movement"));
        updateButton.setIcon(SwingUtil.createActionIcon("financialStatement-edit"));
        removeButton.setIcon(SwingUtil.createActionIcon("financialStatement-remove"));
        importButton.setIcon(SwingUtil.createActionIcon("financialStatement-import"));
        checkButton.setIcon(SwingUtil.createActionIcon("financialStatement-check"));
        treeTable.setHighlighters(HighlighterFactory.createSimpleStriping(new java.awt.Color(222,222,222)));
        treeTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$JPanel0", $JPanel0);
        createHandler();
        createSelectedRow();
        createToolBar();
        createAddFinancialStatementHeader();
        createAddFinancialStatementMovement();
        createUpdateButton();
        createRemoveButton();
        createImportButton();
        // inline creation of $JToolBar$Separator0
        $objectMap.put("$JToolBar$Separator0", $JToolBar$Separator0 = new Separator());
        
        $JToolBar$Separator0.setName("$JToolBar$Separator0");
        createCheckButton();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createTreeTable();
        // inline creation of $ListSelectionModel0
        $objectMap.put("$ListSelectionModel0", $ListSelectionModel0 = getTreeTable().getSelectionModel());
        
        $ListSelectionModel0.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__$ListSelectionModel0"));
        // inline creation of $JPanel0
        setName("$JPanel0");
        setLayout(new BorderLayout());
        
        // registers 3 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 3 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_ADD_FINANCIAL_STATEMENT_MOVEMENT_ENABLED, true ,"selectedRow") {
        
            @Override
            public void processDataBinding() {
                addFinancialStatementMovement.setEnabled(isSelectedRow());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_UPDATE_BUTTON_ENABLED, true ,"selectedRow") {
        
            @Override
            public void processDataBinding() {
                updateButton.setEnabled(isSelectedRow());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_REMOVE_BUTTON_ENABLED, true ,"selectedRow") {
        
            @Override
            public void processDataBinding() {
                removeButton.setEnabled(isSelectedRow());
            }
        });
    }

}