/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.importexport;

import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.LimaSwingConfig;
import org.chorem.lima.LimaTechnicalException;
import org.chorem.lima.business.ExportResult;
import org.chorem.lima.business.ImportExportResults;
import org.chorem.lima.business.ImportResult;
import org.chorem.lima.business.LimaServiceFactory;
import org.chorem.lima.business.api.ExportService;
import org.chorem.lima.business.api.ImportService;
import org.chorem.lima.business.exceptions.AlreadyExistFinancialStatement;
import org.chorem.lima.business.exceptions.AlreadyExistVatStatementException;
import org.chorem.lima.business.exceptions.BeginAfterEndFiscalPeriodException;
import org.chorem.lima.business.exceptions.ImportFileException;
import org.chorem.lima.business.exceptions.InvalidAccountNumberException;
import org.chorem.lima.business.exceptions.LimaException;
import org.chorem.lima.business.exceptions.LockedEntryBookException;
import org.chorem.lima.business.exceptions.LockedFinancialPeriodException;
import org.chorem.lima.business.exceptions.MoreOneUnlockFiscalPeriodException;
import org.chorem.lima.business.exceptions.NoDataToImportException;
import org.chorem.lima.business.exceptions.NoFiscalPeriodFoundException;
import org.chorem.lima.business.exceptions.NotAllowedLabelException;
import org.chorem.lima.business.exceptions.NotBeginNextDayOfLastFiscalPeriodException;
import org.chorem.lima.business.exceptions.NotNumberAccountNumberException;
import org.chorem.lima.entity.Account;
import org.chorem.lima.entity.Entry;
import org.chorem.lima.entity.EntryBook;
import org.chorem.lima.entity.FinancialStatement;
import org.chorem.lima.entity.FinancialTransaction;
import org.chorem.lima.entity.FiscalPeriod;
import org.chorem.lima.entity.Identity;
import org.chorem.lima.entity.VatStatement;
import org.chorem.lima.enums.EncodingEnum;
import org.chorem.lima.enums.ImportExportEnum;
import org.chorem.lima.ui.importexport.ImportExportWaitView;
import org.chorem.lima.util.ErrorHelper;
import org.jdesktop.swingx.painter.BusyPainter;
import org.nuiton.i18n.I18n;

public class ImportExport {
    private static final Log log = LogFactory.getLog(ImportExport.class);
    public static final int BUFFER_SIZE = 1024;
    protected Component viewComponent;
    protected ImportService importService;
    protected ExportService exportService;
    private ImportExportWaitView waitView;
    protected ErrorHelper errorHelper;
    public static final String JAVA_IO_TMPDIR = System.getProperty("java.io.tmpdir") + "/";

    public ImportExport(Component view) {
        this.viewComponent = view;
        this.importService = (ImportService)LimaServiceFactory.getService(ImportService.class);
        this.exportService = (ExportService)LimaServiceFactory.getService(ExportService.class);
        this.errorHelper = new ErrorHelper(LimaSwingConfig.getInstance());
        this.waitView = new ImportExportWaitView();
        this.waitView.setLocationRelativeTo(view);
        BusyPainter busyPainter = this.waitView.getBusylabel().getBusyPainter();
        busyPainter.setHighlightColor(new Color(44, 61, 146).darker());
        busyPainter.setBaseColor(new Color(168, 204, 241).brighter());
    }

    public void importExport(ImportExportEnum importExportChoice, String exportPath, URL importUrl, boolean verbose) {
        Charset defaultCharset = Charsets.UTF_8;
        if (Strings.isNullOrEmpty((String)exportPath) && importUrl == null) {
            exportPath = this.chooseFile(importExportChoice.getImportMode(), importExportChoice);
            File file = new File(exportPath);
            if (file.exists()) {
                try {
                    importUrl = file.toURI().toURL();
                }
                catch (MalformedURLException e) {
                    throw new LimaTechnicalException("Can't open file " + exportPath);
                }
            } else {
                throw new LimaTechnicalException("Can't open file from path" + exportPath);
            }
        }
        this.processImportExport(verbose, importExportChoice, defaultCharset, exportPath, importUrl);
    }

    public void processImportExport(ImportExportEnum importExportChoice, boolean verbose) {
        switch (importExportChoice) {
            case CSV_ALL_EXPORT: 
            case CSV_ACCOUNTCHARTS_EXPORT: 
            case CSV_ENTRYBOOKS_EXPORT: 
            case CSV_ENTRIES_EXPORT: 
            case CSV_FINANCIALSTATEMENTS_EXPORT: 
            case CSV_VAT_EXPORT: 
            case PDF_VAT_EXPORT: 
            case EBP_ACCOUNTCHARTS_EXPORT: 
            case EBP_ENTRIES_EXPORT: 
            case EBP_ENTRYBOOKS_EXPORT: {
                this.processExport(importExportChoice, verbose);
                break;
            }
            case CSV_ALL_IMPORT: 
            case CSV_ACCOUNTCHARTS_IMPORT: 
            case CSV_ENTRYBOOKS_IMPORT: 
            case CSV_ENTRIES_IMPORT: 
            case CSV_FINANCIALSTATEMENTS_IMPORT: 
            case CSV_VAT_IMPORT: 
            case PDF_VAT_IMPORT: 
            case EBP_ACCOUNTCHARTS_IMPORT: 
            case EBP_ENTRIES_IMPORT: 
            case EBP_ENTRYBOOKS_IMPORT: {
                this.processImport(importExportChoice, verbose);
            }
        }
    }

    protected void processImport(ImportExportEnum importExportChoice, boolean verbose) {
        URL importFileUrl;
        Charset defaultCharset = Charsets.UTF_8;
        String importFilePath = this.chooseFile(importExportChoice.getImportMode(), importExportChoice);
        File file = new File(importFilePath);
        if (file.exists()) {
            try {
                importFileUrl = file.toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new LimaTechnicalException("Can't open file " + importFilePath);
            }
        } else {
            throw new LimaTechnicalException("Can't open file from path" + importFilePath);
        }
        log.info((Object)("Precessing import:" + importFileUrl.getPath() + " " + importFilePath + " " + importFileUrl.getFile()));
        this.processImportExport(verbose, importExportChoice, defaultCharset, null, importFileUrl);
    }

    protected void processExport(ImportExportEnum importExportChoice, boolean verbose) {
        String exportFilePath = this.chooseFile(importExportChoice.getImportMode(), importExportChoice);
        if (!StringUtils.isNotBlank((CharSequence)exportFilePath)) {
            throw new LimaTechnicalException("Targeted directory can not be found.");
        }
        log.info((Object)("Precessing export:" + exportFilePath));
        this.processImportExport(verbose, importExportChoice, Charsets.UTF_8, exportFilePath, null);
    }

    protected void processImportExport(final boolean verboseMode, final ImportExportEnum importExportMethod, final Charset defaultCharset, final String exportFilePath, final URL importURL) {
        final Boolean importMode = importExportMethod.getImportMode();
        new SwingWorker<ImportExportResults, Void>(){

            @Override
            protected ImportExportResults doInBackground() {
                ImportExportResults results = new ImportExportResults();
                switch (importExportMethod) {
                    case CSV_ACCOUNTCHARTS_IMPORT: {
                        String content = ImportExport.this.loadContent(importURL, defaultCharset.name());
                        results.pushImportResults(ImportExport.this.importService.importAccountAsCSV(content));
                        break;
                    }
                    case CSV_ENTRYBOOKS_IMPORT: {
                        String content = ImportExport.this.loadContent(importURL, defaultCharset.name());
                        results.pushImportResults(ImportExport.this.importService.importEntryBooksAsCSV(content));
                        break;
                    }
                    case CSV_ENTRIES_IMPORT: {
                        String content = ImportExport.this.loadContent(importURL, defaultCharset.name());
                        results.pushImportResults(ImportExport.this.importService.importEntriesAsCSV(content));
                        break;
                    }
                    case CSV_VAT_IMPORT: {
                        String content = ImportExport.this.loadContent(importURL, defaultCharset.name());
                        results.pushImportResults(ImportExport.this.importService.importVATStatementsAsCSV(content));
                        break;
                    }
                    case CSV_FINANCIALSTATEMENTS_IMPORT: {
                        String content = ImportExport.this.loadContent(importURL, defaultCharset.name());
                        results.pushImportResults(ImportExport.this.importService.importFinancialStatementsAsCSV(content));
                        break;
                    }
                    case CSV_ACCOUNTCHARTS_EXPORT: {
                        results.pushExportResults(ImportExport.this.exportService.exportAccountsAsCSV(defaultCharset.name()));
                        ImportExport.this.createFile(exportFilePath, defaultCharset.name(), ((ExportResult)results.getExportResults().get(0)).getExportData());
                        break;
                    }
                    case CSV_ENTRYBOOKS_EXPORT: {
                        results.pushExportResults(ImportExport.this.exportService.exportEntryBooksAsCSV(defaultCharset.name()));
                        ImportExport.this.createFile(exportFilePath, defaultCharset.name(), ((ExportResult)results.getExportResults().get(0)).getExportData());
                        break;
                    }
                    case CSV_ENTRIES_EXPORT: {
                        results.pushExportResults(ImportExport.this.exportService.exportEntriesAsCSV(defaultCharset.name(), Boolean.valueOf(true)));
                        ImportExport.this.createFile(exportFilePath, defaultCharset.name(), ((ExportResult)results.getExportResults().get(0)).getExportData());
                        break;
                    }
                    case CSV_ALL_EXPORT: {
                        results = ImportExport.this.exportBackup(exportFilePath, defaultCharset.name());
                        break;
                    }
                    case CSV_ALL_IMPORT: {
                        results = ImportExport.this.importAllFromZipFile(importURL);
                        break;
                    }
                    case CSV_VAT_EXPORT: {
                        results.pushExportResults(ImportExport.this.exportService.exportVatStatements(defaultCharset.name()));
                        ImportExport.this.createFile(exportFilePath, defaultCharset.name(), ((ExportResult)results.getExportResults().get(0)).getExportData());
                        break;
                    }
                    case CSV_FINANCIALSTATEMENTS_EXPORT: {
                        results.pushExportResults(ImportExport.this.exportService.exportFinancialStatements(defaultCharset.name()));
                        ImportExport.this.createFile(exportFilePath, defaultCharset.name(), ((ExportResult)results.getExportResults().get(0)).getExportData());
                        break;
                    }
                    case EBP_ACCOUNTCHARTS_IMPORT: {
                        String content = ImportExport.this.loadContent(importURL, EncodingEnum.ISOLATIN1.getEncoding());
                        results.pushImportResults(ImportExport.this.importService.importAccountFromEbp(content));
                        break;
                    }
                    case EBP_ENTRYBOOKS_IMPORT: {
                        String content = ImportExport.this.loadContent(importURL, EncodingEnum.ISOLATIN1.getEncoding());
                        results.pushImportResults(ImportExport.this.importService.importEntryBookFromEbp(content));
                        break;
                    }
                    case EBP_ENTRIES_IMPORT: {
                        String content = ImportExport.this.loadContent(importURL, EncodingEnum.ISOLATIN1.getEncoding());
                        results.pushImportResults(ImportExport.this.importService.importEntriesFromEbp(content));
                        break;
                    }
                    case EBP_ACCOUNTCHARTS_EXPORT: {
                        results.pushExportResults(ImportExport.this.exportService.exportAccountAsEbp(defaultCharset.name()));
                        ImportExport.this.createFile(exportFilePath, EncodingEnum.ISOLATIN1.getEncoding(), ((ExportResult)results.getExportResults().get(0)).getExportData());
                        break;
                    }
                    case EBP_ENTRYBOOKS_EXPORT: {
                        results.pushExportResults(ImportExport.this.exportService.exportEntryBookAsEbp(defaultCharset.name()));
                        ImportExport.this.createFile(exportFilePath, EncodingEnum.ISOLATIN1.getEncoding(), ((ExportResult)results.getExportResults().get(0)).getExportData());
                        break;
                    }
                    case EBP_ENTRIES_EXPORT: {
                        results.pushExportResults(ImportExport.this.exportService.exportEntriesAsEbp(defaultCharset.name()));
                        ImportExport.this.createFile(exportFilePath, EncodingEnum.ISOLATIN1.getEncoding(), ((ExportResult)results.getExportResults().get(0)).getExportData());
                        break;
                    }
                }
                return results;
            }

            @Override
            protected void done() {
                block10: {
                    try {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("importMode : " + importMode));
                        }
                        ImportExport.this.waitView.setVisible(false);
                        if (verboseMode) {
                            ImportExportResults globalResult = (ImportExportResults)this.get();
                            if (importMode.booleanValue() && globalResult == null) {
                                JOptionPane.showMessageDialog(ImportExport.this.viewComponent, I18n.t((String)"lima.import.error", (Object[])new Object[0]), I18n.t((String)"lima.import.title", (Object[])new Object[0]), 0);
                            } else if (importMode.booleanValue()) {
                                List importResults = globalResult.getImportResults();
                                if (importResults != null) {
                                    ImportExport.this.ComputeImportResultMessage(importResults);
                                }
                            } else {
                                List exportResults = globalResult.getExportResults();
                                if (exportResults != null) {
                                    ImportExport.this.ComputeExportResultMessage(exportResults);
                                }
                            }
                        }
                    }
                    catch (InterruptedException | ExecutionException ex) {
                        if (!log.isErrorEnabled()) break block10;
                        log.error((Object)"Can't get result message", (Throwable)ex);
                    }
                }
            }
        }.execute();
        this.waitView.setVisible(true);
    }

    protected void ComputeExportResultMessage(List<ExportResult> exportResults) {
        StringBuilder message = new StringBuilder();
        for (ExportResult result : exportResults) {
            Class fromSource = result.getFromSource();
            String messageFromSource = this.getFromSourceMessage(fromSource);
            message.append("Export ");
            message.append(messageFromSource);
            List exportExceptions = result.getExportExceptions();
            if (exportExceptions == null || exportExceptions.isEmpty()) continue;
            message.append(I18n.t((String)"lima.export.exceptions", (Object[])new Object[0]) + "\n");
        }
        this.DisplayImportExportResultMessage(message, false);
    }

    protected void ComputeImportResultMessage(List<ImportResult> resultList) {
        StringBuilder message = new StringBuilder();
        message.append(I18n.t((String)"lima.import.terminated", (Object[])new Object[0]) + "\n");
        StringBuilder errorMessage = null;
        for (ImportResult result : resultList) {
            Class fromSource = result.getFromSource();
            message.append("Import ");
            message.append(this.getFromSourceMessage(fromSource));
            message.append(I18n.t((String)"lima.import.report", (Object[])new Object[]{result.getNbCreated(), result.getNbUpdated(), result.getNbIgnored()}) + "\n");
            Map exceptionsByLine = result.getAllExceptionsByLine();
            errorMessage = this.displayErrorMessage(exceptionsByLine);
            if (errorMessage == null) break;
            message.append(errorMessage.toString());
        }
        if (errorMessage != null) {
            this.DisplayImportExportResultMessage(message, true);
        }
    }

    protected void DisplayImportExportResultMessage(StringBuilder message, Boolean importMode) {
        if (log.isDebugEnabled()) {
            log.debug((Object)message.toString());
        }
        String title = importMode != false ? I18n.t((String)"lima.import.terminated", (Object[])new Object[0]) : I18n.t((String)"lima.export.terminated", (Object[])new Object[0]);
        JOptionPane.showMessageDialog(this.waitView, message.toString(), title, 1);
    }

    protected StringBuilder displayErrorMessage(Map<Integer, LimaException> exceptionsByLine) {
        StringBuilder result = new StringBuilder();
        if (exceptionsByLine != null) {
            for (Map.Entry<Integer, LimaException> e : exceptionsByLine.entrySet()) {
                result.append(I18n.t((String)"lima.import.line", (Object[])new Object[]{e.getKey()}) + "\n");
                LimaException importException = e.getValue();
                if (importException instanceof InvalidAccountNumberException) {
                    result.append(I18n.t((String)"lima.account.error.invalidAccountNumber", (Object[])new Object[]{((InvalidAccountNumberException)((Object)importException)).getAccountNumber()}) + "\n");
                } else if (importException instanceof NotNumberAccountNumberException) {
                    result.append(I18n.t((String)"lima.account.error.notNumberAccountNumber", (Object[])new Object[]{((NotNumberAccountNumberException)((Object)importException)).getAccountNumber()}) + "\n");
                } else if (importException instanceof NotAllowedLabelException) {
                    result.append(I18n.t((String)"lima.error.notAllowedLabel", (Object[])new Object[]{((NotAllowedLabelException)((Object)importException)).getLabel()}) + "\n");
                } else if (importException instanceof MoreOneUnlockFiscalPeriodException) {
                    result.append(I18n.t((String)"lima.fiscalPeriod.error.moreOneUnlockFiscalPeriod", (Object[])new Object[]{((MoreOneUnlockFiscalPeriodException)((Object)importException)).getBeginDate(), ((MoreOneUnlockFiscalPeriodException)((Object)importException)).getEndDate()}) + "\n");
                } else if (importException instanceof BeginAfterEndFiscalPeriodException) {
                    result.append(I18n.t((String)"lima.fiscalPeriod.error.beginAfterEndFiscalPeriod", (Object[])new Object[]{((BeginAfterEndFiscalPeriodException)((Object)importException)).getFiscalPeriod().getBeginDate(), ((BeginAfterEndFiscalPeriodException)((Object)importException)).getFiscalPeriod().getEndDate()}) + "\n");
                } else if (importException instanceof NotBeginNextDayOfLastFiscalPeriodException) {
                    result.append(I18n.t((String)"lima.fiscalPeriod.error.notBeginNextDayOfLastFiscalPeriod", (Object[])new Object[]{((NotBeginNextDayOfLastFiscalPeriodException)((Object)importException)).getFiscalPeriod().getBeginDate(), ((NotBeginNextDayOfLastFiscalPeriodException)((Object)importException)).getFiscalPeriod().getEndDate()}) + "\n");
                } else if (importException instanceof LockedFinancialPeriodException) {
                    result.append(I18n.t((String)"lima.fiscalPeriod.error.lockedFinancialPeriod", (Object[])new Object[0]) + "\n");
                } else if (importException instanceof LockedEntryBookException) {
                    result.append(I18n.t((String)"lima.entryBook.error.lockedEntryBook", (Object[])new Object[]{((LockedEntryBookException)importException).getClosedPeriodicEntryBook().getFinancialPeriod().getBeginDate(), ((LockedEntryBookException)importException).getClosedPeriodicEntryBook().getFinancialPeriod().getEndDate()}) + "\n");
                } else if (importException instanceof AlreadyExistFinancialStatement) {
                    result.append(I18n.t((String)"lima.financialStatement.error.alreadyExistFinancialStatement", (Object[])new Object[]{((AlreadyExistFinancialStatement)((Object)importException)).getFinancialStatementLabel()}) + "\n");
                } else if (importException instanceof AlreadyExistVatStatementException) {
                    result.append(I18n.t((String)"lima.vatStatement.error.alreadyExistVatStatement", (Object[])new Object[]{((AlreadyExistVatStatementException)((Object)importException)).getVatStatementLabel()}) + "\n");
                } else if (importException instanceof NoFiscalPeriodFoundException) {
                    result.append(I18n.t((String)"lima.error.noFiscalPeriodFound", (Object[])new Object[0]) + "\n");
                } else {
                    if (importException instanceof NoDataToImportException) {
                        this.errorHelper.showErrorMessage(I18n.t((String)"lima.import.error.noDataToImport", (Object[])new Object[0]));
                        log.warn((Object)I18n.t((String)"lima.import.error.noDataToImport", (Object[])new Object[0]));
                        result = null;
                        break;
                    }
                    if (importException instanceof ImportFileException) {
                        this.errorHelper.showErrorMessage(((ImportFileException)importException).getDetailMessage());
                        log.warn((Object)((ImportFileException)importException).getDetailMessage());
                        result = null;
                        break;
                    }
                    result.append(I18n.t((String)"lima.import.error.unknown", (Object[])new Object[0]) + "\n");
                }
                try {
                    throw importException;
                }
                catch (LimaException ex) {
                    log.error((Object)ex);
                }
            }
        }
        return result;
    }

    protected String getFromSourceMessage(Class fromSource) {
        String message;
        if (fromSource == null) {
            message = "BACKUP\n";
        } else if (fromSource.equals(Account.class)) {
            message = I18n.t((String)"lima.importExport.account", (Object[])new Object[0]) + "\n";
        } else if (fromSource.equals(EntryBook.class)) {
            message = I18n.t((String)"lima.importExport.entryBook", (Object[])new Object[0]) + "\n";
        } else if (fromSource.equals(Entry.class)) {
            message = I18n.t((String)"lima.importExport.entry", (Object[])new Object[0]) + "\n";
        } else if (fromSource.equals(FinancialStatement.class)) {
            message = I18n.t((String)"lima.importExport.financialStatement", (Object[])new Object[0]) + "\n";
        } else if (fromSource.equals(FinancialTransaction.class)) {
            message = I18n.t((String)"lima.importExport.financialTransaction", (Object[])new Object[0]) + "\n";
        } else if (fromSource.equals(FiscalPeriod.class)) {
            message = I18n.t((String)"lima.importExport.fiscalPeriod", (Object[])new Object[0]) + "\n";
        } else if (fromSource.equals(Identity.class)) {
            message = I18n.t((String)"lima.importExport.identity", (Object[])new Object[0]) + "\n";
        } else if (fromSource.equals(VatStatement.class)) {
            message = I18n.t((String)"lima.importExport.vatStatement", (Object[])new Object[0]) + "\n";
        } else {
            throw new LimaTechnicalException("Source not know");
        }
        return message;
    }

    public String chooseFile(Boolean importMode, ImportExportEnum importExportMethod) {
        String approveButtonText;
        String filePath = "";
        JFileChooser chooser = new JFileChooser();
        JComboBox<String> comboBox = new JComboBox<String>(EncodingEnum.descriptions());
        if (importExportMethod.getEncodingOption().booleanValue()) {
            JPanel panel = new JPanel();
            panel.setLayout(new BorderLayout());
            panel.add((Component)new JLabel(I18n.t((String)"lima.importExport.encoding.choice", (Object[])new Object[0])), "West");
            panel.add(comboBox, "Center");
            ((Container)chooser.getComponent(2)).add((Component)panel, "South");
        }
        if (importMode.booleanValue()) {
            chooser.setFileSelectionMode(0);
            approveButtonText = I18n.t((String)"lima.importExport.import", (Object[])new Object[0]);
            chooser.setDialogTitle(approveButtonText);
            chooser.setApproveButtonText(approveButtonText);
        } else if (importExportMethod.equals((Object)ImportExportEnum.CSV_ALL_EXPORT)) {
            approveButtonText = I18n.t((String)"lima.importExport.export", (Object[])new Object[0]);
            chooser.setFileSelectionMode(1);
            chooser.setDialogTitle(approveButtonText);
            chooser.setApproveButtonText(approveButtonText);
        } else {
            approveButtonText = I18n.t((String)"lima.importExport.export", (Object[])new Object[0]);
            chooser.setFileSelectionMode(0);
            chooser.setDialogTitle(approveButtonText);
            chooser.setApproveButtonText(approveButtonText);
        }
        if (chooser.showOpenDialog(this.viewComponent) == 0) {
            filePath = chooser.getSelectedFile().getAbsolutePath();
        }
        return filePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File createFile(String filePath, String charset, String data) {
        File file = new File(filePath);
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), charset));
            out.write(data);
            out.flush();
            out.close();
            IOUtils.closeQuietly((Writer)out);
        }
        catch (IOException eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)("Can't write file " + filePath), (Throwable)eee);
            }
        }
        finally {
            IOUtils.closeQuietly(out);
        }
        return file;
    }

    @Deprecated
    protected String loadContent(URL url, String charset) {
        String result;
        block16: {
            result = null;
            if (url != null) {
                try (InputStream inputStream = url.openStream();){
                    result = IOUtils.toString((InputStream)inputStream, (String)charset);
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Loading " + url.getPath()));
                    }
                }
                catch (IOException e) {
                    if (!log.isErrorEnabled()) break block16;
                    log.error((Object)("Can't read file " + url.getPath()), (Throwable)e);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ImportExportResults exportBackup(String path, String charset) {
        ImportExportResults streamData;
        block9: {
            streamData = this.exportService.exportBackup(charset);
            ZipOutputStream export = null;
            FileOutputStream result = null;
            try {
                ExportResult exportedData;
                SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
                result = new FileOutputStream(path + "/LIMA-BACKUP-" + dateFormat.format(new Date()));
                export = new ZipOutputStream(result);
                Iterator i$ = streamData.getExportResults().iterator();
                while (i$.hasNext() && (exportedData = (ExportResult)i$.next()) != null && StringUtils.isNotBlank((CharSequence)exportedData.getExportData())) {
                    String data = exportedData.getExportData();
                    File file = this.createFile(JAVA_IO_TMPDIR + exportedData.getFromSource().getSimpleName(), charset, data);
                    if (file == null) continue;
                    FileInputStream stream = null;
                    try {
                        int len;
                        ZipEntry ze = new ZipEntry(file.getName());
                        export.putNextEntry(ze);
                        byte[] buffer = new byte[1024];
                        stream = new FileInputStream(file);
                        while ((len = stream.read(buffer)) > 0) {
                            export.write(buffer, 0, len);
                        }
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(stream);
                        FileUtils.forceDelete((File)file);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((InputStream)stream);
                    FileUtils.forceDelete((File)file);
                }
                export.flush();
                IOUtils.closeQuietly((OutputStream)export);
            }
            catch (IOException e) {
                this.errorHelper.showErrorMessage(I18n.t((String)"lima.export.failed", (Object[])new Object[0]));
                log.error((Object)I18n.t((String)"lima.export.failed", (Object[])new Object[0]), (Throwable)e);
                break block9;
            }
            finally {
                IOUtils.closeQuietly(export);
                IOUtils.closeQuietly(result);
            }
            IOUtils.closeQuietly((OutputStream)result);
        }
        return streamData;
    }

    protected ImportExportResults importAllFromZipFile(URL url) {
        String tmpDir = System.getProperty("java.io.tmpdir") + "/";
        String determinant = String.valueOf(new Date().getTime());
        ImportResult result = this.extractZipFile(url, tmpDir, determinant);
        ImportExportResults results = this.processBackup(result, tmpDir, determinant);
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ImportResult extractZipFile(URL url, String tmpDir, String determinant) {
        results = new ImportExportResults();
        result = results.createAddAndGetImportResult(null);
        zipInputStream = null;
        inputStream = null;
        try {
            inputStream = url.openStream();
            zipInputStream = new ZipInputStream(inputStream);
            while ((entry = zipInputStream.getNextEntry()) != null) {
                fileoutputstream = null;
                try {
                    buffer = new byte[1024];
                    targetFileName = tmpDir + entry.getName() + "-" + determinant + ".csv";
                    fileoutputstream = new FileOutputStream(targetFileName);
                    while ((n = zipInputStream.read(buffer, 0, 1024)) > -1) {
                        fileoutputstream.write(buffer, 0, n);
                    }
                    zipInputStream.closeEntry();
                }
                catch (Throwable var13_14) {
                    IOUtils.closeQuietly(fileoutputstream);
                    throw var13_14;
                }
                IOUtils.closeQuietly((OutputStream)fileoutputstream);
            }
            ** GOTO lbl35
        }
        catch (Exception e) {
            try {
                result.addInitException((LimaException)new ImportFileException(I18n.t((String)"lima.import.error.extractFile", (Object[])new Object[]{e})));
                ImportExport.log.error((Object)e.getStackTrace());
                e.printStackTrace();
            }
            catch (Throwable var14_15) {
                IOUtils.closeQuietly(zipInputStream);
                IOUtils.closeQuietly((InputStream)inputStream);
                throw var14_15;
            }
lbl35:
            // 1 sources

            IOUtils.closeQuietly((InputStream)zipInputStream);
            IOUtils.closeQuietly((InputStream)inputStream);
            return result;
            IOUtils.closeQuietly((InputStream)zipInputStream);
            IOUtils.closeQuietly((InputStream)inputStream);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ImportExportResults processBackup(ImportResult result, String tmpDir, String determinant) {
        ImportExportResults results;
        block7: {
            results = null;
            FileInputStream entryBooksStream = null;
            FileInputStream transactionsStream = null;
            FileInputStream fiscalPeriodsStream = null;
            FileInputStream accountsStream = null;
            FileInputStream entriesStream = null;
            FileInputStream identityStream = null;
            if (result.getAllExceptionsByLine() == null || result.getAllExceptionsByLine().isEmpty()) {
                try {
                    entryBooksStream = new FileInputStream(tmpDir + EntryBook.class.getSimpleName() + "-" + determinant + ".csv");
                    String entryBooksStreamString = IOUtils.toString((InputStream)entryBooksStream);
                    IOUtils.closeQuietly((InputStream)entryBooksStream);
                    transactionsStream = new FileInputStream(tmpDir + FinancialTransaction.class.getSimpleName() + "-" + determinant + ".csv");
                    String transactionsStreamString = IOUtils.toString((InputStream)transactionsStream);
                    IOUtils.closeQuietly((InputStream)transactionsStream);
                    accountsStream = new FileInputStream(tmpDir + Account.class.getSimpleName() + "-" + determinant + ".csv");
                    String accountsStreamString = IOUtils.toString((InputStream)accountsStream);
                    IOUtils.closeQuietly((InputStream)accountsStream);
                    entriesStream = new FileInputStream(tmpDir + Entry.class.getSimpleName() + "-" + determinant + ".csv");
                    String entriesStreamString = IOUtils.toString((InputStream)entriesStream);
                    IOUtils.closeQuietly((InputStream)entriesStream);
                    fiscalPeriodsStream = new FileInputStream(tmpDir + FiscalPeriod.class.getSimpleName() + "-" + determinant + ".csv");
                    String fiscalPeriodsStreamString = IOUtils.toString((InputStream)fiscalPeriodsStream);
                    IOUtils.closeQuietly((InputStream)fiscalPeriodsStream);
                    identityStream = new FileInputStream(tmpDir + Identity.class.getSimpleName() + "-" + determinant + ".csv");
                    String identityStreamString = IOUtils.toString((InputStream)identityStream);
                    IOUtils.closeQuietly((InputStream)identityStream);
                    results = this.importService.importBackup(entryBooksStreamString, transactionsStreamString, fiscalPeriodsStreamString, accountsStreamString, entriesStreamString, identityStreamString);
                    IOUtils.closeQuietly((InputStream)entryBooksStream);
                }
                catch (Exception ex) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)ex);
                    }
                    result.addInitException((LimaException)new ImportFileException(I18n.t((String)"lima.import.error.extractFile", (Object[])new Object[0])));
                    break block7;
                }
                finally {
                    IOUtils.closeQuietly(entryBooksStream);
                    IOUtils.closeQuietly(transactionsStream);
                    IOUtils.closeQuietly(fiscalPeriodsStream);
                    IOUtils.closeQuietly(accountsStream);
                    IOUtils.closeQuietly(entriesStream);
                    IOUtils.closeQuietly(identityStream);
                }
                IOUtils.closeQuietly((InputStream)transactionsStream);
                IOUtils.closeQuietly((InputStream)fiscalPeriodsStream);
                IOUtils.closeQuietly((InputStream)accountsStream);
                IOUtils.closeQuietly((InputStream)entriesStream);
                IOUtils.closeQuietly((InputStream)identityStream);
            }
        }
        return results;
    }
}

