/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.vatreports;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.beans.VatStatementAmounts;
import org.chorem.lima.business.ServiceListener;
import org.chorem.lima.business.api.FinancialTransactionService;
import org.chorem.lima.business.api.ImportService;
import org.chorem.lima.business.api.VatStatementService;
import org.chorem.lima.service.LimaServiceFactory;
import org.nuiton.i18n.I18n;

public class VatReportTableModel
extends AbstractTableModel
implements ServiceListener {
    private static final long serialVersionUID = -6301817853711018389L;
    private static final Log log = LogFactory.getLog(VatReportTableModel.class);
    protected VatStatementService vatStatementService = (VatStatementService)LimaServiceFactory.getService(VatStatementService.class);
    protected Date selectedBeginDate;
    protected Date selectedEndDate;
    protected List<VatStatementAmounts> cacheDataList;

    public VatReportTableModel() {
        LimaServiceFactory.addServiceListener(VatStatementService.class, (ServiceListener)this);
        LimaServiceFactory.addServiceListener(FinancialTransactionService.class, (ServiceListener)this);
        LimaServiceFactory.addServiceListener(ImportService.class, (ServiceListener)this);
    }

    protected List<VatStatementAmounts> getDataList() {
        List list = null;
        if (this.selectedBeginDate != null || this.selectedEndDate != null) {
            list = this.vatStatementService.vatStatementReport(this.getBeginDate(), this.getEndDate());
        }
        return list;
    }

    public void refresh() {
        this.cacheDataList = this.getDataList();
        this.fireTableDataChanged();
    }

    @Override
    public Class<?> getColumnClass(int column) {
        Class result = null;
        switch (column) {
            case 0: {
                result = String.class;
                break;
            }
            case 1: {
                result = BigDecimal.class;
            }
        }
        return result;
    }

    @Override
    public String getColumnName(int column) {
        String result = "n/a";
        switch (column) {
            case 0: {
                result = I18n._((String)"lima.table.label", (Object[])new Object[0]);
                break;
            }
            case 1: {
                result = I18n._((String)"lima.table.solde", (Object[])new Object[0]);
            }
        }
        return result;
    }

    @Override
    public int getRowCount() {
        int result = 0;
        if (this.cacheDataList != null) {
            result = this.cacheDataList.size();
        }
        return result;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    public VatStatementAmounts getElementAt(int row) {
        VatStatementAmounts currentRow = this.cacheDataList.get(row);
        return currentRow;
    }

    @Override
    public Object getValueAt(int row, int column) {
        Object result = null;
        if (this.cacheDataList != null) {
            VatStatementAmounts value = this.cacheDataList.get(row);
            switch (column) {
                case 0: {
                    result = value.getLabel();
                    break;
                }
                case 1: {
                    result = value.getAmount() != null && !value.isHeader() ? value.getAmount() : null;
                }
            }
        }
        return result;
    }

    public void setBeginDate(Date date) {
        this.selectedBeginDate = date;
    }

    public Date getBeginDate() {
        return this.selectedBeginDate;
    }

    public void setEndDate(Date date) {
        this.selectedEndDate = date;
    }

    public Date getEndDate() {
        return this.selectedEndDate;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    public void notifyMethod(String serviceName, String methodeName) {
        if (serviceName.contains("FinancialTransaction") || methodeName.contains("VatStatement") || methodeName.contains("import")) {
            this.refresh();
        }
    }
}

