/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.financialtransactionunbalanced;

import java.util.List;
import org.chorem.lima.entity.FiscalPeriod;
import org.chorem.lima.ui.financialtransaction.AccountColumn;
import org.chorem.lima.ui.financialtransaction.CreditColumn;
import org.chorem.lima.ui.financialtransaction.DateColumn;
import org.chorem.lima.ui.financialtransaction.DebitColumn;
import org.chorem.lima.ui.financialtransaction.DescriptionColumn;
import org.chorem.lima.ui.financialtransaction.EntryBookColumn;
import org.chorem.lima.ui.financialtransaction.FinancialTransactionTableModel;
import org.chorem.lima.ui.financialtransaction.LetterColumn;
import org.chorem.lima.ui.financialtransaction.VoucherColumn;

public class FinancialTransactionUnbalancedTableModel
extends FinancialTransactionTableModel {
    private static final long serialVersionUID = 3914954536809622358L;
    protected FiscalPeriod selectedFiscalPeriod;

    @Override
    protected void initColumns() {
        this.columns.add(new DateColumn(this));
        this.columns.add(new EntryBookColumn(this));
        this.columns.add(new VoucherColumn(this));
        this.columns.add(new AccountColumn(this));
        this.columns.add(new DescriptionColumn(this));
        this.columns.add(new DebitColumn(this));
        this.columns.add(new CreditColumn(this));
        this.columns.add(new LetterColumn(this));
    }

    protected void refresh() {
        this.transactions.clear();
        if (this.selectedFiscalPeriod != null) {
            List financialTransactions = this.financialTransactionService.getAllInexactFinancialTransactions(this.selectedFiscalPeriod);
            this.transactions.addAll(financialTransactions);
            this.sortEntries();
        }
    }

    public void setFiscalPeriod(FiscalPeriod fiscalPeriod) {
        this.selectedFiscalPeriod = fiscalPeriod;
    }
}

