/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.financialtransactionunbalanced;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.chorem.lima.ui.common.CellRouteHorizontalAction;
import org.chorem.lima.ui.common.CellRouteVerticalAction;
import org.chorem.lima.ui.common.Column;
import org.chorem.lima.ui.financialtransaction.FinancialTransactionTableModel;
import org.chorem.lima.ui.financialtransactionunbalanced.FinancialTransactionUnbalancedViewHandler;
import org.jdesktop.swingx.decorator.ColorHighlighter;
import org.jdesktop.swingx.decorator.Highlighter;

public class FinancialTransactionUnbalancedTable
extends JTable {
    private static final long serialVersionUID = 3133690382049594727L;
    protected final FinancialTransactionUnbalancedViewHandler handler;
    private Highlighter colorTransaction;
    private ColorHighlighter colorBalance;

    public FinancialTransactionUnbalancedTable(final FinancialTransactionUnbalancedViewHandler handler) {
        this.handler = handler;
        this.setShowHorizontalLines(true);
        this.setShowVerticalLines(true);
        this.setGridColor(new Color(210, 210, 210));
        InputMap inputMap = this.getInputMap(1);
        ActionMap actionMap = this.getActionMap();
        Object binding = inputMap.get(KeyStroke.getKeyStroke(9, 0));
        actionMap.put(binding, new CellRouteHorizontalAction(this, true));
        binding = inputMap.get(KeyStroke.getKeyStroke(9, 64));
        actionMap.put(binding, new CellRouteHorizontalAction(this, false));
        binding = inputMap.get(KeyStroke.getKeyStroke(10, 0));
        actionMap.put(binding, new CellRouteVerticalAction(this, true));
        binding = inputMap.get(KeyStroke.getKeyStroke(10, 64));
        actionMap.put(binding, new CellRouteVerticalAction(this, false));
        binding = "delete-transaction";
        inputMap.put(KeyStroke.getKeyStroke(127, 192), binding);
        actionMap.put(binding, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                handler.deleteSelectedTransaction();
            }
        });
        binding = "new-entry";
        inputMap.put(KeyStroke.getKeyStroke(78, 128), binding);
        actionMap.put(binding, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                handler.addEntry();
            }
        });
        binding = "delete-entry";
        inputMap.put(KeyStroke.getKeyStroke(127, 128), binding);
        actionMap.put(binding, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                handler.deleteSelectedEntry();
            }
        });
        binding = "balance";
        inputMap.put(KeyStroke.getKeyStroke(66, 128), binding);
        actionMap.put(binding, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                handler.balanceTransaction();
            }
        });
        this.addMouseListener(new MyMouseAdapter());
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        FinancialTransactionTableModel tableModel = (FinancialTransactionTableModel)this.getModel();
        Column columnTable = tableModel.getColumn(column);
        TableCellRenderer renderer = columnTable.getCellRenderer(row);
        if (renderer == null) {
            renderer = super.getCellRenderer(row, column);
        }
        return renderer;
    }

    @Override
    public TableCellEditor getCellEditor(int row, int column) {
        FinancialTransactionTableModel tableModel = (FinancialTransactionTableModel)this.getModel();
        Column columnTable = tableModel.getColumn(column);
        TableCellEditor editor = columnTable.getCellEditor(row);
        if (editor == null) {
            editor = super.getCellEditor(row, column);
        }
        return editor;
    }

    private class MyMouseAdapter
    extends MouseAdapter {
        private MyMouseAdapter() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (FinancialTransactionUnbalancedTable.this.rowAtPoint(e.getPoint()) == -1) {
                FinancialTransactionUnbalancedTable.this.clearSelection();
            }
        }
    }
}

