/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.financialtransaction;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.business.api.FinancialTransactionService;
import org.chorem.lima.business.utils.EntryComparator;
import org.chorem.lima.business.utils.FinancialTransactionComparator;
import org.chorem.lima.entity.Entry;
import org.chorem.lima.entity.EntryImpl;
import org.chorem.lima.entity.FinancialTransaction;
import org.chorem.lima.entity.FinancialTransactionImpl;
import org.chorem.lima.service.LimaServiceFactory;
import org.chorem.lima.ui.common.Column;
import org.chorem.lima.ui.common.TableModelWithGroup;
import org.chorem.lima.ui.financialtransaction.AccountColumn;
import org.chorem.lima.ui.financialtransaction.CreditColumn;
import org.chorem.lima.ui.financialtransaction.DateColumn;
import org.chorem.lima.ui.financialtransaction.DebitColumn;
import org.chorem.lima.ui.financialtransaction.DescriptionColumn;
import org.chorem.lima.ui.financialtransaction.VoucherColumn;

public class FinancialTransactionTableModel
extends AbstractTableModel
implements TableModelWithGroup {
    private static final long serialVersionUID = -7495388454688562991L;
    protected static final Log log = LogFactory.getLog(FinancialTransactionTableModel.class);
    protected FinancialTransactionService financialTransactionService;
    protected List<Column> columns = new ArrayList<Column>();
    protected List<Entry> entries;
    protected List<FinancialTransaction> transactions;

    public FinancialTransactionTableModel() {
        this.initColumns();
        this.financialTransactionService = (FinancialTransactionService)LimaServiceFactory.getService(FinancialTransactionService.class);
        this.entries = new ArrayList<Entry>();
        this.transactions = new ArrayList<FinancialTransaction>();
    }

    protected void initColumns() {
        this.columns.add(new DateColumn(this));
        this.columns.add(new VoucherColumn(this));
        this.columns.add(new AccountColumn(this));
        this.columns.add(new DescriptionColumn(this));
        this.columns.add(new DebitColumn(this));
        this.columns.add(new CreditColumn(this));
    }

    public Column getColumn(int column) {
        return this.columns.get(column);
    }

    public void setTransactions(List<FinancialTransaction> transactions) {
        this.transactions.clear();
        this.transactions.addAll(transactions);
        this.sortEntries();
    }

    public void sortEntries() {
        Collections.sort(this.transactions, new FinancialTransactionComparator());
        this.entries.clear();
        for (FinancialTransaction transaction : this.transactions) {
            if (transaction.sizeEntry() > 0) {
                ArrayList entries = new ArrayList(transaction.getEntry());
                Collections.sort(entries, new EntryComparator());
                this.entries.addAll(entries);
                continue;
            }
            EntryImpl entry = new EntryImpl();
            entry.setFinancialTransaction(transaction);
            entry = this.financialTransactionService.createEntry((Entry)entry);
            transaction.addEntry((Entry)entry);
            this.financialTransactionService.updateFinancialTransaction(transaction);
            this.entries.add((Entry)entry);
        }
        this.fireTableDataChanged();
    }

    @Override
    public int getColumnCount() {
        return this.columns.size();
    }

    @Override
    public int getRowCount() {
        return this.entries.size();
    }

    @Override
    public Class<?> getColumnClass(int column) {
        Class<?> result = null;
        if (column >= 0 && column < this.columns.size()) {
            result = this.columns.get(column).getColumnClass();
        }
        return result;
    }

    @Override
    public String getColumnName(int column) {
        String result = "n/a";
        if (column >= 0 && column < this.columns.size()) {
            result = this.columns.get(column).getColumnName();
        }
        return result;
    }

    @Override
    public Object getValueAt(int row, int column) {
        Object result = null;
        if (column >= 0 && column < this.columns.size()) {
            result = this.columns.get(column).getValueAt(row);
        }
        return result;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        boolean result = false;
        if (column >= 0 && column < this.columns.size()) {
            result = this.columns.get(column).isCellEditable(row);
        }
        return result;
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        boolean update = false;
        if (column >= 0 && column < this.columns.size()) {
            update = this.columns.get(column).setValueAt(value, row);
        }
        if (update) {
            this.fireTableCellUpdated(row, column);
        }
    }

    public Entry getEntryAt(int row) {
        return this.entries.get(row);
    }

    public FinancialTransaction getTransactionAt(int row) {
        Entry entry = this.entries.get(row);
        return entry.getFinancialTransaction();
    }

    public int indexOf(Entry entry) {
        return this.entries.indexOf(entry);
    }

    public int indexOf(FinancialTransaction transaction) {
        int index = 0;
        Collection entriesTransaction = transaction.getEntry();
        for (Entry entry : this.entries) {
            if (entriesTransaction.contains(entry)) break;
            ++index;
        }
        return index;
    }

    public Entry addEntry(Entry entry) {
        EntryImpl newEntry = null;
        FinancialTransaction transaction = entry.getFinancialTransaction();
        if (this.transactions.contains(transaction)) {
            newEntry = new EntryImpl();
            newEntry.setFinancialTransaction(transaction);
            newEntry.setVoucher(entry.getVoucher());
            newEntry.setAccount(entry.getAccount());
            newEntry.setDescription(entry.getDescription());
            newEntry.setAmount(entry.getAmount());
            newEntry.setDebit(entry.getDebit());
            newEntry = this.financialTransactionService.createEntry((Entry)newEntry);
            transaction.addEntry((Entry)newEntry);
            this.financialTransactionService.updateFinancialTransaction(transaction);
            int row = this.indexOf(transaction) + transaction.sizeEntry() - 1;
            this.entries.add(row, (Entry)newEntry);
            this.fireTableRowsInserted(row, row);
        }
        return newEntry;
    }

    public void removeTransaction(int row) {
        FinancialTransaction transaction = this.getTransactionAt(row);
        int firstRow = this.indexOf(transaction);
        int lastRow = firstRow + transaction.sizeEntry() - 1;
        this.financialTransactionService.removeFinancialTransaction(transaction);
        this.entries.removeAll(transaction.getEntry());
        this.transactions.remove(transaction);
        this.fireTableRowsDeleted(firstRow, lastRow);
    }

    public void removeEntry(int row) {
        Entry entry = this.getEntryAt(row);
        FinancialTransaction transaction = entry.getFinancialTransaction();
        if (transaction.sizeEntry() > 1) {
            this.financialTransactionService.removeEntry(entry);
            transaction.removeEntry(entry);
            this.entries.remove(entry);
        } else {
            this.financialTransactionService.removeFinancialTransaction(transaction);
            this.entries.removeAll(transaction.getEntry());
            this.transactions.remove(transaction);
        }
        this.fireTableRowsDeleted(row, row);
    }

    public FinancialTransaction addTransaction(FinancialTransaction transaction) {
        FinancialTransactionImpl newTransaction = new FinancialTransactionImpl();
        newTransaction.setEntryBook(transaction.getEntryBook());
        newTransaction.setTransactionDate(transaction.getTransactionDate());
        newTransaction = this.financialTransactionService.createFinancialTransaction((FinancialTransaction)newTransaction);
        if (transaction.getEntry() == null || transaction.getEntry().isEmpty()) {
            EntryImpl newEntry = new EntryImpl();
            newEntry.setFinancialTransaction((FinancialTransaction)newTransaction);
            newEntry = this.financialTransactionService.createEntry((Entry)newEntry);
            newTransaction.addEntry((Entry)newEntry);
            newEntry = new EntryImpl();
            newEntry.setFinancialTransaction((FinancialTransaction)newTransaction);
            newEntry = this.financialTransactionService.createEntry((Entry)newEntry);
            newTransaction.addEntry((Entry)newEntry);
        } else {
            for (Entry entry : transaction.getEntry()) {
                EntryImpl newEntry = new EntryImpl();
                newEntry.setFinancialTransaction((FinancialTransaction)newTransaction);
                newEntry.setVoucher(entry.getVoucher());
                newEntry.setAccount(entry.getAccount());
                newEntry.setDescription(entry.getDescription());
                newEntry.setAmount(entry.getAmount());
                newEntry.setDebit(entry.getDebit());
                newEntry = this.financialTransactionService.createEntry((Entry)newEntry);
                newTransaction.addEntry((Entry)newEntry);
            }
            this.financialTransactionService.updateFinancialTransaction((FinancialTransaction)newTransaction);
        }
        int indexFirstEntry = this.entries.size();
        this.transactions.add((FinancialTransaction)newTransaction);
        this.entries.addAll(newTransaction.getEntry());
        int indexLastEntry = this.entries.size() - 1;
        this.fireTableRowsInserted(indexFirstEntry, indexLastEntry);
        return newTransaction;
    }

    public BigDecimal getBalanceTransactionInRow(int row) {
        FinancialTransaction transaction = this.getTransactionAt(row);
        BigDecimal debit = transaction.getAmountDebit();
        BigDecimal credit = transaction.getAmountCredit();
        BigDecimal balance = debit.subtract(credit);
        return balance;
    }

    public int size() {
        int result = 0;
        if (this.entries != null) {
            result = this.entries.size();
        }
        return result;
    }

    @Override
    public int indexGroupAt(int row) {
        FinancialTransaction transaction = this.getTransactionAt(row);
        int index = this.transactions.indexOf(transaction);
        return index;
    }

    public void updateEntry(Entry entry) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Update Entry");
        }
        this.financialTransactionService.updateEntry(entry);
    }

    public void updateTransaction(FinancialTransaction transaction) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Update transaction");
        }
        this.financialTransactionService.updateFinancialTransaction(transaction);
    }

    public void fireTransaction(FinancialTransaction transaction) {
        int firstRow = this.indexOf(transaction);
        int lastRow = firstRow + transaction.sizeEntry() - 1;
        this.fireTableRowsUpdated(firstRow, lastRow);
    }
}

