/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.financialtransaction;

import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.entity.FinancialTransaction;
import org.chorem.lima.ui.financialtransaction.FinancialTransactionDefaultTable;
import org.chorem.lima.ui.financialtransaction.FinancialTransactionTableModel;
import org.chorem.lima.ui.financialtransaction.FinancialTransactionViewHandler;

public class FinancialTransactionTable
extends FinancialTransactionDefaultTable {
    private static final long serialVersionUID = 3133690382049594727L;
    private static final Log log = LogFactory.getLog(FinancialTransactionTable.class);
    protected final FinancialTransactionViewHandler handler;

    public FinancialTransactionTable(FinancialTransactionViewHandler handler) {
        this.handler = handler;
    }

    @Override
    protected void initNavigation() {
        super.initNavigation();
        InputMap inputMap = this.getInputMap(1);
        ActionMap actionMap = this.getActionMap();
        Object binding = inputMap.get(KeyStroke.getKeyStroke(9, 0));
        actionMap.put(binding, new NextCellAction());
    }

    private class NextCellAction
    extends AbstractAction {
        FinancialTransactionTable table;

        private NextCellAction() {
            this.table = FinancialTransactionTable.this;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Key tab used");
            }
            FinancialTransactionTable.this.exit();
            int nbColumn = FinancialTransactionTable.this.getColumnCount();
            int nbRows = FinancialTransactionTable.this.getRowCount();
            int column = FinancialTransactionTable.this.getSelectedColumn();
            int row = FinancialTransactionTable.this.getSelectedRow();
            if (column >= 0 && row >= 0) {
                boolean end = false;
                FinancialTransactionTableModel tableModel = (FinancialTransactionTableModel)FinancialTransactionTable.this.getModel();
                FinancialTransaction transaction = tableModel.getTransactionAt(row);
                do {
                    if (column >= nbColumn - 1) {
                        if (row >= nbRows - 1 || transaction != tableModel.getTransactionAt(row + 1)) {
                            BigDecimal debit;
                            BigDecimal credit = transaction.getAmountCredit();
                            if (credit.compareTo(debit = transaction.getAmountDebit()) != 0) {
                                this.table.handler.addEntry();
                                column = 2;
                                ++row;
                                end = true;
                                continue;
                            }
                            if (row >= nbRows - 1) {
                                this.table.handler.addFinancialTransaction();
                                column = 0;
                                ++row;
                                end = true;
                                continue;
                            }
                            column = 0;
                            ++row;
                            continue;
                        }
                        column = 0;
                        ++row;
                        continue;
                    }
                    ++column;
                } while (!end && !tableModel.isCellEditable(row, column));
                FinancialTransactionTable.this.changeSelection(row, column, false, false);
            }
        }
    }
}

